/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.server;

import gov.nasa.giss.panoply.server.PanProtocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ServerSocket serverSocket_;
    private static boolean listening_;
    private static boolean exists_;

    public static PanServer getSharedInstance() {
        PanServer instance = Singleton.INSTANCE;
        exists_ = true;
        return instance;
    }

    public static boolean instanceExists() {
        return exists_;
    }

    private PanServer() {
    }

    public void start() throws IOException {
        if (listening_) {
            throw new IllegalStateException("PanServer is already running.");
        }
        serverSocket_ = new ServerSocket(2880);
        listening_ = true;
        new Thread("client listener"){

            @Override
            public void run() {
                while (listening_) {
                    try {
                        1.sleep(400L);
                        PanServer.this.listenForClient();
                    }
                    catch (Exception exc) {
                        if (!listening_) continue;
                        LOGGER.error("Client socket error.");
                        if (!LOGGER.isTraceEnabled()) continue;
                        exc.printStackTrace();
                    }
                }
            }
        }.start();
    }

    private final void listenForClient() throws IOException {
        String input;
        Socket socket = serverSocket_.accept();
        PrintWriter toClient = new PrintWriter(socket.getOutputStream(), true);
        BufferedReader fromClient = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        PanProtocol protocol = new PanProtocol();
        String output = protocol.processInput(null);
        LOGGER.trace("send to client '{}'", (Object)output);
        toClient.println(output);
        while ((input = fromClient.readLine()) != null) {
            LOGGER.trace("rec from client '{}'", (Object)input);
            output = protocol.processInput(input);
            LOGGER.trace("send to client '{}'", (Object)output);
            toClient.println(output);
            if (!input.equalsIgnoreCase("bye.") && !output.equalsIgnoreCase("bye.")) continue;
        }
        fromClient.close();
        toClient.close();
        socket.close();
    }

    public boolean isListening() {
        return listening_;
    }

    public void close() throws IOException {
        if (listening_) {
            listening_ = false;
            serverSocket_.close();
        }
    }

    private static class Singleton {
        private static final PanServer INSTANCE = new PanServer();

        private Singleton() {
        }
    }
}

