/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.util;

import gov.nasa.giss.io.FileUtils;
import gov.nasa.giss.panoply.prefs.PanPreferences;
import gov.nasa.giss.panoply.prefsui.PanPreferencesFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.util.EasyXmlParser;
import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.JDOMParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PanVersionUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int NEXT_DAYS_GOOD = 15;
    private static final int NEXT_DAYS_BAD = 7;
    private static final int MIN_LAUNCHES = 5;
    private static final DateTimeFormatter DFORMAT_8 = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter DFORMAT_10 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final PanPreferences PREFS = PanPreferences.getSharedInstance();
    private static boolean webChecked_;
    private static String webVersion_;
    private static String webBuild_;
    private static String webDate_;
    private static String webAddress_;

    public static PanVersionUtils getSharedInstance() {
        return Singleton.INSTANCE;
    }

    public boolean isTimeForCheck() {
        LocalDate nextDate;
        block9: {
            if (!PREFS.getBoolean("app:version.enabled")) {
                return false;
            }
            int icount = PREFS.getInt("app:version.count");
            LOGGER.trace("Version check count = {}", (Object)icount);
            if (icount < 5) {
                LOGGER.trace("Not enough launches. Skipping date test");
                PREFS.setInt("app:version.count", icount + 1);
                return false;
            }
            PREFS.setInt("app:version.count", 0);
            String lastStr = PREFS.getString("app:version.last");
            String nextStr = PREFS.getString("app:version.next");
            LOGGER.trace("Last version check was {}, next is after {}", (Object)lastStr, (Object)nextStr);
            nextDate = LocalDate.now();
            try {
                if (nextStr.length() == 8) {
                    nextDate = LocalDate.parse(nextStr, DFORMAT_8);
                } else if (nextStr.length() == 10) {
                    nextDate = LocalDate.parse(nextStr, DFORMAT_10);
                } else {
                    LOGGER.debug("Date string has unexpected character count");
                }
            }
            catch (Exception exc) {
                LOGGER.debug("Error parsing date string '{}'", (Object)nextStr);
                if (!LOGGER.isTraceEnabled()) break block9;
                exc.printStackTrace();
            }
        }
        LOGGER.trace("next {}", (Object)nextDate);
        if (nextDate == null) {
            LOGGER.trace("Next version check date is null.");
            return false;
        }
        LocalDate today = LocalDate.now();
        LOGGER.trace("today {}", (Object)today);
        long diffDays = ChronoUnit.DAYS.between(nextDate, today);
        LOGGER.trace("Diff days {} -- Time to check: {}", (Object)diffDays, (Object)(diffDays > 0L ? 1 : 0));
        return diffDays >= 0L;
    }

    public void checkForUpdate(boolean reportNull, boolean allowSkip) {
        LOGGER.trace("reportNull? {}", (Object)reportNull);
        EventQueue.invokeLater(() -> {
            if (!webChecked_) {
                String address = PanProperties.VERSION_PROPS.getString("version-url");
                boolean success = this.loadWebInfo(address);
                LOGGER.trace("loadWebInfo? {}", (Object)success);
                if (success) {
                    webChecked_ = true;
                } else {
                    PanVersionUtils.updatePrefs(7);
                    if (reportNull) {
                        PanVersionUtils.showNullMessage("I was unable to connect to the NASA/GISS website to obtain\nversion information. This could be due to network trouble,\nserver error, etc. Please wait and try again later.");
                    }
                    return;
                }
            }
            this.compareBuilds(reportNull, allowSkip);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean loadWebInfo(String address) {
        Objects.requireNonNull(address, "XML address must not be null");
        LOGGER.trace("Trying to load {}", (Object)address);
        try {
            URL url = new URL(address);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(6000);
            conn.setReadTimeout(2000);
            conn.setRequestProperty("User-Agent", PanUtils.getUserAgent());
            int httpCode = 0;
            String moved = "";
            Map<String, List<String>> map = conn.getHeaderFields();
            Set<Map.Entry<String, List<String>>> eset = map.entrySet();
            for (Map.Entry<String, List<String>> entry : eset) {
                String sval;
                String key = entry.getKey();
                List<String> val = entry.getValue();
                String string = sval = val == null ? "" : val.toString();
                if (key == null && sval.indexOf("HTTP/1.") > -1) {
                    String codeStr = sval.replaceFirst("^.*HTTP/\\d\\.\\d ", "");
                    codeStr = codeStr.replaceFirst(" .*", "");
                    httpCode = Integer.parseInt(codeStr);
                    continue;
                }
                if (!"Location".equals(key) || sval.length() <= 2) continue;
                moved = sval.substring(1, sval.length() - 1);
            }
            if (httpCode != 200) {
                if (httpCode == 301 || httpCode == 302) {
                    LOGGER.trace("Version file has apparently MOVED to '{}'", (Object)moved);
                    return this.loadWebInfo(moved);
                }
                if (httpCode == 403) {
                    LOGGER.warn("Version file DENIED by permissions");
                    return false;
                }
                if (httpCode == 404) {
                    LOGGER.warn("Version file NOT FOUND at '{}'", (Object)address);
                    return false;
                }
                LOGGER.warn("Unexpected HTTP response, status '{}'", (Object)httpCode);
                return false;
            }
            LOGGER.trace("Looks like GOOD response.");
            Object content = conn.getContent();
            if (content == null) {
                LOGGER.debug("Content is null");
                return false;
            }
            if (content instanceof InputStream) {
                this.parse((InputStream)content);
                return true;
            }
            if (!(content instanceof String)) return false;
        }
        catch (ConnectException exc) {
            LOGGER.warn("Server apparently denied connection.");
            return false;
        }
        catch (SocketTimeoutException exc) {
            LOGGER.warn("Connection timed out.");
            return false;
        }
        catch (FileNotFoundException exc) {
            LOGGER.warn("Version file not found on server.");
            return false;
        }
        catch (JDOMParseException exc) {
            LOGGER.warn("Got version file but could not parse it.");
            if (!LOGGER.isTraceEnabled()) return false;
            exc.printStackTrace();
            return false;
        }
        catch (Exception exc) {
            LOGGER.warn("Failed. Exception reported: {}", (Object)exc.toString());
            if (!LOGGER.isTraceEnabled()) return false;
            exc.printStackTrace();
        }
        return false;
    }

    private final void parse(InputStream is) throws IOException, JDOMException {
        Document document = EasyXmlParser.parseDocument(is);
        Element root = document.getRootElement();
        if (!"versioninfo".equals(root.getName())) {
            throw new IllegalArgumentException("File root element is not 'versioninfo'.");
        }
        for (Element child : root.getChildren()) {
            Attribute aa;
            String childName = child.getName();
            if ("version".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webVersion_ = aa.getValue();
                LOGGER.trace("webVersion {}", (Object)webVersion_);
                continue;
            }
            if ("build".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webBuild_ = aa.getValue();
                LOGGER.trace("webBuild {}", (Object)webBuild_);
                continue;
            }
            if ("date".equals(childName)) {
                aa = child.getAttribute("value");
                if (aa == null) continue;
                webDate_ = aa.getValue();
                LOGGER.trace("webDate {}", (Object)webDate_);
                continue;
            }
            if (!"address".equals(childName) || (aa = child.getAttribute("value")) == null) continue;
            webAddress_ = aa.getValue();
            LOGGER.trace("downloadAddress {}", (Object)webAddress_);
        }
    }

    private void compareBuilds(boolean reportNull, boolean allowSkip) {
        LOGGER.trace("webBuild {}", (Object)webBuild_);
        if (webBuild_ == null) {
            PanVersionUtils.updatePrefs(7);
            if (reportNull) {
                PanVersionUtils.showNullMessage("I was unable to parse Panoply version info received from\nthe NASA GISS website.");
            }
            return;
        }
        String thisBuild = PanProperties.VERSION_PROPS.getString("build-id");
        boolean updateAvailable = false;
        if (webBuild_.length() > thisBuild.length() || thisBuild.compareToIgnoreCase(webBuild_) < 0) {
            String skipBuld = PREFS.getString("app:version.skip");
            LOGGER.trace("Build on web is newer: {} > {}", (Object)webBuild_, (Object)thisBuild);
            LOGGER.trace("Skip? {}, {}, {}", allowSkip, webBuild_, skipBuld);
            if (allowSkip && webBuild_.equalsIgnoreCase(skipBuld)) {
                LOGGER.trace("Previously opted to skip this particular update");
                updateAvailable = false;
            } else {
                updateAvailable = true;
            }
        } else if (thisBuild.equals(webBuild_)) {
            LOGGER.trace("Build on web is same: {}", (Object)webBuild_);
        } else {
            LOGGER.trace("Build on web is older? {} < {}", (Object)webBuild_, (Object)thisBuild);
        }
        if (updateAvailable) {
            PanVersionUtils.showUpdateMessage();
            return;
        }
        PanVersionUtils.updatePrefs(15);
        if (reportNull) {
            PanVersionUtils.showNullMessage("This copy of Panoply is up to date.");
        }
    }

    private static void updatePrefs(int nextOffset) {
        PREFS.set("app:version.last", PanVersionUtils.getDayString(0));
        PREFS.set("app:version.next", PanVersionUtils.getDayString(nextOffset));
        if (PanPreferencesFrame.instanceExists()) {
            PanPreferencesFrame.getSharedInstance().refresh();
        }
    }

    private static String getDayString(int offset) {
        LocalDate offsetLDT = LocalDate.now().plusDays(offset);
        return DFORMAT_10.format(offsetLDT);
    }

    private static void showUpdateMessage() {
        EventQueue.invokeLater(() -> {
            block4: {
                JFrame jf = GuiUtils.getActiveFrame();
                if (jf == null) {
                    LOGGER.debug("Active window is null.");
                    return;
                }
                Object[] options = new String[]{"Get Update", "Later"};
                int choice = JOptionPane.showOptionDialog(jf, "A new version of Panoply is now available. Would you like to\ndownload version " + webVersion_ + " from the NASA/GISS website?", "Update Available", 0, 3, null, options, options[0]);
                if (choice == 0) {
                    try {
                        FileUtils.openBrowserURL(webAddress_);
                        PanVersionUtils.updatePrefs(15);
                        return;
                    }
                    catch (Exception exc) {
                        LOGGER.error("Could not open URL do to exception: {}", (Object)exc.toString());
                        if (!LOGGER.isTraceEnabled()) break block4;
                        exc.printStackTrace();
                    }
                }
            }
            PanVersionUtils.updatePrefs(7);
        });
    }

    public static void showNullMessage(String message) {
        EventQueue.invokeLater(() -> {
            JFrame jf = GuiUtils.getActiveFrame();
            if (jf == null) {
                LOGGER.debug("Active window is null.");
                return;
            }
            JOptionPane.showMessageDialog(jf, message, "Check for Updates", 2);
        });
    }

    private PanVersionUtils() {
    }

    private static class Singleton {
        private static final PanVersionUtils INSTANCE = new PanVersionUtils();

        private Singleton() {
        }
    }
}

