/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import gov.nasa.giss.time.JulianType;
import java.lang.invoke.MethodHandles;
import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JulianDate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double TT_MINUS_TAI = 32.184;
    private static final double[][] TAI_MINUS_UTC = new double[][]{{2441317.5, 10.0}, {2441499.5, 11.0}, {2441683.5, 12.0}, {2442048.5, 13.0}, {2442413.5, 14.0}, {2442778.5, 15.0}, {2443144.5, 16.0}, {2443509.5, 17.0}, {2443874.5, 18.0}, {2444239.5, 19.0}, {2444786.5, 20.0}, {2445151.5, 21.0}, {2445516.5, 22.0}, {2446247.5, 23.0}, {2447161.5, 24.0}, {2447892.5, 25.0}, {2448257.5, 26.0}, {2448804.5, 27.0}, {2449169.5, 28.0}, {2449534.5, 29.0}, {2450083.5, 30.0}, {2450630.5, 31.0}, {2451179.5, 32.0}, {2453736.5, 33.0}, {2454832.5, 34.0}, {2456109.5, 35.0}, {2457204.5, 36.0}, {2457754.5, 37.0}};
    protected static final DecimalFormat FORMAT_03 = new DecimalFormat("0.000");
    protected static final DecimalFormat FORMAT_05 = new DecimalFormat("0.00000");
    protected static final DecimalFormat FORMAT_06 = new DecimalFormat("0.000000");
    protected static final DecimalFormat FORMAT_08 = new DecimalFormat("0.00000000");
    protected static final DecimalFormat FORMAT_10 = new DecimalFormat("0");
    protected static final DecimalFormat FORMAT_20 = new DecimalFormat("00");
    private static final double MJD_0 = 2400000.5;
    private static final double JD_UNIX = 2440587.5;
    private static final double JD_2000 = 2451545.0;
    private static final long SECS_PER_DAY = 86400L;
    private static final double DAYS_PER_SEC = 1.1574074074074073E-5;
    protected long unixMillis_;
    private double j2000secs_;
    private double jdUTC_;
    protected double jdTT_;
    protected double delta2000_;
    protected double jcent_;
    protected double jmil_;

    public JulianDate() {
        this(System.currentTimeMillis());
    }

    public JulianDate(long millis) {
        this.setMillis(millis);
    }

    public void setMillis(long millis) {
        double utc2tt;
        double ut2000Secs;
        block3: {
            block2: {
                this.unixMillis_ = millis;
                ut2000Secs = (double)this.unixMillis_ * 0.001 - 9.46728E8;
                this.jdUTC_ = 2440587.5 + (double)millis * 1.1574074074074074E-8;
                utc2tt = 0.0;
                if (!(this.jdUTC_ < TAI_MINUS_UTC[0][0])) break block2;
                double d2000 = this.jdUTC_ - 2451545.0;
                double c = d2000 / 36525.0;
                double c2 = c * c;
                utc2tt = 64.184 + 59.0 * c - 51.2 * c2 - 67.1 * c * c2 - 16.4 * c2 * c2;
                if (!(utc2tt > 32.184 + TAI_MINUS_UTC[0][1])) break block3;
                utc2tt = 32.184 + TAI_MINUS_UTC[0][1];
                break block3;
            }
            for (int i = TAI_MINUS_UTC.length - 1; i >= 0; --i) {
                if (!(this.jdUTC_ >= TAI_MINUS_UTC[i][0])) continue;
                utc2tt = 32.184 + TAI_MINUS_UTC[i][1];
                break;
            }
        }
        this.jdTT_ = this.jdUTC_ + utc2tt * 1.1574074074074073E-5;
        this.delta2000_ = this.jdTT_ - 2451545.0;
        this.j2000secs_ = ut2000Secs + utc2tt;
        this.jcent_ = this.delta2000_ / 36525.0;
        this.jmil_ = this.delta2000_ / 365250.0;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.trace("----");
            LOGGER.trace("A-1: millis       = {}", (Object)FORMAT_10.format(millis));
            LOGGER.trace("xxx: ut2000Secs   = {}", (Object)FORMAT_03.format(ut2000Secs));
            LOGGER.trace("A-2: jdUTC_       = {}", (Object)FORMAT_08.format(this.jdUTC_));
            LOGGER.trace("A-4: utc2tt       = {}", (Object)FORMAT_08.format(utc2tt));
            LOGGER.trace("A-5: jdTT_        = {}", (Object)FORMAT_08.format(this.jdTT_));
            LOGGER.trace("A-6: delta2000_   = {}", (Object)FORMAT_08.format(this.delta2000_));
            LOGGER.trace("xxx: j2000secs_   = {}", (Object)FORMAT_03.format(this.j2000secs_));
        }
    }

    public long getMillis() {
        return this.unixMillis_;
    }

    public double getDay() {
        return this.jdUTC_;
    }

    public double getDay(JulianType jtype) {
        switch (jtype) {
            case SIMPLE: {
                return this.jdUTC_;
            }
            case J2000: {
                return this.jdUTC_ - 2451545.0;
            }
            case MODIFIED: {
                return this.jdUTC_ - 2400000.5;
            }
            case UNIX: {
                return this.jdUTC_ - 2440587.5;
            }
        }
        throw new IllegalArgumentException("No switch case for JulianType");
    }

    public double getDayTT() {
        return this.jdTT_;
    }

    public double getDayTT(JulianType jtype) {
        switch (jtype) {
            case SIMPLE: {
                return this.jdTT_;
            }
            case J2000: {
                return this.delta2000_;
            }
            case MODIFIED: {
                return this.jdTT_ - 2400000.5;
            }
            case UNIX: {
                return this.jdTT_ - 2440587.5;
            }
        }
        throw new IllegalArgumentException("No switch case for JulianType");
    }

    public double getJ2000Seconds() {
        return this.j2000secs_;
    }
}

