/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public final class UTParser {
    private static final DateFormat[] DATE_FORMATS = new DateFormat[]{DateFormat.getDateTimeInstance(), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(1, 1), new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MMM-dd HH:mm"), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd HH:mm"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm"), new SimpleDateFormat("yyyy-DDD HH:mm:ss"), new SimpleDateFormat("yyyy-DDD HH:mm"), new SimpleDateFormat("yyyy MMM dd HH:mm:ss"), new SimpleDateFormat("yyyy MMM dd HH:mm"), new SimpleDateFormat("dd MMM yyyy HH:mm:ss"), new SimpleDateFormat("dd MMM yyyy HH:mm"), new SimpleDateFormat("dd MMM yyyy hh:mm:ss aa"), new SimpleDateFormat("dd MMM yyyy hh:mm aa"), new SimpleDateFormat("dd MMM yyyy, HH:mm:ss"), new SimpleDateFormat("dd MMM yyyy, HH:mm"), new SimpleDateFormat("dd MMM yyyy, hh:mm:ss aa"), new SimpleDateFormat("dd MMM yyyy, hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy HH:mm:ss"), new SimpleDateFormat("MMM dd, yyyy HH:mm"), new SimpleDateFormat("MMM dd, yyyy, HH:mm:ss"), new SimpleDateFormat("MMM dd, yyyy, HH:mm"), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa"), new SimpleDateFormat("MMM dd, yyyy hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy, hh:mm:ss aa"), new SimpleDateFormat("MMM dd, yyyy, hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy hh:mm:ss aa"), new SimpleDateFormat("MMM dd, yyyy hh:mm aa"), new SimpleDateFormat("MMM dd, yyyy, hh:mm:ss aa"), new SimpleDateFormat("MMM dd, yyyy, hh:mm aa")};
    private static boolean initialized_;

    private UTParser() {
        UTParser.initialize();
    }

    private static void initialize() {
        for (DateFormat df : DATE_FORMATS) {
            df.setTimeZone(new SimpleTimeZone(0, "GMT+0:00"));
            df.setLenient(true);
        }
        initialized_ = true;
    }

    public static Date parse(String dateTimeStr) {
        if (!initialized_) {
            UTParser.initialize();
        }
        Date date = null;
        for (DateFormat df : DATE_FORMATS) {
            try {
                date = df.parse(dateTimeStr);
                break;
            }
            catch (Exception exception) {
            }
        }
        return date;
    }

    public static Date parse(String dateStr, String timeStr) {
        String xtimeStr = timeStr;
        if (xtimeStr.matches("\\d")) {
            xtimeStr = "0" + xtimeStr + ":00:00";
        } else if (xtimeStr.matches("(\\d){2}")) {
            xtimeStr = xtimeStr + ":00:00";
        } else if (xtimeStr.matches("(\\d){4}")) {
            xtimeStr = xtimeStr.substring(0, 2) + ':' + xtimeStr.substring(2);
        } else if (xtimeStr.matches("(\\d){6}")) {
            xtimeStr = xtimeStr.substring(0, 2) + ':' + xtimeStr.substring(2, 4) + ':' + xtimeStr.substring(4);
        }
        return UTParser.parse(dateStr + " " + xtimeStr);
    }
}

