/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.mission;

public enum MarsLanderID {
    VL1("Vl1", "Viking Lander 1"),
    VL2("VL2", "Viking Lander 2"),
    MPF("MPF", "Mars Pathfinder"),
    MERA("MERA", "MER-A Spirit"),
    MERB("MERB", "MER-B Opportunity"),
    PHX("PHX", "Mars Phoenix"),
    MSL("MSL", "MSL Curiosity"),
    NSYT("NSYT", "Mars InSight");

    private String id_;
    private String text_;

    private MarsLanderID(String id, String text) {
        this.id_ = id;
        this.text_ = text;
    }

    public String getID() {
        return this.id_;
    }

    public String toString() {
        return this.text_;
    }

    public boolean matches(String text) {
        return this.idMatches(text) | this.nameMatches(text);
    }

    public boolean idMatches(String text) {
        return this.id_.equalsIgnoreCase(text);
    }

    public boolean nameMatches(String text) {
        return this.text_.equalsIgnoreCase(text);
    }

    public static MarsLanderID matching(String s) {
        for (MarsLanderID id : MarsLanderID.values()) {
            if (!id.matches(s)) continue;
            return id;
        }
        return null;
    }
}

