/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.time.planet;

import gov.nasa.giss.math.PointLL;
import gov.nasa.giss.time.ClockType;
import gov.nasa.giss.time.mission.MissionTime;
import gov.nasa.giss.time.planet.AbstractPlanetTime;
import gov.nasa.giss.time.planet.DistanceUnits;
import gov.nasa.giss.time.planet.PlanetID;
import gov.nasa.giss.time.planet.PlanetTime;
import java.awt.geom.Point2D;
import java.util.Objects;

public class TitanTime
extends AbstractPlanetTime {
    public static final double SOLS_PER_DAY = 15.96913;
    private double eccentricityP_;
    private double meanAnomalyP_;
    private double equationOfCenterP_;
    private double subprimaryLon_;
    private double subprimaryLat_;
    private double rPrimaryKm_;
    protected PlanetTime saturnTime_;

    public TitanTime() {
        this(System.currentTimeMillis());
    }

    public TitanTime(long millis) {
        super(millis);
        this.calculate();
        this.pmTimeSuffix_ = "TMT";
        this.saturnTime_ = new PlanetTime(PlanetID.SATURN, millis);
    }

    @Override
    public void setMillis(long millis) {
        super.setMillis(millis);
        if (this.saturnTime_ != null) {
            this.saturnTime_.setMillis(millis);
        }
    }

    @Override
    protected void calculate() {
        double declinSPC;
        double jcent2 = this.jcent_ * this.jcent_;
        double jcent3 = this.jcent_ * jcent2;
        this.meanAnomaly_ = 316.914 + 1222.081 * this.jcent_ + 0.021 * jcent2 - 0.04 * jcent3;
        this.meanAnomalyRad_ = this.meanAnomaly_ * (Math.PI / 180);
        double sin1M = Math.sin(this.meanAnomalyRad_);
        double sin2M = Math.sin(2.0 * this.meanAnomalyRad_);
        double sin3M = Math.sin(3.0 * this.meanAnomalyRad_);
        this.alphaFMS_ = 236.638 + 1223.222 * this.jcent_ - 0.062 * jcent2 - 0.125 * jcent3;
        this.obliquity_ = 26.401 - 0.069 * this.jcent_ - 0.123 * jcent2 + 0.011 * jcent3;
        double obliquityRad = this.obliquity_ * (Math.PI / 180);
        double sinObliquity = Math.sin(obliquityRad);
        this.veeM_ = 321.178 + 824624.549 * this.jcent_ - 0.075 * jcent2 - 0.076 * jcent3;
        this.ellSP_ = 279.724 + 1.141 * this.jcent_ - 0.083 * jcent2 - 0.085 * jcent3;
        double equationOfCenter = (6.36 - 0.04 * this.jcent_) * sin1M + 0.22 * sin2M + 0.01 * sin3M + 0.19 * Math.cos(Math.PI / 180 * (24.1 + 1182.4 * this.jcent_)) + 0.12 * Math.cos(Math.PI / 180 * (13.9 + 591.2 * this.jcent_)) + 0.04 * Math.sin(Math.PI / 180 * (this.veeM_ - this.alphaFMS_));
        this.ellS_ = this.alphaFMS_ + equationOfCenter;
        this.ellSRad_ = this.ellS_ * (Math.PI / 180);
        this.cosEllS_ = Math.cos(this.ellSRad_);
        this.sinEllS_ = Math.sin(this.ellSRad_);
        double alphaS = this.ellS_ - 3.152 * Math.sin(2.0 * this.ellSRad_) + 0.087 * Math.sin(4.0 * this.ellSRad_) - 0.003 * Math.sin(6.0 * this.ellSRad_);
        this.eotDegrees_ = 0.0;
        this.eotHours_ = this.eotDegrees_ * 0.06666666666666667;
        this.declinSPG_ = declinSPC = 57.29577951308232 * Math.asin(sinObliquity * this.sinEllS_);
        this.subsolarLonPG_ = (this.veeM_ - alphaS) % 360.0;
        this.tst0_ = TitanTime.normalize24(this.subsolarLonPG_ * 0.06666666666666667 + 12.0);
        this.mst0_ = TitanTime.normalize24((this.veeM_ - this.alphaFMS_) % 360.0 * 0.06666666666666667 + 12.0);
        this.eotHours_ = this.tst0_ - this.mst0_;
        this.eotDegrees_ = this.eotHours_ * 15.0;
        this.gotOrbitParams_ = false;
        this.gotEarthParams_ = false;
    }

    @Override
    protected void calculateOrbitParams() {
        this.lambdaRot_ = 79.385 - 0.012 * this.jcent_ + 0.63 * Math.sin(Math.PI / 180 * (344.2 - 52.1 * this.jcent_));
        this.betaRot_ = 62.557 - 0.022 * this.jcent_ + 0.29 * Math.sin(Math.PI / 180 * (344.2 - 52.1 * this.jcent_));
        double semimajorAxisKm = 1221850.0;
        this.eccentricityP_ = 0.028815 - 1.84E-4 * Math.cos(Math.PI / 180 * (319.8 + 104.38 * this.jcent_)) + 7.3E-5 * Math.cos(Math.PI / 180 * (153.7 + 2340.94 * this.jcent_));
        this.meanAnomalyP_ = 163.145 + 824571.78 * this.jcent_ - 0.36 * Math.sin(Math.PI / 180 * (319.8 + 104.38 * this.jcent_)) - 0.14 * Math.sin(Math.PI / 180 * (153.7 + 2340.94 * this.jcent_)) + 0.07 * Math.sin(Math.PI / 180 * (343.9 - 52.19 * this.jcent_));
        double eP1 = this.eccentricityP_;
        double eP2 = eP1 * eP1;
        double eP3 = eP1 * eP2;
        double eP4 = eP1 * eP3;
        double eP5 = eP1 * eP4;
        double eP6 = eP1 * eP5;
        double meanAnomalyPRad = this.meanAnomalyP_ * (Math.PI / 180);
        double sin1MP = Math.sin(meanAnomalyPRad);
        double sin2MP = Math.sin(2.0 * meanAnomalyPRad);
        double sin3MP = Math.sin(3.0 * meanAnomalyPRad);
        double sin4MP = Math.sin(4.0 * meanAnomalyPRad);
        double sin5MP = Math.sin(5.0 * meanAnomalyPRad);
        double sin6MP = Math.sin(6.0 * meanAnomalyPRad);
        this.equationOfCenterP_ = 57.29577951308232 * (sin1MP * (2.0 * eP1 - 0.25 * eP3 + 0.052083333333333336 * eP5) + sin2MP * (1.25 * eP2 - 0.4583333333333333 * eP4 + 0.08854166666666667 * eP6) + sin3MP * (1.0833333333333333 * eP3 - 0.6825396825396826 * eP5) + sin4MP * (1.0729166666666667 * eP4 - 0.9395833333333333 * eP6) + sin5MP * (1.1427083333333334 * eP5) + sin6MP * (1.2739583333333333 * eP6));
        this.subprimaryLon_ = TitanTime.normalize360(-2.067 - this.equationOfCenterP_);
        this.subprimaryLat_ = 0.0;
        this.rPrimaryKm_ = 1221850.0 * (1.0 - eP2) / (1.0 + eP1 * Math.cos(Math.PI / 180 * (this.meanAnomalyP_ + this.equationOfCenterP_)));
        this.lonEcliptic_ = this.saturnTime_.getHeliocentricLongitude();
        this.latEcliptic_ = this.saturnTime_.getHeliocentricLatitude();
        double cosDthetaDiff = Math.cos(Math.PI / 180 * (this.subsolarLonPG_ - this.subprimaryLon_));
        double cosDiff = Math.cos(Math.PI / 180 * (90.0 - this.declinSPG_)) * Math.cos(Math.PI / 180 * (90.0 - this.subprimaryLat_)) + Math.sin(Math.PI / 180 * (90.0 - this.declinSPG_)) * Math.sin(Math.PI / 180 * (90.0 - this.subprimaryLat_)) * cosDthetaDiff;
        double rHeliocentricKm = this.saturnTime_.getDistanceToSun(DistanceUnits.KM);
        this.rHeliocentricAU_ = (rHeliocentricKm += cosDiff * this.rPrimaryKm_) / 1.495978707E8;
        this.gotOrbitParams_ = true;
    }

    @Override
    public double getVernalEquinox() {
        return 0.0;
    }

    @Override
    public double getHeliocentricLongitudeAtPerihelion(boolean b) {
        return 0.0;
    }

    public double getDistanceToPrimary(DistanceUnits units) {
        if (!this.gotOrbitParams_) {
            this.calculateOrbitParams();
        }
        if (units == DistanceUnits.KM) {
            return this.rPrimaryKm_;
        }
        throw new IllegalArgumentException("No switch case for DistanceUnits");
    }

    public PointLL getSubprimaryPoint() {
        if (!this.gotOrbitParams_) {
            this.calculateOrbitParams();
        }
        return new PointLL(this.subprimaryLon_, this.subprimaryLat_);
    }

    public Point2D.Double getPrimaryAngleAt(double lon, double lat) {
        if (!this.gotOrbitParams_) {
            this.calculateOrbitParams();
        }
        double latRad = Math.PI / 180 * lat;
        double cosDec = Math.cos(Math.PI / 180 * this.subprimaryLat_);
        double sinDec = Math.sin(Math.PI / 180 * this.subprimaryLat_);
        double tanDec = Math.tan(Math.PI / 180 * this.subprimaryLat_);
        double hourAngle = TitanTime.normalize180(lon - this.subprimaryLon_);
        double cosHourAngle = Math.cos(Math.PI / 180 * hourAngle);
        double zenithAngle = 57.29577951308232 * Math.acos(sinDec * Math.sin(latRad) + cosDec * Math.cos(latRad) * cosHourAngle);
        double cosLat = Math.cos(latRad);
        double sinLat = Math.sin(latRad);
        double azimuthAngle = 57.29577951308232 * Math.atan2(Math.sin(Math.PI / 180 * hourAngle), cosLat * tanDec - sinLat * cosHourAngle);
        azimuthAngle = TitanTime.normalize360(azimuthAngle);
        return new Point2D.Double(azimuthAngle, zenithAngle);
    }

    public double getPrimaryZenithAngle(double lon, double lat) {
        return this.getPrimaryAngleAt(lon, lat).getY();
    }

    public double getPrimaryAzimuthAngle(double lon, double lat) {
        return this.getPrimaryAngleAt(lon, lat).getX();
    }

    public double getSolDate() {
        return (this.jdTT_ - 2400000.5 - 51549.0) / 15.96913 + 44796.0 - 9.6E-4;
    }

    public MissionTime getMissionTime(String landerID) {
        Objects.requireNonNull(landerID, "Lander ID cannot be null.");
        if (landerID.equalsIgnoreCase("HUY")) {
            double d = this.getTimeHours(198.6, ClockType.MEAN_SOLAR) / 24.0;
        }
        throw new IllegalArgumentException("Unknown lander ID " + landerID);
    }
}

