/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui;

import gov.nasa.giss.ui.BottomBar;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.plaf.EmphasizedLabelUI;
import gov.nasa.giss.util.PlatformUtils;
import gov.nasa.giss.util.task.TaskQueue;
import gov.nasa.giss.util.task.TaskQueueEvent;
import gov.nasa.giss.util.task.TaskQueueListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class StatusBar
extends BottomBar
implements TaskQueueListener {
    private static final boolean DEBUG = false;
    private TaskQueue queue_;
    private JProgressBar pbar_ = new JProgressBar();
    private JLabel noteLabel_;
    private JPanel pbarBlank_;
    private Component strut_;
    private Component glue_;

    public StatusBar(TaskQueue queue) {
        super(16);
        this.pbar_.setIndeterminate(true);
        this.pbar_.setStringPainted(false);
        this.pbar_.setBorderPainted(true);
        GuiUtils.setSizeMini(this.pbar_);
        Dimension d = this.pbar_.getPreferredSize();
        d.width = Math.max(d.width, 200);
        this.pbar_.setPreferredSize(d);
        this.pbar_.setMinimumSize(d);
        this.pbar_.setMaximumSize(d);
        this.pbar_.setSize(d);
        this.pbarBlank_ = new JPanel();
        this.pbarBlank_.setOpaque(false);
        this.pbarBlank_.setPreferredSize(d);
        this.pbarBlank_.setMinimumSize(d);
        this.pbarBlank_.setMaximumSize(d);
        this.pbarBlank_.setSize(d);
        this.noteLabel_ = new JLabel("X");
        GuiUtils.setSizeMini(this.noteLabel_);
        Font f = this.noteLabel_.getFont();
        if (PlatformUtils.isMacintosh()) {
            this.noteLabel_.setUI(new EmphasizedLabelUI());
        }
        this.noteLabel_.setFont(f);
        this.noteLabel_.setPreferredSize(null);
        this.noteLabel_.setMinimumSize(null);
        this.noteLabel_.setMaximumSize(null);
        this.strut_ = Box.createHorizontalStrut(6);
        this.glue_ = Box.createHorizontalGlue();
        int h = Math.max(this.pbar_.getPreferredSize().height, this.noteLabel_.getPreferredSize().height);
        this.setSize(h += this.getInsets().top + this.getInsets().bottom);
        this.queue_ = queue;
        this.queue_.addQueueListener(this);
    }

    @Override
    public void taskStarted(TaskQueueEvent tqe) {
        this.removeAll();
        StringBuilder sb = new StringBuilder("");
        int size = this.queue_.size();
        if (size == 1) {
            sb.append("1 task");
        } else {
            sb.append(size).append(" tasks");
        }
        sb.append("\u2026 ").append(this.queue_.getCurrentTask().getDescription());
        this.noteLabel_.setText(sb.toString());
        this.add(this.pbar_);
        this.add(this.strut_);
        this.add(this.noteLabel_);
        this.add(this.glue_);
        this.validate();
        this.repaint();
    }

    @Override
    public void taskCompleted(TaskQueueEvent tqe) {
        this.removeAll();
        this.noteLabel_.setText("");
        this.add(this.pbarBlank_);
        this.add(this.strut_);
        this.add(this.noteLabel_);
        this.add(this.glue_);
        this.validate();
        this.repaint();
    }

    @Override
    public void taskCanceled(TaskQueueEvent tqe) {
        this.removeAll();
        this.noteLabel_.setText("");
        this.add(this.pbarBlank_);
        this.add(this.strut_);
        this.add(this.noteLabel_);
        this.add(this.glue_);
        this.validate();
        this.repaint();
    }

    @Override
    public void queueEmptied(TaskQueueEvent tqe) {
        this.removeAll();
        this.noteLabel_.setText("");
        this.add(this.pbarBlank_);
        this.add(this.strut_);
        this.add(this.noteLabel_);
        this.add(this.glue_);
        this.validate();
        this.repaint();
    }
}

