/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.ui.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.MouseInputAdapter;
import net.schmunk.ui.FGConstraint;
import net.schmunk.ui.FlexingGridLayout;

public class HsbSliderPanel
extends AbstractColorChooserPanel {
    private static final int HUE = 0;
    private static final int SATURATION = 1;
    private static final int BRIGHTNESS = 2;
    private static final Color SHADOW = new Color(51, 51, 51);
    private static final Color HIGHLIGHT = new Color(153, 153, 153);
    private static ImageIcon tickIcon_;
    private static Image tickImage_;
    private static int tickIconWidth_;
    private HsbTextField hField_;
    private HsbTextField sField_;
    private HsbTextField bField_;

    public HsbSliderPanel() {
        this.setOpaque(false);
        if (tickIcon_ == null) {
            tickIcon_ = new ImageIcon(HsbSliderPanel.class.getResource("resources/slidertick.png"));
            tickImage_ = tickIcon_.getImage();
        }
        JLabel hLabel = new JLabel("H", 4);
        JLabel sLabel = new JLabel("S", 4);
        JLabel bLabel = new JLabel("B", 4);
        JLabel hUnits = new JLabel("\u00b0", 2);
        JLabel sUnits = new JLabel("%", 2);
        JLabel bUnits = new JLabel("%", 2);
        hLabel.setFont(hLabel.getFont().deriveFont((float)((double)hLabel.getFont().getSize() - 3.0)));
        sLabel.setFont(hLabel.getFont());
        bLabel.setFont(hLabel.getFont());
        hUnits.setFont(hLabel.getFont());
        sUnits.setFont(hLabel.getFont());
        bUnits.setFont(hLabel.getFont());
        this.hField_ = new HsbTextField(0);
        this.sField_ = new HsbTextField(1);
        this.bField_ = new HsbTextField(2);
        FlexingGridLayout fgl = new FlexingGridLayout(new Dimension(8, 5), 2, 12);
        fgl.setColumnWeight(0, 9999.0f);
        fgl.setColumnWeight(2, 9999.0f);
        fgl.setColumnWeight(7, 9999.0f);
        fgl.setRowWeight(0, 9999.0f);
        fgl.setRowWeight(4, 9999.0f);
        this.setLayout(fgl);
        this.add((Component)new ColorBox(), new Rectangle(1, 1, 1, 3));
        this.add((Component)hLabel, new Rectangle(3, 1, 1, 1));
        this.add((Component)sLabel, new Rectangle(3, 2, 1, 1));
        this.add((Component)bLabel, new Rectangle(3, 3, 1, 1));
        this.add((Component)new Slider(0), new FGConstraint(new Rectangle(4, 1, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(1), new FGConstraint(new Rectangle(4, 2, 1, 1), 0.5, 0.5));
        this.add((Component)new Slider(2), new FGConstraint(new Rectangle(4, 3, 1, 1), 0.5, 0.5));
        this.add((Component)this.hField_, new FGConstraint(new Rectangle(5, 1, 1, 1), 0.5, 0.5));
        this.add((Component)this.sField_, new FGConstraint(new Rectangle(5, 2, 1, 1), 0.5, 0.5));
        this.add((Component)this.bField_, new FGConstraint(new Rectangle(5, 3, 1, 1), 0.5, 0.5));
        this.add((Component)hUnits, new FGConstraint(new Rectangle(6, 1, 1, 1), 0.5, 0.5));
        this.add((Component)sUnits, new FGConstraint(new Rectangle(6, 2, 1, 1), 0.5, 0.5));
        this.add((Component)bUnits, new FGConstraint(new Rectangle(6, 3, 1, 1), 0.5, 0.5));
        this.add(Box.createGlue(), new Rectangle(0, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(2, 0, 1, 1));
        this.add(Box.createGlue(), new Rectangle(7, 4, 1, 1));
    }

    public Color getColor() {
        return this.getColorSelectionModel().getSelectedColor();
    }

    public void setColor(Color c) {
        this.getColorSelectionModel().setSelectedColor(c);
        this.hField_.refresh();
        this.sField_.refresh();
        this.bField_.refresh();
        this.repaint();
    }

    private void setHsb(int which, int value) {
        if (which == 0) {
            this.setHsb(0, (float)value / 360.0f);
        } else {
            this.setHsb(which, (float)value / 100.0f);
        }
    }

    private void setHsb(int which, float value) {
        if (value < 0.0f || value > 1.0f) {
            return;
        }
        Color c = this.getColorSelectionModel().getSelectedColor();
        float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        try {
            switch (which) {
                case 0: {
                    c = Color.getHSBColor(value, hsb[1], hsb[2]);
                    break;
                }
                case 1: {
                    c = Color.getHSBColor(hsb[0], value, hsb[2]);
                    break;
                }
                case 2: {
                    c = Color.getHSBColor(hsb[0], hsb[1], value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setColor(c);
    }

    @Override
    public void buildChooser() {
    }

    @Override
    public void updateChooser() {
        this.hField_.refresh();
        this.sField_.refresh();
        this.bField_.refresh();
        this.repaint();
    }

    @Override
    public String getDisplayName() {
        return "HSB";
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    private class Slider
    extends JComponent {
        private int whichHsb_;
        private MouseInputAdapter mouseListener;
        private int barWidth_ = 128;
        private int barHeight = 5;
        private int barLeft;
        private int barTop;
        private int barBottom;
        private int pad = 6;
        private int tickWidth2;
        private int tickHeight2;

        Slider(int which) {
            this.whichHsb_ = which;
            this.setOpaque(false);
            if (tickIconWidth_ == 0) {
                tickIconWidth_ = tickIcon_.getIconWidth();
            }
            Dimension size = new Dimension(this.barWidth_ + 2 * (this.pad + 1), this.barHeight + 8);
            this.setPreferredSize(size);
            this.mouseListener = new SliderMouseHandler();
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseListener);
        }

        @Override
        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            this.barHeight = h / 3;
            this.tickHeight2 = 12;
            this.tickWidth2 = 12;
            this.barWidth_ = w - 2 * (this.pad + 1);
            this.barLeft = this.pad + 1;
            this.barTop = (h - 16) / 2 + this.barHeight;
            this.barBottom = this.barTop + this.barHeight + 1;
            g.setColor(SHADOW);
            g.drawLine(this.pad + 0, this.barTop, this.pad + 1 + this.barWidth_, this.barTop);
            g.drawLine(this.pad + 0, this.barTop, this.pad + 0, this.barBottom);
            g.setColor(HIGHLIGHT);
            g.drawLine(this.pad + 1, this.barBottom, this.pad + 1 + this.barWidth_, this.barBottom);
            g.drawLine(this.pad + 1 + this.barWidth_, this.barTop + 1, this.pad + 1 + this.barWidth_, this.barBottom);
            Color c = HsbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            for (int i = 0; i < this.barWidth_; ++i) {
                float pct = (float)i / (float)this.barWidth_;
                switch (this.whichHsb_) {
                    case 0: {
                        g.setColor(Color.getHSBColor(pct, hsb[1], hsb[2]));
                        break;
                    }
                    case 1: {
                        g.setColor(Color.getHSBColor(hsb[0], pct, hsb[2]));
                        break;
                    }
                    case 2: {
                        g.setColor(Color.getHSBColor(hsb[0], hsb[1], pct));
                    }
                }
                g.drawLine(this.pad + 1 + i, this.barTop + 1, this.pad + 1 + i, this.barTop + this.barHeight);
            }
            g.drawImage(tickImage_, this.pad + 1 + this.getTickX() - this.tickWidth2 / 2, (this.barTop + this.barBottom - this.tickHeight2) / 2, this.tickWidth2, this.tickHeight2, new Color(0, 0, 0, 0), HsbSliderPanel.this);
        }

        private int getTickX() {
            Color c = HsbSliderPanel.this.getColorSelectionModel().getSelectedColor();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            switch (this.whichHsb_) {
                case 0: {
                    return (int)((float)this.barWidth_ * hsb[0]);
                }
                case 1: {
                    return (int)((float)this.barWidth_ * hsb[1]);
                }
                case 2: {
                    return (int)((float)this.barWidth_ * hsb[2]);
                }
            }
            return 0;
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        private class SliderMouseHandler
        extends MouseInputAdapter {
            boolean dragInProgress;

            SliderMouseHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int tick = Slider.this.getTickX();
                int x = e.getX() - Slider.this.pad;
                if (x < tick - Slider.this.tickWidth2 / 2 || x > tick + Slider.this.tickWidth2 / 2 || x < 0 || x > Slider.this.barWidth_) {
                    return;
                }
                this.handleMouse(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.mouseClicked(e);
                this.dragInProgress = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
                this.dragInProgress = false;
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!this.dragInProgress) {
                    return;
                }
                this.handleMouse(e);
            }

            public void handleMouse(MouseEvent e) {
                int x = e.getX() - Slider.this.pad - 1;
                HsbSliderPanel.this.setHsb(Slider.this.whichHsb_, (float)x / (float)Slider.this.barWidth_);
            }
        }
    }

    private class HsbTextField
    extends JTextField {
        private int whichHsb_;

        HsbTextField(int which) {
            super(4);
            this.setFont(this.getFont().deriveFont((float)((double)this.getFont().getSize() - 2.0)));
            this.whichHsb_ = which;
            if (this.whichHsb_ == 0) {
                this.setText("359");
            } else {
                this.setText("100");
            }
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    HsbTextField.this.respond();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.addActionListener(e -> this.respond());
        }

        private void refresh() {
            ColorSelectionModel csm = HsbSliderPanel.this.getColorSelectionModel();
            if (csm == null) {
                return;
            }
            Color c = csm.getSelectedColor();
            float[] hsb = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
            switch (this.whichHsb_) {
                case 0: {
                    this.setText(Integer.toString((int)(hsb[0] * 360.0f)));
                    break;
                }
                case 1: {
                    this.setText(Integer.toString((int)(hsb[1] * 100.0f)));
                    break;
                }
                case 2: {
                    this.setText(Integer.toString((int)(hsb[2] * 100.0f)));
                }
            }
        }

        private void respond() {
            try {
                HsbSliderPanel.this.setHsb(this.whichHsb_, Integer.parseInt(this.getText()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refresh();
        }
    }

    private class ColorBox
    extends JComponent {
        ColorBox() {
            Dimension size = new Dimension(34, 34);
            this.setPreferredSize(size);
            this.setMinimumSize(size);
        }

        @Override
        public void paintComponent(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            int l = (w - 34) / 2;
            int t = (h - 34) / 2;
            g.setColor(SHADOW);
            g.drawLine(l, t, l + 34, t);
            g.drawLine(l, t, l, t + 34);
            g.setColor(HIGHLIGHT);
            g.drawLine(l + 1, t + 34, l + 1 + 32, t + 34);
            g.drawLine(l + 34, t + 1, l + 34, t + 34);
            g.setColor(HsbSliderPanel.this.getColorSelectionModel().getSelectedColor());
            g.fillRect(l + 1, t + 1, 32, 32);
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }
}

