/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.util;

import gov.nasa.giss.ui.GuiUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GissPrintAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Printable prObject_;

    private GissPrintAction() {
    }

    public GissPrintAction(Printable p) {
        this(p, "Print\u2026");
    }

    public GissPrintAction(Printable p, String name) {
        super(name);
        this.prObject_ = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PrinterJob pj = null;
        try {
            pj = PrinterJob.getPrinterJob();
        }
        catch (Exception exc) {
            LOGGER.error("Could not create PrinterJob: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.showErrorIfPossible(exc);
            return;
        }
        pj.setPrintable(this.prObject_);
        try {
            if (!pj.printDialog()) {
                return;
            }
        }
        catch (Exception exc) {
            LOGGER.error("Could not create display print dialog: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.showErrorIfPossible(exc);
            return;
        }
        try {
            pj.print();
        }
        catch (Exception exc) {
            LOGGER.error("Could not print: {}", (Object)exc.toString());
            if (LOGGER.isTraceEnabled()) {
                exc.printStackTrace();
            }
            this.showErrorIfPossible(exc);
            return;
        }
    }

    private void showErrorIfPossible(Exception exc) {
        if (this.prObject_ instanceof Component) {
            String emsg = exc.toString().replaceFirst("^.*: ", "");
            GuiUtils.showSlowMessage((Component)((Object)this.prObject_), "Printing Error", "I encountered an error trying to print.\n" + emsg);
        }
    }
}

