/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;
import javax.imageio.stream.FileImageOutputStream;

public class GeoRefCTP {
    Vector<Record> tiePoints;
    final int rows;
    final int columns;

    public GeoRefCTP(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.tiePoints = new Vector();
    }

    public void Add(double row, double col, double X, double Y) {
        Record record = new Record(row, col, X, Y);
        this.tiePoints.add(record);
    }

    public void Store(String fn, String fnBackgroundMap, String fnCoordinateSystem) throws IOException {
        String fileNameODF = String.valueOf(fn) + ".grf";
        String fileNameData = String.valueOf(fn) + ".gr#";
        PrintWriter writer = new PrintWriter(fileNameODF, "UTF-8");
        try {
            writer.println("[Ilwis]");
            writer.println("Type=GeoRef");
            writer.println("Description=");
            writer.println("Version=3.1");
            writer.println("Class=GeoReference TiePoints");
            writer.println();
            writer.println("[GeoRef]");
            writer.println("CoordSystem=" + ILWISProductWriter.removePath(fnCoordinateSystem));
            writer.println("Lines=" + this.rows);
            writer.println("Columns=" + this.columns);
            writer.println("Type=GeoRefCTP");
            writer.println();
            writer.println("[GeoRefCTP]");
            writer.println("Background Map=" + ILWISProductWriter.removePath(fnBackgroundMap));
            writer.println("SubPixelPrecision=true");
            writer.println("Transformation=Grid");
            writer.println();
            writer.println("[Table]");
            writer.println("Description=");
            writer.println("Version=3.1");
            writer.println("Class=Table");
            writer.println("Domain=None.dom");
            writer.println("DomainInfo=None.dom;Byte;none;0;;");
            writer.println("Columns=5");
            writer.println("Records=" + this.tiePoints.size());
            writer.println("Type=TableStore");
            writer.println();
            writer.println("[TableStore]");
            writer.println("Data=" + ILWISProductWriter.removePath(fileNameData));
            writer.println("UseAs=No");
            writer.println("Col0=X");
            writer.println("Col1=Y");
            writer.println("Col2=Row");
            writer.println("Col3=Col");
            writer.println("Col4=Active");
            writer.println("Type=TableBinary");
            writer.println();
            this.printColumn(writer, "X", "X-Coord", false);
            this.printColumn(writer, "Y", "Y-Coord", false);
            this.printColumn(writer, "Row", "Pixel row", false);
            this.printColumn(writer, "Col", "Pixel column", false);
            this.printColumn(writer, "Active", "Active point", true);
        }
        finally {
            writer.flush();
            writer.close();
        }
        File outputFile = new File(fileNameData);
        FileImageOutputStream ios = new FileImageOutputStream(outputFile);
        try {
            ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
            ByteBuffer header = ByteBuffer.allocate(128);
            header.order(ByteOrder.LITTLE_ENDIAN);
            char[] magic = "ILWIS 2.00 Table\r\n\u001a".toCharArray();
            int i = 0;
            while (i < magic.length) {
                header.put((byte)magic[i]);
                ++i;
            }
            ios.write(header.array());
            for (Record record : this.tiePoints) {
                ios.writeDouble(record.X);
                ios.writeDouble(record.Y);
                ios.writeDouble(record.row);
                ios.writeDouble(record.col);
                ios.writeInt(2);
            }
        }
        finally {
            ios.flush();
            ios.close();
        }
    }

    private void printColumn(PrintWriter writer, String name, String description, boolean boolColumn) {
        writer.println("[Col:" + name + "]");
        writer.println("Description=" + description);
        writer.println("Version=3.1");
        writer.println("Class=Column");
        if (boolColumn) {
            writer.println("Domain=bool.dom");
            writer.println("DomainInfo=bool.dom;Byte;bool;0;;");
            writer.println("Range=0:1:offset=-1");
        } else {
            writer.println("Domain=value.dom");
            writer.println("DomainInfo=value.dom;Long;value;0;-9999999.9:9999999.9:0.1:offset=0;");
            writer.println("Range=-1000000000.000:1000000000.000:0.001:offset=0");
        }
        writer.println("ReadOnly=No");
        writer.println("OwnedByTable=Yes");
        writer.println("Sum=?");
        writer.println("Mean=?");
        writer.println("StdDev=?");
        if (boolColumn) {
            writer.println("StoreType=Long");
        } else {
            writer.println("StoreType=Real");
        }
        writer.println("Stored=Yes");
        writer.println("Type=ColumnStore");
        writer.println();
    }

    private class Record {
        public final double row;
        public final double col;
        public final double X;
        public final double Y;

        public Record(double row, double col, double X, double Y) {
            this.row = row;
            this.col = col;
            this.X = X;
            this.Y = Y;
        }
    }
}

