/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio;

import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.DataContextImpl;
import com.bc.ceres.binio.util.FileChannelIOHandler;
import com.bc.ceres.binio.util.RandomAccessFileIOHandler;
import com.bc.ceres.core.Assert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

public class DataFormat {
    private CompoundType type;
    private DataFormat basisFormat;
    private String name;
    private String version;
    private ByteOrder byteOrder;
    private final Map<String, Type> typeDefMap;

    public DataFormat() {
        this.typeDefMap = new HashMap<String, Type>(16);
    }

    public DataFormat(CompoundType type) {
        this(type, ByteOrder.BIG_ENDIAN);
    }

    public DataFormat(CompoundType type, ByteOrder byteOrder) {
        this.setType(type);
        this.setName(type.getName());
        this.setVersion("1.0.0");
        this.setByteOrder(byteOrder);
        this.typeDefMap = new HashMap<String, Type>(16);
    }

    public DataContext createContext(File file, String mode) throws FileNotFoundException {
        Assert.notNull(file, "file");
        Assert.notNull(mode, "mode");
        final RandomAccessFile raf = new RandomAccessFile(file, mode);
        return new DataContextImpl(this, new RandomAccessFileIOHandler(raf)){
            private boolean disposed;

            @Override
            public synchronized void dispose() {
                super.dispose();
                this.disposed = true;
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }

            protected void finalize() throws Throwable {
                super.finalize();
                if (!this.disposed) {
                    this.dispose();
                }
            }
        };
    }

    public DataContext createContext(RandomAccessFile raf) {
        Assert.notNull(raf, "raf");
        return new DataContextImpl(this, new RandomAccessFileIOHandler(raf));
    }

    public DataContext createContext(FileChannel fileChannel) {
        Assert.notNull(fileChannel, "fileChannel");
        return new DataContextImpl(this, new FileChannelIOHandler(fileChannel));
    }

    public DataContext createContext(IOHandler ioHandler) {
        Assert.notNull(ioHandler, "ioHandler");
        return new DataContextImpl(this, ioHandler);
    }

    public DataFormat getBasisFormat() {
        return this.basisFormat;
    }

    public void setBasisFormat(DataFormat basisFormat) {
        this.basisFormat = basisFormat;
    }

    public CompoundType getType() {
        return this.type;
    }

    public void setType(CompoundType type) {
        Assert.notNull(type, "type");
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Assert.notNull(name, "name");
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        Assert.notNull(version, "version");
        this.version = version;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        Assert.notNull(byteOrder, "byteOrder");
        this.byteOrder = byteOrder;
    }

    public boolean isTypeDef(String name) {
        Assert.notNull(name, "name");
        return this.typeDefMap.containsKey(name) || this.basisFormat != null && this.basisFormat.isTypeDef(name);
    }

    public Type getTypeDef(String name) {
        Assert.notNull(name, "name");
        Type type = this.typeDefMap.get(name);
        if (type == null) {
            Type type2 = type = this.basisFormat != null ? this.basisFormat.getTypeDef(name) : null;
        }
        if (type == null) {
            throw new IllegalArgumentException(MessageFormat.format("Type definition ''{0}'' not found", name));
        }
        return type;
    }

    public void addTypeDef(String name, Type type) {
        Assert.notNull(name, "name");
        Assert.notNull(type, "type");
        Type oldType = this.typeDefMap.get(name);
        if (oldType != null && !oldType.equals(type)) {
            throw new IllegalArgumentException(MessageFormat.format("Type definition ''{0}'' already known as ''{1}''", name, oldType.getName()));
        }
        this.typeDefMap.put(name, type);
    }

    public Type removeTypeDef(String name) {
        Assert.notNull(name, "name");
        return this.typeDefMap.remove(name);
    }
}

