/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.internal.InstanceFactory;
import java.io.IOException;

public class DataContextImpl
implements DataContext {
    private final DataFormat format;
    private final IOHandler handler;
    private volatile CompoundData data;

    public DataContextImpl(DataFormat format, IOHandler handler) {
        this.format = format;
        this.handler = handler;
    }

    @Override
    public DataFormat getFormat() {
        return this.format;
    }

    @Override
    public IOHandler getHandler() {
        return this.handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompoundData getData() {
        if (this.data == null) {
            DataContextImpl dataContextImpl = this;
            synchronized (dataContextImpl) {
                if (this.data == null) {
                    this.data = this.createData(0L);
                }
            }
        }
        return this.data;
    }

    @Override
    public CompoundData createData() {
        return this.createData(0L);
    }

    @Override
    public CompoundData createData(long position) {
        return this.createData(this.format.getType(), position);
    }

    @Override
    public CompoundData createData(CompoundType type, long position) {
        return InstanceFactory.createCompound(this, null, type, position, this.format.getByteOrder());
    }

    @Override
    public CompoundData getData(long position) {
        return this.createData(this.format.getType(), position);
    }

    @Override
    public CompoundData getData(CompoundType type, long position) {
        return this.createData(type, position);
    }

    @Override
    public synchronized void dispose() {
        if (this.data != null) {
            try {
                this.data.flush();
            }
            catch (IOException iOException) {}
        }
    }
}

