/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.AbstractType;

public final class GrowableSequenceTypeImpl
extends AbstractType
implements SequenceType {
    private final String name;
    private final Type elementType;
    private int elementCount;
    private int size;

    public GrowableSequenceTypeImpl(Type elementType) {
        this.name = String.valueOf(elementType.getName()) + "[]";
        this.elementType = elementType;
        this.elementCount = 0;
        this.size = 0;
    }

    @Override
    public final Type getElementType() {
        return this.elementType;
    }

    @Override
    public final synchronized int getElementCount() {
        return this.elementCount;
    }

    public final synchronized void incElementCount() {
        ++this.elementCount;
        this.size += this.elementType.getSize();
    }

    @Override
    public final synchronized String getName() {
        return this.name;
    }

    @Override
    public final synchronized int getSize() {
        return this.size;
    }

    @Override
    public final boolean isCollectionType() {
        return true;
    }

    @Override
    public final boolean isSequenceType() {
        return true;
    }
}

