/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import java.nio.ByteOrder;

public abstract class ByteArrayCodec {
    public static final ByteArrayCodec LITTLE_ENDIAN = new LE();
    public static final ByteArrayCodec BIG_ENDIAN = new BE();

    public static ByteArrayCodec getInstance(ByteOrder byteOrder) {
        if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return LITTLE_ENDIAN;
        }
        return BIG_ENDIAN;
    }

    protected ByteArrayCodec() {
    }

    public abstract ByteOrder getByteOrder();

    public final byte getByte(byte[] b, int boff) {
        return b[boff];
    }

    public abstract short getShort(byte[] var1, int var2);

    public abstract int getInt(byte[] var1, int var2);

    public abstract long getLong(byte[] var1, int var2);

    public abstract float getFloat(byte[] var1, int var2);

    public abstract double getDouble(byte[] var1, int var2);

    public final void getBytes(byte[] b, int boff, byte[] v, int voff, int vlen) {
        System.arraycopy(b, boff, v, voff, vlen);
    }

    public abstract void getShorts(byte[] var1, int var2, short[] var3, int var4, int var5);

    public abstract void getInts(byte[] var1, int var2, int[] var3, int var4, int var5);

    public abstract void getLongs(byte[] var1, int var2, long[] var3, int var4, int var5);

    public abstract void getFloats(byte[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void getDoubles(byte[] var1, int var2, double[] var3, int var4, int var5);

    public final void setByte(byte[] b, int boff, byte v) {
        b[boff] = v;
    }

    public abstract void setShort(byte[] var1, int var2, short var3);

    public abstract void setInt(byte[] var1, int var2, int var3);

    public abstract void setLong(byte[] var1, int var2, long var3);

    public abstract void setFloat(byte[] var1, int var2, float var3);

    public abstract void setDouble(byte[] var1, int var2, double var3);

    public final void setBytes(byte[] b, int boff, byte[] v, int voff, int vlen) {
        System.arraycopy(v, voff, b, boff, vlen);
    }

    public abstract void setShorts(byte[] var1, int var2, short[] var3, int var4, int var5);

    public abstract void setInts(byte[] var1, int var2, int[] var3, int var4, int var5);

    public abstract void setLongs(byte[] var1, int var2, long[] var3, int var4, int var5);

    public abstract void setFloats(byte[] var1, int var2, float[] var3, int var4, int var5);

    public abstract void setDoubles(byte[] var1, int var2, double[] var3, int var4, int var5);

    private static short decodeSLE(byte[] b, int boff) {
        byte b0 = b[boff + 1];
        int b1 = b[boff + 0] & 0xFF;
        return (short)(b0 << 8 | b1);
    }

    private static short decodeSBE(byte[] b, int boff) {
        byte b0 = b[boff + 0];
        int b1 = b[boff + 1] & 0xFF;
        return (short)(b0 << 8 | b1);
    }

    private static int decodeILE(byte[] b, int boff) {
        byte b0 = b[boff + 3];
        int b1 = b[boff + 2] & 0xFF;
        int b2 = b[boff + 1] & 0xFF;
        int b3 = b[boff + 0] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    private static int decodeIBE(byte[] b, int boff) {
        byte b0 = b[boff + 0];
        int b1 = b[boff + 1] & 0xFF;
        int b2 = b[boff + 2] & 0xFF;
        int b3 = b[boff + 3] & 0xFF;
        return b0 << 24 | b1 << 16 | b2 << 8 | b3;
    }

    private static long decodeLLE(byte[] b, int boff) {
        byte b0 = b[boff + 7];
        int b1 = b[boff + 6] & 0xFF;
        int b2 = b[boff + 5] & 0xFF;
        int b3 = b[boff + 4] & 0xFF;
        byte b4 = b[boff + 3];
        int b5 = b[boff + 2] & 0xFF;
        int b6 = b[boff + 1] & 0xFF;
        int b7 = b[boff + 0] & 0xFF;
        int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        return (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
    }

    private static long decodeLBE(byte[] b, int boff) {
        byte b0 = b[boff + 0];
        int b1 = b[boff + 1] & 0xFF;
        int b2 = b[boff + 2] & 0xFF;
        int b3 = b[boff + 3] & 0xFF;
        byte b4 = b[boff + 4];
        int b5 = b[boff + 5] & 0xFF;
        int b6 = b[boff + 6] & 0xFF;
        int b7 = b[boff + 7] & 0xFF;
        int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        return (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
    }

    private static float decodeFLE(byte[] b, int boff) {
        byte b0 = b[boff + 3];
        int b1 = b[boff + 2] & 0xFF;
        int b2 = b[boff + 1] & 0xFF;
        int b3 = b[boff + 0] & 0xFF;
        int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return Float.intBitsToFloat(i);
    }

    private static float decodeFBE(byte[] b, int boff) {
        byte b0 = b[boff + 0];
        int b1 = b[boff + 1] & 0xFF;
        int b2 = b[boff + 2] & 0xFF;
        int b3 = b[boff + 3] & 0xFF;
        int i = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        return Float.intBitsToFloat(i);
    }

    private static double decodeDL(byte[] b, int boff) {
        byte b0 = b[boff + 7];
        int b1 = b[boff + 6] & 0xFF;
        int b2 = b[boff + 5] & 0xFF;
        int b3 = b[boff + 4] & 0xFF;
        byte b4 = b[boff + 3];
        int b5 = b[boff + 2] & 0xFF;
        int b6 = b[boff + 1] & 0xFF;
        int b7 = b[boff + 0] & 0xFF;
        int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    private static double decodeDBE(byte[] b, int boff) {
        byte b0 = b[boff + 0];
        int b1 = b[boff + 1] & 0xFF;
        int b2 = b[boff + 2] & 0xFF;
        int b3 = b[boff + 3] & 0xFF;
        byte b4 = b[boff + 4];
        int b5 = b[boff + 5] & 0xFF;
        int b6 = b[boff + 6] & 0xFF;
        int b7 = b[boff + 7] & 0xFF;
        int i0 = b0 << 24 | b1 << 16 | b2 << 8 | b3;
        int i1 = b4 << 24 | b5 << 16 | b6 << 8 | b7;
        long l = (long)i0 << 32 | (long)i1 & 0xFFFFFFFFL;
        return Double.longBitsToDouble(l);
    }

    private static void encodeSLE(byte[] b, int boff, short v) {
        b[boff + 0] = (byte)(v >>> 0);
        b[boff + 1] = (byte)(v >>> 8);
    }

    private static void encodeSBE(byte[] b, int boff, short v) {
        b[boff + 0] = (byte)(v >>> 8);
        b[boff + 1] = (byte)(v >>> 0);
    }

    private static void encodeILE(byte[] b, int boff, int v) {
        b[boff + 0] = (byte)(v >>> 0);
        b[boff + 1] = (byte)(v >>> 8);
        b[boff + 2] = (byte)(v >>> 16);
        b[boff + 3] = (byte)(v >>> 24);
    }

    private static void encodeIBE(byte[] b, int boff, int v) {
        b[boff + 0] = (byte)(v >>> 24);
        b[boff + 1] = (byte)(v >>> 16);
        b[boff + 2] = (byte)(v >>> 8);
        b[boff + 3] = (byte)(v >>> 0);
    }

    private static void encodeLLE(byte[] b, int boff, long v) {
        b[boff + 0] = (byte)(v >>> 0);
        b[boff + 1] = (byte)(v >>> 8);
        b[boff + 2] = (byte)(v >>> 16);
        b[boff + 3] = (byte)(v >>> 24);
        b[boff + 4] = (byte)(v >>> 32);
        b[boff + 5] = (byte)(v >>> 40);
        b[boff + 6] = (byte)(v >>> 48);
        b[boff + 7] = (byte)(v >>> 56);
    }

    private static void encodeLBE(byte[] b, int boff, long v) {
        b[boff + 0] = (byte)(v >>> 56);
        b[boff + 1] = (byte)(v >>> 48);
        b[boff + 2] = (byte)(v >>> 40);
        b[boff + 3] = (byte)(v >>> 32);
        b[boff + 4] = (byte)(v >>> 24);
        b[boff + 5] = (byte)(v >>> 16);
        b[boff + 6] = (byte)(v >>> 8);
        b[boff + 7] = (byte)(v >>> 0);
    }

    private static void encodeFLE(byte[] b, int boff, float v) {
        ByteArrayCodec.encodeILE(b, boff, Float.floatToIntBits(v));
    }

    private static void encodeFBE(byte[] b, int boff, float v) {
        ByteArrayCodec.encodeIBE(b, boff, Float.floatToIntBits(v));
    }

    private static void encodeDLE(byte[] b, int boff, double v) {
        ByteArrayCodec.encodeLLE(b, boff, Double.doubleToLongBits(v));
    }

    private static void encodeDBE(byte[] b, int boff, double v) {
        ByteArrayCodec.encodeLBE(b, boff, Double.doubleToLongBits(v));
    }

    private static final class BE
    extends ByteArrayCodec {
        private BE() {
        }

        @Override
        public ByteOrder getByteOrder() {
            return ByteOrder.BIG_ENDIAN;
        }

        @Override
        public short getShort(byte[] b, int boff) {
            return ByteArrayCodec.decodeSBE(b, boff);
        }

        @Override
        public int getInt(byte[] b, int boff) {
            return ByteArrayCodec.decodeIBE(b, boff);
        }

        @Override
        public long getLong(byte[] b, int boff) {
            return ByteArrayCodec.decodeLBE(b, boff);
        }

        @Override
        public float getFloat(byte[] b, int boff) {
            return ByteArrayCodec.decodeFBE(b, boff);
        }

        @Override
        public double getDouble(byte[] b, int boff) {
            return ByteArrayCodec.decodeDBE(b, boff);
        }

        @Override
        public void getShorts(byte[] b, int boff, short[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeSBE(b, boff);
                boff += 2;
                ++i;
            }
        }

        @Override
        public void getInts(byte[] b, int boff, int[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeIBE(b, boff);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void getLongs(byte[] b, int boff, long[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeLBE(b, boff);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void getFloats(byte[] b, int boff, float[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeFBE(b, boff);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void getDoubles(byte[] b, int boff, double[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeDBE(b, boff);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void setShort(byte[] b, int boff, short v) {
            ByteArrayCodec.encodeSBE(b, boff, v);
        }

        @Override
        public void setInt(byte[] b, int boff, int v) {
            ByteArrayCodec.encodeIBE(b, boff, v);
        }

        @Override
        public void setLong(byte[] b, int boff, long v) {
            ByteArrayCodec.encodeLBE(b, boff, v);
        }

        @Override
        public void setFloat(byte[] b, int boff, float v) {
            ByteArrayCodec.encodeFBE(b, boff, v);
        }

        @Override
        public void setDouble(byte[] b, int boff, double v) {
            ByteArrayCodec.encodeDBE(b, boff, v);
        }

        @Override
        public void setShorts(byte[] b, int boff, short[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeSBE(b, boff, v[voff + i]);
                boff += 2;
                ++i;
            }
        }

        @Override
        public void setInts(byte[] b, int boff, int[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeIBE(b, boff, v[voff + i]);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void setLongs(byte[] b, int boff, long[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeLBE(b, boff, v[voff + i]);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void setFloats(byte[] b, int boff, float[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeFBE(b, boff, v[voff + i]);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void setDoubles(byte[] b, int boff, double[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeDBE(b, boff, v[voff + i]);
                boff += 8;
                ++i;
            }
        }
    }

    private static final class LE
    extends ByteArrayCodec {
        private LE() {
        }

        @Override
        public ByteOrder getByteOrder() {
            return ByteOrder.LITTLE_ENDIAN;
        }

        @Override
        public short getShort(byte[] b, int boff) {
            return ByteArrayCodec.decodeSLE(b, boff);
        }

        @Override
        public int getInt(byte[] b, int boff) {
            return ByteArrayCodec.decodeILE(b, boff);
        }

        @Override
        public long getLong(byte[] b, int boff) {
            return ByteArrayCodec.decodeLLE(b, boff);
        }

        @Override
        public float getFloat(byte[] b, int boff) {
            return ByteArrayCodec.decodeFLE(b, boff);
        }

        @Override
        public double getDouble(byte[] b, int boff) {
            return ByteArrayCodec.decodeDL(b, boff);
        }

        @Override
        public void getShorts(byte[] b, int boff, short[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeSLE(b, boff);
                boff += 2;
                ++i;
            }
        }

        @Override
        public void getInts(byte[] b, int boff, int[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeILE(b, boff);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void getLongs(byte[] b, int boff, long[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeLLE(b, boff);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void getFloats(byte[] b, int boff, float[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeFLE(b, boff);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void getDoubles(byte[] b, int boff, double[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                v[voff + i] = ByteArrayCodec.decodeDL(b, boff);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void setShort(byte[] b, int boff, short v) {
            ByteArrayCodec.encodeSLE(b, boff, v);
        }

        @Override
        public void setInt(byte[] b, int boff, int v) {
            ByteArrayCodec.encodeILE(b, boff, v);
        }

        @Override
        public void setLong(byte[] b, int boff, long v) {
            ByteArrayCodec.encodeLLE(b, boff, v);
        }

        @Override
        public void setFloat(byte[] b, int boff, float v) {
            ByteArrayCodec.encodeFLE(b, boff, v);
        }

        @Override
        public void setDouble(byte[] b, int boff, double v) {
            ByteArrayCodec.encodeDLE(b, boff, v);
        }

        @Override
        public void setShorts(byte[] b, int boff, short[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeSLE(b, boff, v[voff + i]);
                boff += 2;
                ++i;
            }
        }

        @Override
        public void setInts(byte[] b, int boff, int[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeILE(b, boff, v[voff + i]);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void setLongs(byte[] b, int boff, long[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeLLE(b, boff, v[voff + i]);
                boff += 8;
                ++i;
            }
        }

        @Override
        public void setFloats(byte[] b, int boff, float[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeFLE(b, boff, v[voff + i]);
                boff += 4;
                ++i;
            }
        }

        @Override
        public void setDoubles(byte[] b, int boff, double[] v, int voff, int vlen) {
            int i = 0;
            while (i < vlen) {
                ByteArrayCodec.encodeDLE(b, boff, v[voff + i]);
                boff += 8;
                ++i;
            }
        }
    }
}

