/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.internal.CompoundTypeImpl;
import com.bc.ceres.binio.internal.VarElementCountSequenceTypeImpl;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class TypeParser {
    private final HashMap<String, SimpleType> simpleTypeMap;
    private final HashMap<String, CompoundType> compoundTypeMap;
    private final StreamTokenizer st;
    private static final String UNRESOLVED = "Unresolved@";
    public static final SimpleType[] SIMPLE_TYPES = new SimpleType[]{SimpleType.BYTE, SimpleType.UBYTE, SimpleType.SHORT, SimpleType.USHORT, SimpleType.INT, SimpleType.UINT, SimpleType.LONG, SimpleType.ULONG, SimpleType.FLOAT, SimpleType.DOUBLE};

    private TypeParser(StreamTokenizer st) {
        this.st = st;
        this.compoundTypeMap = new HashMap(11);
        this.simpleTypeMap = new HashMap(11);
        SimpleType[] simpleTypeArray = SIMPLE_TYPES;
        int n = SIMPLE_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            SimpleType type = simpleTypeArray[n2];
            this.registerSimpleType(type);
            ++n2;
        }
    }

    private void registerSimpleType(SimpleType type) {
        this.simpleTypeMap.put(type.getName(), type);
    }

    public static CompoundType[] parseUnit(Reader reader) throws IOException, ParseException {
        StreamTokenizer st = new StreamTokenizer(reader);
        st.resetSyntax();
        st.eolIsSignificant(false);
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.parseNumbers();
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(95, 95);
        st.wordChars(48, 57);
        st.whitespaceChars(0, 32);
        st.quoteChar(34);
        TypeParser typeParser = new TypeParser(st);
        CompoundType[] compoundTypes = typeParser.parseCompoundTypes();
        typeParser.resolve(compoundTypes);
        return compoundTypes;
    }

    private void resolve(CompoundType[] compoundTypes) throws ParseException {
        CompoundType[] compoundTypeArray = compoundTypes;
        int n = compoundTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CompoundType compoundType = compoundTypeArray[n2];
            this.resolve(compoundType);
            ++n2;
        }
    }

    private Type resolveType(Type type) throws ParseException {
        Type resolvedType = type instanceof CompoundType ? this.resolve((CompoundType)type) : (type instanceof SequenceType ? this.resolve((SequenceType)type) : type);
        return resolvedType;
    }

    private CompoundType resolve(CompoundType compoundType) throws ParseException {
        if (compoundType.getName().startsWith(UNRESOLVED)) {
            String name = compoundType.getName().substring(UNRESOLVED.length());
            CompoundType resolvedType = this.compoundTypeMap.get(name);
            if (resolvedType == null) {
                throw new ParseException("Unresolved compound type: " + name, -1);
            }
            return resolvedType;
        }
        int i = 0;
        while (i < compoundType.getMemberCount()) {
            CompoundMember member = compoundType.getMember(i);
            Type memberType = member.getType();
            Type resolvedMemberType = this.resolveType(memberType);
            ((CompoundTypeImpl)compoundType).setMember(i, TypeBuilder.MEMBER(member.getName(), resolvedMemberType));
            ++i;
        }
        return compoundType;
    }

    private Type resolve(SequenceType sequenceType) throws ParseException {
        if (sequenceType instanceof VarElementCountSequenceTypeImpl) {
            VarElementCountSequenceTypeImpl varSequenceType = (VarElementCountSequenceTypeImpl)sequenceType;
            return TypeBuilder.VAR_SEQUENCE(this.resolveType(sequenceType.getElementType()), varSequenceType.getMemberName());
        }
        return TypeBuilder.SEQUENCE(this.resolveType(sequenceType.getElementType()), sequenceType.getElementCount());
    }

    public CompoundType[] parseCompoundTypes() throws IOException, ParseException {
        CompoundType compoundType;
        ArrayList<CompoundType> list = new ArrayList<CompoundType>(32);
        while ((compoundType = this.parseCompoundType()) != null) {
            list.add(compoundType);
            this.compoundTypeMap.put(compoundType.getName(), compoundType);
        }
        return list.toArray(new CompoundType[list.size()]);
    }

    private CompoundType parseCompoundType() throws IOException, ParseException {
        String name = this.parseName();
        if (name == null) {
            return null;
        }
        int token = this.st.nextToken();
        if (token != 123) {
            TypeParser.error(this.st, "'{' expected.");
        }
        CompoundMember[] members = this.parseMembers(name);
        token = this.st.nextToken();
        if (token != 125) {
            this.st.pushBack();
            TypeParser.error(this.st, "'}' expected.");
        }
        if ((token = this.st.nextToken()) != 59) {
            this.st.pushBack();
        }
        return TypeBuilder.COMPOUND(name, members);
    }

    private String parseName() throws IOException {
        String name;
        int token = this.st.nextToken();
        if (token == -3) {
            name = this.st.sval;
        } else if (token == 34) {
            name = this.st.sval;
        } else {
            this.st.pushBack();
            name = null;
        }
        return name;
    }

    private CompoundMember[] parseMembers(String parentCompoundName) throws IOException, ParseException {
        CompoundMember member;
        ArrayList<CompoundMember> list = new ArrayList<CompoundMember>(32);
        while ((member = this.parseMember(parentCompoundName)) != null) {
            list.add(member);
        }
        return list.toArray(new CompoundMember[list.size()]);
    }

    private CompoundMember parseMember(String parentCompoundName) throws IOException, ParseException {
        int token;
        Type type = this.parseType(parentCompoundName);
        if (type == null) {
            return null;
        }
        String name = this.parseName();
        if (name == null) {
            TypeParser.error(this.st, "Member name expected.");
        }
        if ((token = this.st.nextToken()) != 59) {
            this.st.pushBack();
            TypeParser.error(this.st, "';' expected.");
        }
        return TypeBuilder.MEMBER(name, type);
    }

    private Type parseType(String parentCompoundName) throws IOException, ParseException {
        int token;
        String name = this.parseName();
        if (name == null) {
            return null;
        }
        Type type = this.simpleTypeMap.get(name);
        if (type == null && (type = (Type)this.compoundTypeMap.get(name)) == null) {
            CompoundType unresolvedType = TypeBuilder.COMPOUND(UNRESOLVED + name, new CompoundMember[0]);
            this.compoundTypeMap.put(name, unresolvedType);
            type = unresolvedType;
        }
        while ((token = this.st.nextToken()) == 91) {
            token = this.st.nextToken();
            if (token == -2) {
                int elementCount = (int)this.st.nval;
                if ((double)elementCount != this.st.nval) {
                    TypeParser.error(this.st, "Integer element count expected.");
                }
                if ((token = this.st.nextToken()) != 93) {
                    TypeParser.error(this.st, "']' expected.");
                }
                type = TypeBuilder.SEQUENCE(type, elementCount);
                continue;
            }
            if (token == -3) {
                String lengthRefName = this.st.sval;
                if (lengthRefName.indexOf(46) == -1) {
                    lengthRefName = String.valueOf(parentCompoundName) + "." + lengthRefName;
                }
                type = TypeBuilder.VAR_SEQUENCE(type, lengthRefName);
                token = this.st.nextToken();
                if (token == 93) continue;
                TypeParser.error(this.st, "']' expected.");
                continue;
            }
            if (token == 93) {
                type = TypeBuilder.SEQUENCE(type, -1);
                continue;
            }
            this.st.pushBack();
            TypeParser.error(this.st, "Array length specifier expected after '['.");
        }
        this.st.pushBack();
        return type;
    }

    private static void error(StreamTokenizer st, String s) throws ParseException {
        throw new ParseException(s, st.lineno());
    }
}

