/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer;

import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryListener;
import com.bc.ceres.core.ServiceRegistryManager;
import com.bc.ceres.core.runtime.RuntimeContext;
import com.bc.ceres.glayer.LayerType;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;

public class LayerTypeRegistry {
    private final ServiceRegistry<LayerType> serviceRegistry = ServiceRegistryManager.getInstance().getServiceRegistry(LayerType.class);
    private final Map<String, String> aliases = new HashMap<String, String>(20);

    public static LayerType getLayerType(String name) {
        LayerType layerType = LayerTypeRegistry.getRegistry().getService(name);
        if (layerType != null) {
            return layerType;
        }
        Map<String, String> map = Holder.instance.aliases;
        String layerTypeName = map.get(name);
        if (layerTypeName != null) {
            layerType = LayerTypeRegistry.getRegistry().getService(layerTypeName);
        }
        return layerType;
    }

    public static <T extends LayerType> T getLayerType(Class<T> layerTypeClass) {
        return (T)LayerTypeRegistry.getRegistry().getService(layerTypeClass.getName());
    }

    public static Set<LayerType> getLayerTypes() {
        return LayerTypeRegistry.getRegistry().getServices();
    }

    private static ServiceRegistry<LayerType> getRegistry() {
        return Holder.instance.serviceRegistry;
    }

    private LayerTypeRegistry() {
        this.serviceRegistry.addListener(new ServiceRegistryListener<LayerType>(){

            @Override
            public void serviceAdded(ServiceRegistry<LayerType> registry, LayerType layerType) {
                LayerTypeRegistry.this.registerAliases(layerType);
            }

            @Override
            public void serviceRemoved(ServiceRegistry<LayerType> registry, LayerType layerType) {
                LayerTypeRegistry.this.unregisterAliases(layerType);
            }
        });
        Set<LayerType> services = this.serviceRegistry.getServices();
        for (LayerType layerType : services) {
            this.registerAliases(layerType);
        }
        if (!RuntimeContext.isAvailable()) {
            ServiceLoader<LayerType> serviceLoader = ServiceLoader.load(LayerType.class);
            for (LayerType layerType : serviceLoader) {
                this.serviceRegistry.addService(layerType);
            }
        }
    }

    private void registerAliases(LayerType layerType) {
        String[] layerTypeAliases;
        String layerTypeClassName = layerType.getClass().getName();
        this.aliases.put(layerType.getName(), layerTypeClassName);
        String[] stringArray = layerTypeAliases = layerType.getAliases();
        int n = layerTypeAliases.length;
        int n2 = 0;
        while (n2 < n) {
            String aliasName = stringArray[n2];
            this.aliases.put(aliasName, layerTypeClassName);
            ++n2;
        }
    }

    private void unregisterAliases(LayerType layerType) {
        String[] keys;
        String layerTypeClassName = layerType.getClass().getName();
        String layerTypeName = layerType.getName();
        if (this.aliases.get(layerTypeName).equalsIgnoreCase(layerTypeClassName)) {
            this.aliases.remove(layerTypeName);
        }
        String[] stringArray = keys = this.aliases.keySet().toArray(new String[0]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (this.aliases.get(key).equalsIgnoreCase(layerTypeClassName)) {
                this.aliases.remove(key);
            }
            ++n2;
        }
    }

    /* synthetic */ LayerTypeRegistry(LayerTypeRegistry layerTypeRegistry) {
        this();
    }

    private static class Holder {
        private static final LayerTypeRegistry instance = new LayerTypeRegistry(null);

        private Holder() {
        }
    }
}

