/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelRenderer;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.grender.InteractiveRendering;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.TileScheduler;

public class ConcurrentMultiLevelRenderer
implements MultiLevelRenderer {
    private static final boolean DEBUG = Boolean.getBoolean("ceres.renderer.debug");
    private final Map<TileIndex, TileRequest> scheduledTileRequests;
    private final TileImageCache localTileCache;
    private final DescendingLevelsComparator descendingLevelsComparator = new DescendingLevelsComparator();

    public ConcurrentMultiLevelRenderer() {
        this.scheduledTileRequests = Collections.synchronizedMap(new HashMap(37));
        this.localTileCache = new TileImageCache();
        if (DEBUG) {
            TileCache tileCache = JAI.getDefaultInstance().getTileCache();
            TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
            System.out.println("jai.tileScheduler.priority = " + tileScheduler.getPriority());
            System.out.println("jai.tileScheduler.parallelism = " + tileScheduler.getParallelism());
            System.out.println("jai.tileScheduler.prefetchPriority = " + tileScheduler.getPrefetchPriority());
            System.out.println("jai.tileScheduler.prefetchParallelism = " + tileScheduler.getPrefetchParallelism());
            System.out.println("jai.tileCache.memoryCapacity = " + tileCache.getMemoryCapacity());
            System.out.println("jai.tileCache.memoryThreshold = " + tileCache.getMemoryThreshold());
        }
    }

    @Override
    public synchronized void reset() {
        this.cancelTileRequests(-1);
        this.localTileCache.clear();
    }

    @Override
    public void renderImage(Rendering rendering, MultiLevelSource multiLevelSource, int currentLevel) {
        long t0 = System.nanoTime();
        this.renderImpl((InteractiveRendering)rendering, multiLevelSource, currentLevel);
        if (DEBUG) {
            long t1 = System.nanoTime();
            double time = (double)(t1 - t0) / 1000000.0;
            System.out.printf("ConcurrentMultiLevelRenderer: render: time=%f ms, clip=%s\n", time, rendering.getGraphics().getClip());
        }
    }

    private void renderImpl(InteractiveRendering rendering, MultiLevelSource multiLevelSource, int currentLevel) {
        PlanarImage planarImage = (PlanarImage)multiLevelSource.getImage(currentLevel);
        Graphics2D graphics = rendering.getGraphics();
        Viewport viewport = rendering.getViewport();
        ColorModel colorModel = planarImage.getColorModel();
        if (colorModel == null) {
            throw new IllegalStateException("colorModel == null");
        }
        Rectangle viewBounds = viewport.getViewBounds();
        Rectangle clipBounds = graphics.getClipBounds();
        Rectangle clippedImageRegion = ConcurrentMultiLevelRenderer.getImageRegion(viewport, multiLevelSource, currentLevel, clipBounds != null ? clipBounds : viewBounds);
        Set<TileIndex> requiredTileIndexes = ConcurrentMultiLevelRenderer.getTileIndexes(planarImage, multiLevelSource.getImageShape(currentLevel), currentLevel, clippedImageRegion);
        if (requiredTileIndexes.isEmpty()) {
            return;
        }
        ArrayList<TileIndex> availableTileIndexList = new ArrayList<TileIndex>(requiredTileIndexes.size());
        ArrayList<TileIndex> missingTileIndexList = new ArrayList<TileIndex>(requiredTileIndexes.size());
        ArrayList<TileIndex> notScheduledTileIndexList = new ArrayList<TileIndex>(requiredTileIndexes.size());
        for (TileIndex requiredTileIndex : requiredTileIndexes) {
            if (this.localTileCache.contains(requiredTileIndex)) {
                availableTileIndexList.add(requiredTileIndex);
                continue;
            }
            missingTileIndexList.add(requiredTileIndex);
            if (this.scheduledTileRequests.containsKey(requiredTileIndex)) continue;
            notScheduledTileIndexList.add(requiredTileIndex);
        }
        if (!notScheduledTileIndexList.isEmpty()) {
            TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
            TileComputationHandler tileComputationHandler = new TileComputationHandler(rendering, multiLevelSource, currentLevel);
            TileRequest tileRequest = tileScheduler.scheduleTiles(planarImage, ConcurrentMultiLevelRenderer.getPoints(notScheduledTileIndexList), new TileComputationListener[]{tileComputationHandler});
            for (TileIndex tileIndex : notScheduledTileIndexList) {
                this.scheduledTileRequests.put(tileIndex, tileRequest);
            }
        }
        this.drawTentativeTileImages(graphics, viewport, multiLevelSource, currentLevel, planarImage, missingTileIndexList);
        for (TileIndex tileIndex : availableTileIndexList) {
            TileImage tileImage = this.localTileCache.get(tileIndex);
            ConcurrentMultiLevelRenderer.drawTileImage(graphics, viewport, tileImage);
        }
        if (DEBUG) {
            AffineTransform i2m = multiLevelSource.getModel().getImageToModelTransform(currentLevel);
            this.drawTileImageFrames(graphics, viewport, availableTileIndexList, i2m, Color.YELLOW);
            ConcurrentMultiLevelRenderer.drawTileFrames(graphics, viewport, planarImage, missingTileIndexList, i2m, Color.RED);
            ConcurrentMultiLevelRenderer.drawTileFrames(graphics, viewport, planarImage, availableTileIndexList, i2m, Color.BLUE);
        }
        Rectangle visibleImageRegion = ConcurrentMultiLevelRenderer.getImageRegion(viewport, multiLevelSource, currentLevel, viewBounds);
        Set<TileIndex> visibleTileIndexSet = ConcurrentMultiLevelRenderer.getTileIndexes(planarImage, multiLevelSource.getImageShape(currentLevel), currentLevel, visibleImageRegion);
        if (!visibleTileIndexSet.isEmpty()) {
            this.cancelTileRequests(visibleTileIndexSet);
        }
        this.localTileCache.adjustTrimSize(planarImage, visibleTileIndexSet.size());
        this.localTileCache.trim(currentLevel, visibleTileIndexSet);
    }

    private void drawTentativeTileImages(Graphics2D g, Viewport vp, MultiLevelSource multiLevelSource, int level, PlanarImage planarImage, List<TileIndex> missingTileIndexList) {
        AffineTransform i2m = multiLevelSource.getModel().getImageToModelTransform(level);
        for (TileIndex tileIndex : missingTileIndexList) {
            Rectangle tileRect = planarImage.getTileRect(tileIndex.tileX, tileIndex.tileY);
            Rectangle2D bounds = i2m.createTransformedShape(tileRect).getBounds2D();
            TreeSet<TileImage> tentativeTileImageSet = new TreeSet<TileImage>(this.descendingLevelsComparator);
            Collection<TileImage> tileImages = this.localTileCache.getAll();
            TileImage containedTileImage = null;
            int containedLevel = Integer.MAX_VALUE;
            for (TileImage tileImage : tileImages) {
                int someLevel = tileImage.tileIndex.level;
                if (someLevel <= level || someLevel >= containedLevel || !tileImage.bounds.contains(bounds)) continue;
                containedTileImage = tileImage;
                containedLevel = someLevel;
            }
            if (containedTileImage != null) {
                tentativeTileImageSet.add(containedTileImage);
                for (TileImage tileImage : tileImages) {
                    if (tileImage.tileIndex.level >= level || !tileImage.bounds.intersects(bounds)) continue;
                    tentativeTileImageSet.add(tileImage);
                }
            } else {
                for (TileImage tileImage : tileImages) {
                    if (tileImage.tileIndex.level == level || !tileImage.bounds.intersects(bounds)) continue;
                    tentativeTileImageSet.add(tileImage);
                }
            }
            Shape oldClip = g.getClip();
            Rectangle newClip = vp.getModelToViewTransform().createTransformedShape(bounds).getBounds();
            newClip = newClip.intersection(vp.getViewBounds());
            g.setClip(newClip);
            for (TileImage tileImage : tentativeTileImageSet) {
                ConcurrentMultiLevelRenderer.drawTileImage(g, vp, tileImage);
            }
            g.setClip(oldClip);
        }
    }

    private static Point[] getPoints(List<TileIndex> tileIndexList) {
        Point[] points = new Point[tileIndexList.size()];
        int i = 0;
        while (i < tileIndexList.size()) {
            TileIndex tileIndex = tileIndexList.get(i);
            points[i] = new Point(tileIndex.tileX, tileIndex.tileY);
            ++i;
        }
        return points;
    }

    private static Set<TileIndex> getTileIndexes(PlanarImage planarImage, Shape imageShape, int level, Rectangle clippedImageRegion) {
        Point[] indices = planarImage.getTileIndices(clippedImageRegion);
        if (indices == null || indices.length == 0) {
            return Collections.emptySet();
        }
        HashSet<TileIndex> indexes = new HashSet<TileIndex>(3 * indices.length / 2);
        Point[] pointArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            Point point = pointArray[n2];
            Rectangle tileRect = planarImage.getTileRect(point.x, point.y);
            if (imageShape == null || imageShape.intersects(tileRect)) {
                indexes.add(new TileIndex(point.x, point.y, level));
            }
            ++n2;
        }
        return indexes;
    }

    private static void drawTileImage(Graphics2D g, Viewport vp, TileImage ti) {
        AffineTransform t = AffineTransform.getTranslateInstance(ti.x, ti.y);
        t.preConcatenate(ti.i2m);
        t.preConcatenate(vp.getModelToViewTransform());
        g.drawRenderedImage(ti.image, t);
        ti.lastAccessTime = System.currentTimeMillis();
    }

    private void drawTileImageFrames(Graphics2D g, Viewport vp, List<TileIndex> tileIndices, AffineTransform i2m, Color frameColor) {
        AffineTransform m2v = vp.getModelToViewTransform();
        AffineTransform oldTransform = g.getTransform();
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        AffineTransform t = new AffineTransform();
        t.preConcatenate(i2m);
        t.preConcatenate(m2v);
        g.setTransform(t);
        g.setColor(new Color(frameColor.getRed(), frameColor.getGreen(), frameColor.getBlue(), 127));
        g.setStroke(new BasicStroke(5.0f));
        for (TileIndex tileIndex : tileIndices) {
            TileImage tileImage = this.localTileCache.get(tileIndex);
            Rectangle tileRect = new Rectangle(tileImage.x, tileImage.y, tileImage.image.getWidth(), tileImage.image.getHeight());
            g.draw(tileRect);
            System.out.println("Tile image bounds: " + tileRect);
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
        g.setTransform(oldTransform);
    }

    private static void drawTileFrames(Graphics2D g, Viewport vp, PlanarImage planarImage, List<TileIndex> tileIndices, AffineTransform i2m, Color frameColor) {
        AffineTransform m2v = vp.getModelToViewTransform();
        AffineTransform oldTransform = g.getTransform();
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        AffineTransform t = new AffineTransform();
        t.preConcatenate(i2m);
        t.preConcatenate(m2v);
        g.setTransform(t);
        g.setColor(frameColor);
        g.setStroke(new BasicStroke(1.0f));
        for (TileIndex tileIndex : tileIndices) {
            g.draw(planarImage.getTileRect(tileIndex.tileX, tileIndex.tileY));
        }
        g.setStroke(oldStroke);
        g.setColor(oldColor);
        g.setTransform(oldTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTileRequests(Set<TileIndex> visibleTileIndexSet) {
        HashMap<TileIndex, TileRequest> scheduledTileRequestsCopy;
        Map<TileIndex, TileRequest> map = this.scheduledTileRequests;
        synchronized (map) {
            scheduledTileRequestsCopy = new HashMap<TileIndex, TileRequest>(this.scheduledTileRequests);
        }
        for (Map.Entry scheduledTileEntry : scheduledTileRequestsCopy.entrySet()) {
            TileRequest request;
            TileIndex scheduledTileIndex = (TileIndex)scheduledTileEntry.getKey();
            if (visibleTileIndexSet.contains(scheduledTileIndex) || (request = (TileRequest)scheduledTileEntry.getValue()) == null) continue;
            this.scheduledTileRequests.remove(scheduledTileIndex);
            request.cancelTiles(new Point[]{new Point(scheduledTileIndex.tileX, scheduledTileIndex.tileY)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelTileRequests(int currentLevel) {
        HashMap<TileIndex, TileRequest> scheduledTileRequestsCopy;
        Map<TileIndex, TileRequest> map = this.scheduledTileRequests;
        synchronized (map) {
            scheduledTileRequestsCopy = new HashMap<TileIndex, TileRequest>(this.scheduledTileRequests);
        }
        for (Map.Entry entry : scheduledTileRequestsCopy.entrySet()) {
            TileIndex tileIndex = (TileIndex)entry.getKey();
            if (tileIndex.level == currentLevel) continue;
            this.scheduledTileRequests.remove(tileIndex);
            ((TileRequest)entry.getValue()).cancelTiles(null);
        }
    }

    private static TileImage createTileImage(GraphicsConfiguration deviceConfiguration, PlanarImage planarImage, TileIndex tileIndex, Raster tile, AffineTransform i2m) {
        RenderedImage image = ConcurrentMultiLevelRenderer.createDeviceCompatibleImageForTile(deviceConfiguration, planarImage, tileIndex, tile);
        return new TileImage(image, tileIndex, planarImage.tileXToX(tileIndex.tileX), planarImage.tileYToY(tileIndex.tileY), i2m);
    }

    private static RenderedImage createDeviceCompatibleImageForTile(GraphicsConfiguration deviceConfiguration, PlanarImage planarImage, TileIndex tileIndex, Raster tile) {
        SampleModel sm = planarImage.getSampleModel();
        ColorModel cm = planarImage.getColorModel();
        Rectangle r = planarImage.getTileRect(tileIndex.tileX, tileIndex.tileY);
        DataBuffer db = tile.getDataBuffer();
        WritableRaster wr = Raster.createWritableRaster(sm, db, null);
        BufferedImage bi = new BufferedImage(cm, wr, cm.isAlphaPremultiplied(), null);
        if (r.width == tile.getWidth() && r.height == tile.getHeight() && deviceConfiguration.getColorModel().isCompatibleRaster(wr)) {
            return bi;
        }
        BufferedImage bi2 = deviceConfiguration.createCompatibleImage(r.width, r.height, bi.getTransparency());
        Graphics2D g = bi2.createGraphics();
        g.drawRenderedImage(bi, null);
        g.dispose();
        return bi2;
    }

    private static Rectangle getImageRegion(Viewport vp, MultiLevelSource multiLevelSource, int level, Rectangle2D viewRegion) {
        return ConcurrentMultiLevelRenderer.getViewToImageTransform(vp, multiLevelSource, level).createTransformedShape(viewRegion).getBounds();
    }

    private static Rectangle getViewRegion(Viewport vp, MultiLevelSource multiLevelSource, int level, Rectangle2D imageRegion) {
        return ConcurrentMultiLevelRenderer.getImageToViewTransform(vp, multiLevelSource, level).createTransformedShape(imageRegion).getBounds();
    }

    private static AffineTransform getViewToImageTransform(Viewport vp, MultiLevelSource multiLevelSource, int level) {
        AffineTransform t = vp.getViewToModelTransform();
        t.preConcatenate(multiLevelSource.getModel().getModelToImageTransform(level));
        return t;
    }

    private static AffineTransform getImageToViewTransform(Viewport vp, MultiLevelSource multiLevelSource, int level) {
        AffineTransform t = new AffineTransform(multiLevelSource.getModel().getImageToModelTransform(level));
        t.preConcatenate(vp.getModelToViewTransform());
        return t;
    }

    private static int compareAscending(TileImage ti1, TileImage ti2) {
        int d = ti1.tileIndex.level - ti2.tileIndex.level;
        if (d != 0) {
            return d;
        }
        d = ti1.tileIndex.tileY - ti2.tileIndex.tileY;
        if (d != 0) {
            return d;
        }
        d = ti1.tileIndex.tileX - ti2.tileIndex.tileX;
        if (d != 0) {
            return d;
        }
        return 0;
    }

    private static class DescendingLevelsComparator
    implements Comparator<TileImage> {
        private DescendingLevelsComparator() {
        }

        @Override
        public int compare(TileImage ti1, TileImage ti2) {
            return ConcurrentMultiLevelRenderer.compareAscending(ti2, ti1);
        }
    }

    private class TileComputationHandler
    implements TileComputationListener {
        private final InteractiveRendering rendering;
        private final GraphicsConfiguration deviceConfiguration;
        private final MultiLevelSource multiLevelSource;
        private final int level;

        private TileComputationHandler(InteractiveRendering rendering, MultiLevelSource multiLevelSource, int level) {
            this.rendering = rendering;
            this.deviceConfiguration = rendering.getGraphics().getDeviceConfiguration();
            this.multiLevelSource = multiLevelSource;
            this.level = level;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void tileComputed(Object object, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY, Raster tile) {
            if (tile == null) {
                if (DEBUG) {
                    System.out.println("WARNING: tileComputed: tile == null!");
                }
                return;
            }
            TileIndex tileIndex = new TileIndex(tileX, tileY, this.level);
            ConcurrentMultiLevelRenderer.this.scheduledTileRequests.containsKey(tileIndex);
            TileImage tileImage = ConcurrentMultiLevelRenderer.createTileImage(this.deviceConfiguration, planarImage, tileIndex, tile, this.multiLevelSource.getModel().getImageToModelTransform(this.level));
            ConcurrentMultiLevelRenderer concurrentMultiLevelRenderer = ConcurrentMultiLevelRenderer.this;
            synchronized (concurrentMultiLevelRenderer) {
                ConcurrentMultiLevelRenderer.this.scheduledTileRequests.remove(tileIndex);
                ConcurrentMultiLevelRenderer.this.localTileCache.add(tileImage);
            }
            final Rectangle tileBounds = tile.getBounds();
            this.rendering.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle viewRegion = ConcurrentMultiLevelRenderer.getViewRegion(TileComputationHandler.this.rendering.getViewport(), TileComputationHandler.this.multiLevelSource, TileComputationHandler.this.level, tileBounds);
                    TileComputationHandler.this.rendering.invalidateRegion(viewRegion);
                }
            });
        }

        @Override
        public void tileCancelled(Object object, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY) {
            TileIndex tileIndex = new TileIndex(tileX, tileY, this.level);
            this.dropTile(tileIndex);
            if (DEBUG) {
                System.out.printf("ConcurrentMultiLevelRenderer: tileCancelled: %s\n", tileIndex);
            }
        }

        @Override
        public void tileComputationFailure(Object object, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY, Throwable error) {
            TileIndex tileIndex = new TileIndex(tileX, tileY, this.level);
            this.dropTile(tileIndex);
            if (DEBUG) {
                System.out.printf("ConcurrentMultiLevelRenderer: tileComputationFailure: %s\n", tileIndex);
                error.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dropTile(TileIndex tileIndex) {
            ConcurrentMultiLevelRenderer concurrentMultiLevelRenderer = ConcurrentMultiLevelRenderer.this;
            synchronized (concurrentMultiLevelRenderer) {
                ConcurrentMultiLevelRenderer.this.scheduledTileRequests.remove(tileIndex);
                ConcurrentMultiLevelRenderer.this.localTileCache.remove(tileIndex);
            }
        }
    }

    private static final class TileImage {
        private final RenderedImage image;
        private final TileIndex tileIndex;
        private final int x;
        private final int y;
        private final AffineTransform i2m;
        private final Rectangle2D bounds;
        private final long size;
        private long lastAccessTime;

        private TileImage(RenderedImage image, TileIndex tileIndex, int x, int y, AffineTransform i2m) {
            this.image = image;
            this.tileIndex = tileIndex;
            this.x = x;
            this.y = y;
            this.i2m = new AffineTransform(i2m);
            this.bounds = i2m.createTransformedShape(new Rectangle(x, y, image.getWidth(), image.getHeight())).getBounds2D();
            this.size = image.getWidth() * image.getHeight() * (image.getSampleModel().getNumBands() * image.getSampleModel().getSampleSize(0)) / 8;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public String toString() {
            return String.format("TileImage[tileIndex=%s,size=%d,bounds=%s]", String.valueOf(this.tileIndex), this.size, String.valueOf(this.bounds));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileImage tileImage = (TileImage)object;
            return this.tileIndex.equals(tileImage.tileIndex);
        }

        public int hashCode() {
            return this.tileIndex.hashCode();
        }
    }

    private final class TileImageCache {
        private final Map<TileIndex, TileImage> cache = new HashMap<TileIndex, TileImage>(37);
        private long currentSize = 0L;
        private long trimSize;
        private final boolean adaptive;
        private final double tileFactor;
        private final long minSize;
        private final long maxSize;
        private final long retentionPeriod = Long.parseLong(System.getProperty("ceres.renderer.cache.retentionPeriod", "10000"));

        public TileImageCache() {
            this.adaptive = Boolean.parseBoolean(System.getProperty("ceres.renderer.cache.adaptive", "true"));
            this.tileFactor = Double.parseDouble(System.getProperty("ceres.renderer.cache.tileFactor", "2.5"));
            this.minSize = Long.parseLong(System.getProperty("ceres.renderer.cache.minSize", "0")) * 0x100000L;
            this.maxSize = Long.parseLong(System.getProperty("ceres.renderer.cache.maxSize", System.getProperty("ceres.renderer.cache.capacity", "64"))) * 0x100000L;
            this.trimSize = this.maxSize;
        }

        public synchronized boolean contains(TileIndex tileIndex) {
            return this.cache.containsKey(tileIndex);
        }

        public synchronized TileImage get(TileIndex tileIndex) {
            return this.cache.get(tileIndex);
        }

        public synchronized Collection<TileImage> getAll() {
            return new ArrayList<TileImage>(this.cache.values());
        }

        public synchronized void add(TileImage tileImage) {
            TileImage oldTileImage = this.cache.put(tileImage.tileIndex, tileImage);
            if (oldTileImage != null) {
                this.currentSize -= oldTileImage.size;
            }
            this.currentSize += tileImage.size;
            if (DEBUG) {
                System.out.printf("ConcurrentMultiLevelRenderer$TileImageCache: add: tileIndex=%s, size=%d\n", tileImage.tileIndex, this.currentSize);
            }
        }

        public synchronized void remove(TileIndex tileIndex) {
            TileImage oldTileImage = this.cache.remove(tileIndex);
            if (oldTileImage != null) {
                this.currentSize -= oldTileImage.size;
                if (DEBUG) {
                    System.out.printf("ConcurrentMultiLevelRenderer$TileImageCache: remove: tileIndex=%s, size=%d\n", tileIndex, this.currentSize);
                }
            }
        }

        public synchronized void clear() {
            this.cache.clear();
            this.currentSize = 0L;
        }

        public void adjustTrimSize(PlanarImage image, int numRequiredTiles) {
            if (this.adaptive) {
                SampleModel sm = image.getSampleModel();
                long pixelSize = (long)(sm.getNumBands() * sm.getSampleSize(0)) / 8L;
                long tileSize = (long)sm.getWidth() * (long)sm.getHeight() * pixelSize;
                long trimSize = Math.round(this.tileFactor * (double)numRequiredTiles) * tileSize;
                if (this.minSize >= 0L && trimSize < this.minSize) {
                    trimSize = this.minSize;
                }
                if (this.maxSize >= 0L && trimSize > this.maxSize) {
                    trimSize = this.maxSize;
                }
                this.trimSize = trimSize;
            } else {
                this.trimSize = this.maxSize;
            }
        }

        public synchronized void trim(int currentLevel, Set<TileIndex> visibleTileIndexes) {
            if (DEBUG) {
                long oneMiB = 0x100000L;
                System.out.println("ConcurrentMultiLevelRenderer.TileImageCache:");
                System.out.printf("    currentSize     = %10d%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.currentSize / oneMiB);
                System.out.printf("    trimSize        = %10d%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.trimSize / oneMiB);
                System.out.printf("    minSize         = %10d%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.minSize / oneMiB);
                System.out.printf("    maxSize         = %10d%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.maxSize / oneMiB);
                System.out.printf("    tileFactor      = %f%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.tileFactor);
                System.out.printf("    retentionPeriod = %d%n", ((ConcurrentMultiLevelRenderer)ConcurrentMultiLevelRenderer.this).localTileCache.retentionPeriod);
            }
            if (this.currentSize > this.trimSize) {
                long now = System.currentTimeMillis();
                ArrayList<TileImage> tileImages = new ArrayList<TileImage>(this.cache.values());
                for (TileImage tileImage : tileImages) {
                    if (visibleTileIndexes.contains(tileImage.tileIndex) || tileImage.tileIndex.level == currentLevel) continue;
                    this.maybeRemove(tileImage, now);
                }
                for (TileImage tileImage : tileImages) {
                    if (visibleTileIndexes.contains(tileImage.tileIndex) || tileImage.tileIndex.level != currentLevel) continue;
                    this.maybeRemove(tileImage, now);
                }
            }
        }

        private void maybeRemove(TileImage image, long now) {
            long age = now - image.lastAccessTime;
            if (age > this.retentionPeriod) {
                this.remove(image.tileIndex);
            }
        }
    }

    private static final class TileIndex {
        private final int tileX;
        private final int tileY;
        private final int level;

        private TileIndex(int tileX, int tileY, int level) {
            this.tileX = tileX;
            this.tileY = tileY;
            this.level = level;
        }

        Point getPoint() {
            return new Point(this.tileX, this.tileY);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TileIndex tileIndex = (TileIndex)object;
            return this.level == tileIndex.level && this.tileY == tileIndex.tileY && this.tileX == tileIndex.tileX;
        }

        public int hashCode() {
            return 31 * (31 * this.level + this.tileY) + this.tileX;
        }

        public String toString() {
            return String.format("TileIndex[tileX=%d,tileY=%d,level=%d]", this.tileX, this.tileY, this.level);
        }
    }
}

