/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.media.jai.operator.FileLoadDescriptor;

public class FileMultiLevelSource
extends AbstractMultiLevelSource {
    private final File location;
    private final String basename;
    private final String extension;

    public FileMultiLevelSource(File location, String basename, String extension, MultiLevelModel multiLevelModel) {
        super(multiLevelModel);
        this.location = location;
        this.basename = basename;
        this.extension = extension;
    }

    public File getLocation() {
        return this.location;
    }

    public String getBasename() {
        return this.basename;
    }

    public String getExtension() {
        return this.extension;
    }

    @Override
    public RenderedImage createImage(int level) {
        StringBuilder sb = new StringBuilder(this.basename);
        sb.append('.');
        sb.append(level);
        sb.append('.');
        sb.append(this.extension);
        String fileName = sb.toString();
        File file = new File(this.location, fileName);
        return FileLoadDescriptor.create(file.getPath(), null, true, null).getRendering();
    }

    public static FileMultiLevelSource create(File location, String extension, AffineTransform imageToModelTransform, int levelCount) {
        DefaultMultiLevelModel defaultMultiLevelModel = new DefaultMultiLevelModel(levelCount, imageToModelTransform, null);
        FileMultiLevelSource levelImageSource = new FileMultiLevelSource(location, location.getName(), extension, defaultMultiLevelModel);
        Rectangle2D modelBounds = DefaultMultiLevelModel.getModelBounds(imageToModelTransform, levelImageSource.getImage(0));
        defaultMultiLevelModel.setModelBounds(modelBounds);
        return levelImageSource;
    }
}

