/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ScalingType;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;

public class ReinterpretDescriptor
extends OperationDescriptorImpl {
    public static final String PARAM_NAME_FACTOR = "factor";
    public static final String PARAM_NAME_OFFSET = "offset";
    public static final String PARAM_NAME_SCALING_TYPE = "scalingType";
    public static final String PARAM_NAME_INTERPRETATION_TYPE = "interpretationType";
    public static final InterpretationType AWT = new InterpretationType("AWT", 0);
    public static final InterpretationType INTERPRET_BYTE_SIGNED = new InterpretationType("INTERPRET_BYTE_SIGNED", 1);
    public static final InterpretationType INTERPRET_INT_UNSIGNED = new InterpretationType("INTERPRET_INT_UNSIGNED", 2);
    public static final ScalingType LINEAR = new ScalingType("LINEAR", 0);
    public static final ScalingType EXPONENTIAL = new ScalingType("EXPONENTIAL", 1);
    public static final ScalingType LOGARITHMIC = new ScalingType("LOGARITHMIC", 2);
    private static final String[][] RESOURCES = new String[][]{{"GlobalName", "Reinterpret"}, {"LocalName", "Reinterpret"}, {"Vendor", "com.bc.ceres.jai"}, {"Description", "Reinterprets an image by applying a rescaling or reformatting."}, {"DocURL", ""}, {"Version", "1.0"}, {"arg0Desc", "Scaling factor"}, {"arg1Desc", "Scaling offset"}, {"arg2Desc", "Scaling type"}, {"arg3Desc", "Interpretation type"}};
    private static final String[] SUPPORTED_MODES = new String[]{"rendered"};
    private static final String[] PARAM_NAMES = new String[]{"factor", "offset", "scalingType", "interpretationType"};
    private static final Class[] PARAM_CLASSES = new Class[]{Double.class, Double.class, ScalingType.class, InterpretationType.class};
    private static final Object[] PARAM_DEFAULTS = new Object[]{1.0, 0.0, LINEAR, AWT};

    public ReinterpretDescriptor() {
        super(RESOURCES, SUPPORTED_MODES, 1, PARAM_NAMES, PARAM_CLASSES, PARAM_DEFAULTS, null);
    }

    public static RenderedOp create(RenderedImage source, double factor, double offset, ScalingType scalingType, InterpretationType interpretationType, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Reinterpret", "rendered");
        pb.setSource("source0", source);
        pb.setParameter(PARAM_NAME_FACTOR, factor);
        pb.setParameter(PARAM_NAME_OFFSET, offset);
        pb.setParameter(PARAM_NAME_SCALING_TYPE, scalingType);
        pb.setParameter(PARAM_NAME_INTERPRETATION_TYPE, interpretationType);
        return JAI.create("Reinterpret", pb, hints);
    }

    public static ImageLayout createTargetImageLayout(RenderedImage source, SampleModel sampleModel) {
        ImageLayout imageLayout = new ImageLayout(source);
        imageLayout.setSampleModel(sampleModel);
        return imageLayout;
    }

    public static int getTargetDataType(int sourceDataType, double factor, double offset, ScalingType scalingType, InterpretationType interpretationType) {
        boolean rescale;
        boolean bl = rescale = scalingType != LINEAR || factor != 1.0 || offset != 0.0;
        if (rescale) {
            switch (sourceDataType) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    return 4;
                }
                case 3: 
                case 5: {
                    return 5;
                }
            }
            return 32;
        }
        switch (sourceDataType) {
            case 0: {
                if (interpretationType == INTERPRET_BYTE_SIGNED) {
                    return 2;
                }
            }
            case 3: {
                if (interpretationType != INTERPRET_INT_UNSIGNED) break;
                return 5;
            }
        }
        return sourceDataType;
    }
}

