/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.operation.distance;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.distance.DistanceOp;

public class ClosestPointExample {
    static GeometryFactory fact = new GeometryFactory();
    static WKTReader wktRdr = new WKTReader(fact);

    public static void main(String[] args) {
        ClosestPointExample example = new ClosestPointExample();
        example.run();
    }

    public void run() {
        this.findClosestPoint("POLYGON ((200 180, 60 140, 60 260, 200 180))", "POINT (140 280)");
        this.findClosestPoint("POLYGON ((200 180, 60 140, 60 260, 200 180))", "MULTIPOINT (140 280, 140 320)");
        this.findClosestPoint("LINESTRING (100 100, 200 100, 200 200, 100 200, 100 100)", "POINT (10 10)");
        this.findClosestPoint("LINESTRING (100 100, 200 200)", "LINESTRING (100 200, 200 100)");
        this.findClosestPoint("LINESTRING (100 100, 200 200)", "LINESTRING (150 121, 200 0)");
        this.findClosestPoint("POLYGON (( 76 185, 125 283, 331 276, 324 122, 177 70, 184 155, 69 123, 76 185 ), ( 267 237, 148 248, 135 185, 223 189, 251 151, 286 183, 267 237 ))", "LINESTRING ( 153 204, 185 224, 209 207, 238 222, 254 186 )");
        this.findClosestPoint("POLYGON (( 76 185, 125 283, 331 276, 324 122, 177 70, 184 155, 69 123, 76 185 ), ( 267 237, 148 248, 135 185, 223 189, 251 151, 286 183, 267 237 ))", "LINESTRING ( 120 215, 185 224, 209 207, 238 222, 254 186 )");
    }

    public void findClosestPoint(String wktA, String wktB) {
        System.out.println("-------------------------------------");
        try {
            Geometry A = wktRdr.read(wktA);
            Geometry B2 = wktRdr.read(wktB);
            System.out.println("Geometry A: " + A);
            System.out.println("Geometry B: " + B2);
            DistanceOp distOp = new DistanceOp(A, B2);
            double distance = distOp.distance();
            System.out.println("Distance = " + distance);
            Coordinate[] closestPt = distOp.nearestPoints();
            LineString closestPtLine = fact.createLineString(closestPt);
            System.out.println("Closest points: " + closestPtLine + " (distance = " + closestPtLine.getLength() + ")");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

