/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa;

import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import org.esa.beam.dataio.avhrr.BandReader;
import org.esa.beam.dataio.avhrr.calibration.Calibrator;
import org.esa.beam.dataio.avhrr.noaa.CountReader10Bit;
import org.esa.beam.dataio.avhrr.noaa.CountReader16Bit;
import org.esa.beam.dataio.avhrr.noaa.CountReader8Bit;
import org.esa.beam.dataio.avhrr.noaa.KlmAvhrrFile;
import org.esa.beam.dataio.avhrr.noaa.ProductDimension;
import org.esa.beam.framework.dataio.ProductIOException;

enum ProductFormat {
    HRPT_8BIT(12288, SimpleType.BYTE, 10240, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader8Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    HRPT_10BIT(15872, SimpleType.INT, 3414, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader10Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    HRPT_16BIT(22528, SimpleType.SHORT, 10240, ProductDimension.HRPT){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader16Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_8BIT(3584, SimpleType.BYTE, 2045, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader8Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_10BIT(4608, SimpleType.INT, 682, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader10Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    }
    ,
    GAC_16BIT(5632, SimpleType.SHORT, 2045, ProductDimension.GAC){

        @Override
        public BandReader createCountReader(int channel, KlmAvhrrFile klmAvhrrFile, Calibrator calibrator) {
            return new CountReader16Bit(channel, klmAvhrrFile, calibrator, this.getElementCount(), this.getProductDimension().getDataWidth());
        }
    };

    private final int blockSize;
    private final ProductDimension productDimension;
    private final Type elementType;
    private final int elementCount;

    private ProductFormat(int blockSize, Type elementType, int elementCount, ProductDimension productDimension) {
        this.blockSize = blockSize;
        this.elementType = elementType;
        this.elementCount = elementCount;
        this.productDimension = productDimension;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public ProductDimension getProductDimension() {
        return this.productDimension;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public abstract BandReader createCountReader(int var1, KlmAvhrrFile var2, Calibrator var3);

    public static ProductFormat findByBlockSize(int blockSize) throws ProductIOException {
        ProductFormat[] values;
        ProductFormat[] productFormatArray = values = ProductFormat.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            ProductFormat productFormat = productFormatArray[n2];
            if (productFormat.getBlockSize() == blockSize) {
                return productFormat;
            }
            ++n2;
        }
        throw new ProductIOException("Unsupported AVHRR data record size: " + blockSize);
    }

    /* synthetic */ ProductFormat(String string, int n, int n2, Type type, int n3, ProductDimension productDimension, ProductFormat productFormat) {
        this(n2, type, n3, productDimension);
    }
}

