/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.dataio.avhrr.noaa.pod;

import com.bc.ceres.binio.util.RandomAccessFileIOHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrFile;
import org.esa.beam.dataio.avhrr.noaa.pod.PodAvhrrReader;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductReaderPlugIn;
import org.esa.beam.util.io.BeamFileFilter;

public final class PodAvhrrReaderPlugIn
implements ProductReaderPlugIn {
    private static final String DESCRIPTION = "NOAA Polar Orbiter Data products (AVHRR HRPT)";
    private static final String[] FILE_EXTENSIONS = new String[]{".l1b"};
    private static final String FORMAT_NAME = "NOAA_POD_AVHRR_HRPT";
    private static final String[] FORMAT_NAMES = new String[]{"NOAA_POD_AVHRR_HRPT"};
    private static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};

    @Override
    public DecodeQualification getDecodeQualification(Object input) {
        block13: {
            File file = PodAvhrrReaderPlugIn.getInputFile(input);
            if (file != null) {
                try {
                    Throwable throwable = null;
                    Object var4_5 = null;
                    try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
                        RandomAccessFileIOHandler ioHandler = new RandomAccessFileIOHandler(raf);
                        if (!PodAvhrrFile.canDecode(ioHandler)) break block13;
                        return DecodeQualification.INTENDED;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    return DecodeQualification.UNABLE;
                }
            }
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    @Override
    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    @Override
    public ProductReader createReaderInstance() {
        return new PodAvhrrReader(this);
    }

    @Override
    public BeamFileFilter getProductFileFilter() {
        return new BeamFileFilter(this.getFormatNames()[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }

    @Override
    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    @Override
    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    @Override
    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }
}

