/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataio;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import org.esa.beam.framework.dataio.AbstractProductReader;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.util.Guardian;

public abstract class AbstractProductBuilder
extends AbstractProductReader {
    protected Product sourceProduct;
    protected boolean sourceProductOwner;
    protected int sceneRasterWidth;
    protected int sceneRasterHeight;
    protected String newProductName;
    protected String newProductDesc;
    protected Map<Band, RasterDataNode> bandMap = new Hashtable<Band, RasterDataNode>(16);

    public AbstractProductBuilder(boolean sourceProductOwner) {
        super(null);
        this.sourceProductOwner = sourceProductOwner;
    }

    public Product getSourceProduct() {
        return this.sourceProduct;
    }

    public boolean isSourceProductOwner() {
        return this.sourceProductOwner;
    }

    public void setNewProductDesc(String newProductDesc) {
        this.newProductDesc = newProductDesc;
    }

    public void setNewProductName(String newProductName) {
        this.newProductName = newProductName;
    }

    public int getSceneRasterWidth() {
        return this.sceneRasterWidth;
    }

    public int getSceneRasterHeight() {
        return this.sceneRasterHeight;
    }

    protected Product readProductNodes(Product sourceProduct, ProductSubsetDef subsetDef, String name, String desc) throws IOException {
        Guardian.assertNotNull("sourceProduct", sourceProduct);
        this.setNewProductName(name != null ? name : sourceProduct.getName());
        this.setNewProductDesc(desc != null ? desc : sourceProduct.getDescription());
        Product product = this.readProductNodes(sourceProduct, subsetDef);
        product.setModified(true);
        return product;
    }

    @Override
    protected abstract Product readProductNodesImpl() throws IOException;

    @Override
    public void close() throws IOException {
        this.disposeBandMap();
        if (this.sourceProductOwner && this.sourceProduct != null) {
            this.sourceProduct.dispose();
        }
        this.sourceProduct = null;
        super.close();
    }

    protected void addFlagCodingsToProduct(Product product) {
        ProductNodeGroup<FlagCoding> flagCodingGroup = this.getSourceProduct().getFlagCodingGroup();
        int i = 0;
        while (i < flagCodingGroup.getNodeCount()) {
            FlagCoding sourceFlagCoding = flagCodingGroup.get(i);
            FlagCoding destFlagCoding = new FlagCoding(sourceFlagCoding.getName());
            destFlagCoding.setDescription(sourceFlagCoding.getDescription());
            this.cloneFlags(sourceFlagCoding, destFlagCoding);
            product.getFlagCodingGroup().add(destFlagCoding);
            ++i;
        }
    }

    protected void addIndexCodingsToProduct(Product product) {
        ProductNodeGroup<IndexCoding> indexCodingGroup = this.getSourceProduct().getIndexCodingGroup();
        int i = 0;
        while (i < indexCodingGroup.getNodeCount()) {
            IndexCoding sourceIndexCoding = indexCodingGroup.get(i);
            IndexCoding destIndexCoding = new IndexCoding(sourceIndexCoding.getName());
            destIndexCoding.setDescription(sourceIndexCoding.getDescription());
            this.cloneIndexes(sourceIndexCoding, destIndexCoding);
            product.getIndexCodingGroup().add(destIndexCoding);
            ++i;
        }
    }

    protected static void addAttribString(String name, String value, MetadataElement subsetElem) {
        ProductData data = ProductData.createInstance(value);
        subsetElem.addAttribute(new MetadataAttribute(name, data, true));
    }

    protected void cloneFlags(FlagCoding sourceFlagCoding, FlagCoding destFlagCoding) {
        this.cloneMetadataElementsAndAttributes(sourceFlagCoding, destFlagCoding, 1);
    }

    protected void cloneIndexes(IndexCoding sourceFlagCoding, IndexCoding destFlagCoding) {
        this.cloneMetadataElementsAndAttributes(sourceFlagCoding, destFlagCoding, 1);
    }

    protected void addMetadataToProduct(Product product) {
        this.cloneMetadataElementsAndAttributes(this.getSourceProduct().getMetadataRoot(), product.getMetadataRoot(), 0);
    }

    protected void cloneMetadataElementsAndAttributes(MetadataElement sourceRoot, MetadataElement destRoot, int level) {
        this.cloneMetadataElements(sourceRoot, destRoot, level);
        this.cloneMetadataAttributes(sourceRoot, destRoot);
    }

    protected void cloneMetadataElements(MetadataElement sourceRoot, MetadataElement destRoot, int level) {
        int i = 0;
        while (i < sourceRoot.getNumElements()) {
            MetadataElement sourceElement = sourceRoot.getElementAt(i);
            if (level > 0 || this.isNodeAccepted(sourceElement.getName())) {
                MetadataElement element = new MetadataElement(sourceElement.getName());
                element.setDescription(sourceElement.getDescription());
                destRoot.addElement(element);
                this.cloneMetadataElementsAndAttributes(sourceElement, element, level + 1);
            }
            ++i;
        }
    }

    protected void cloneMetadataAttributes(MetadataElement sourceRoot, MetadataElement destRoot) {
        int i = 0;
        while (i < sourceRoot.getNumAttributes()) {
            MetadataAttribute sourceAttribute = sourceRoot.getAttributeAt(i);
            destRoot.addAttribute(sourceAttribute.createDeepClone());
            ++i;
        }
    }

    @Override
    protected boolean isInstanceOfValidInputType(Object input) {
        return input instanceof Product;
    }

    protected void disposeBandMap() {
        this.bandMap.clear();
    }
}

