/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.awt.Image;
import java.awt.Point;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Placemark;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.esa.beam.framework.datamodel.PlacemarkGroup;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public abstract class AbstractPlacemarkDescriptor
implements PlacemarkDescriptor {
    public static final String PROPERTY_NAME_PLACEMARK_DESCRIPTOR = "placemarkDescriptor";
    public static final String PROPERTY_NAME_DEFAULT_GEOMETRY = "defaultGeometry";

    @Override
    public Placemark createPlacemark(SimpleFeature feature) {
        return new Placemark(this, feature);
    }

    @Override
    public DecodeQualification getCompatibilityFor(SimpleFeatureType featureType) {
        if (this.getBaseFeatureType().getTypeName().equals(featureType.getTypeName())) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    @Override
    public void setUserDataOf(SimpleFeatureType compatibleFeatureType) {
        compatibleFeatureType.getUserData().put(PROPERTY_NAME_PLACEMARK_DESCRIPTOR, this.getClass().getName());
        GeometryDescriptor geometryDescriptor = compatibleFeatureType.getGeometryDescriptor();
        if (geometryDescriptor != null) {
            compatibleFeatureType.getUserData().put(PROPERTY_NAME_DEFAULT_GEOMETRY, geometryDescriptor.getLocalName());
        }
    }

    @Override
    public PlacemarkGroup getPlacemarkGroup(Product product) {
        VectorDataNode[] nodes;
        VectorDataNode[] vectorDataNodeArray = nodes = (VectorDataNode[])product.getVectorDataGroup().toArray(new VectorDataNode[0]);
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            VectorDataNode node = vectorDataNodeArray[n2];
            if (node.getPlacemarkDescriptor() == this) {
                return node.getPlacemarkGroup();
            }
            ++n2;
        }
        return null;
    }

    @Override
    public PixelPos updatePixelPos(GeoCoding geoCoding, GeoPos geoPos, PixelPos pixelPos) {
        return pixelPos;
    }

    @Override
    public GeoPos updateGeoPos(GeoCoding geoCoding, PixelPos pixelPos, GeoPos geoPos) {
        return geoPos;
    }

    @Override
    public String getShowLayerCommandId() {
        return null;
    }

    @Override
    public Image getCursorImage() {
        return null;
    }

    @Override
    public Point getCursorHotSpot() {
        return new Point();
    }
}

