/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

public class Kernel
implements Cloneable {
    private int width;
    private int height;
    private int xOrigin;
    private int yOrigin;
    private double factor;
    private double[] data;

    public Kernel(int width, int height, double[] data) {
        this(width, height, 1.0, data);
    }

    public Kernel(int width, int height, double factor, double[] data) {
        this(width, height, (width - 1) / 2, (height - 1) / 2, factor, data);
    }

    public Kernel(int width, int height, int xOrigin, int yOrigin, double factor, double[] data) {
        this.width = width;
        this.height = height;
        this.xOrigin = xOrigin;
        this.yOrigin = yOrigin;
        int len = width * height;
        if (data.length < len) {
            throw new IllegalArgumentException("Data array too small (is " + data.length + " and should be " + len);
        }
        this.factor = factor;
        this.data = new double[len];
        System.arraycopy(data, 0, this.data, 0, len);
    }

    public final int getXOrigin() {
        return this.xOrigin;
    }

    public final int getYOrigin() {
        return this.yOrigin;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final double getFactor() {
        return this.factor;
    }

    public final double[] getKernelData(double[] data) {
        if (data == null) {
            data = new double[this.data.length];
        } else if (data.length < this.data.length) {
            throw new IllegalArgumentException("Data array too small (should be " + this.data.length + " but is " + data.length + " )");
        }
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        return data;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

