/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ServiceRegistry;
import com.bc.ceres.core.ServiceRegistryManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.esa.beam.BeamCoreActivator;
import org.esa.beam.framework.dataio.DecodeQualification;
import org.esa.beam.framework.datamodel.PlacemarkDescriptor;
import org.opengis.feature.simple.SimpleFeatureType;

public class PlacemarkDescriptorRegistry {
    public static final String PROPERTY_NAME_PLACEMARK_DESCRIPTOR = "placemarkDescriptor";
    private ServiceRegistry<PlacemarkDescriptor> serviceRegistry;

    public PlacemarkDescriptorRegistry(ServiceRegistry<PlacemarkDescriptor> serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private PlacemarkDescriptorRegistry() {
        ServiceRegistryManager serviceRegistryManager = ServiceRegistryManager.getInstance();
        this.serviceRegistry = serviceRegistryManager.getServiceRegistry(PlacemarkDescriptor.class);
        if (!BeamCoreActivator.isStarted()) {
            BeamCoreActivator.loadServices(this.serviceRegistry);
        }
    }

    public static PlacemarkDescriptorRegistry getInstance() {
        return Holder.instance;
    }

    public static void setInstance(PlacemarkDescriptorRegistry instance) {
        Assert.notNull(instance, "instance");
        Holder.instance = instance;
    }

    public PlacemarkDescriptor getPlacemarkDescriptor(Class<? extends PlacemarkDescriptor> clazz) {
        return this.getPlacemarkDescriptor(clazz.getName());
    }

    public PlacemarkDescriptor getPlacemarkDescriptor(String className) {
        return this.serviceRegistry.getService(className);
    }

    public Set<PlacemarkDescriptor> getPlacemarkDescriptors() {
        return this.serviceRegistry.getServices();
    }

    public List<PlacemarkDescriptor> getPlacemarkDescriptors(final SimpleFeatureType featureType) {
        ArrayList<PlacemarkDescriptor> list = new ArrayList<PlacemarkDescriptor>();
        for (PlacemarkDescriptor placemarkDescriptor : this.getPlacemarkDescriptors()) {
            DecodeQualification qualification = placemarkDescriptor.getCompatibilityFor(featureType);
            if (qualification == DecodeQualification.UNABLE) continue;
            if (qualification == DecodeQualification.INTENDED) {
                list.add(placemarkDescriptor);
                continue;
            }
            list.add(placemarkDescriptor);
        }
        Collections.sort(list, new Comparator<PlacemarkDescriptor>(){

            @Override
            public int compare(PlacemarkDescriptor o1, PlacemarkDescriptor o2) {
                boolean isO2Intended;
                boolean isO1Intended = o1.getCompatibilityFor(featureType) == DecodeQualification.INTENDED;
                boolean bl = isO2Intended = o2.getCompatibilityFor(featureType) == DecodeQualification.INTENDED;
                if (isO1Intended && !isO2Intended) {
                    return -1;
                }
                if (!isO1Intended && isO2Intended) {
                    return 1;
                }
                if (isO1Intended && isO2Intended) {
                    if (PlacemarkDescriptorRegistry.hasClassProperty(o1) && !PlacemarkDescriptorRegistry.hasClassProperty(o2)) {
                        return -1;
                    }
                    if (!PlacemarkDescriptorRegistry.hasClassProperty(o1) && PlacemarkDescriptorRegistry.hasClassProperty(o2)) {
                        return 1;
                    }
                }
                return 0;
            }
        });
        return list;
    }

    public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType featureType) {
        PlacemarkDescriptor suitablePlacemarkDescriptor = null;
        PlacemarkDescriptor intendedPlacemarkDescriptor = null;
        for (PlacemarkDescriptor placemarkDescriptor : this.getPlacemarkDescriptors()) {
            DecodeQualification qualification = placemarkDescriptor.getCompatibilityFor(featureType);
            if (qualification == DecodeQualification.INTENDED) {
                if (PlacemarkDescriptorRegistry.hasClassProperty(placemarkDescriptor)) {
                    return placemarkDescriptor;
                }
                intendedPlacemarkDescriptor = placemarkDescriptor;
                continue;
            }
            if (qualification != DecodeQualification.SUITABLE) continue;
            suitablePlacemarkDescriptor = placemarkDescriptor;
        }
        if (intendedPlacemarkDescriptor != null) {
            return intendedPlacemarkDescriptor;
        }
        return suitablePlacemarkDescriptor;
    }

    private static boolean hasClassProperty(PlacemarkDescriptor placemarkDescriptor) {
        return placemarkDescriptor.getBaseFeatureType().getUserData().containsKey(PROPERTY_NAME_PLACEMARK_DESCRIPTOR);
    }

    /* synthetic */ PlacemarkDescriptorRegistry(PlacemarkDescriptorRegistry placemarkDescriptorRegistry) {
        this();
    }

    private static class Holder {
        private static PlacemarkDescriptorRegistry instance = new PlacemarkDescriptorRegistry(null);

        private Holder() {
        }
    }
}

