/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.util.EventObject;
import java.util.Vector;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BitmaskDef;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductNodeList;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.ProductVisitorAdapter;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;

public class ProductManager {
    private static final int PRODUCT_ADDED = 1;
    private static final int PRODUCT_REMOVED = 2;
    private Vector<Listener> listeners;
    private final ProductNodeList<Product> productList = new ProductNodeList();
    private ProductNodeNameChangeListener productNodeNameChangeListener = new ProductNodeNameChangeListener();

    public int getProductCount() {
        return this.productList.size();
    }

    public Product getProduct(int index) {
        return this.productList.getAt(index);
    }

    public String[] getProductDisplayNames() {
        return this.productList.getDisplayNames();
    }

    public String[] getProductNames() {
        return this.productList.getNames();
    }

    public Product[] getProducts() {
        return (Product[])this.productList.toArray(new Product[this.getProductCount()]);
    }

    public Product getProductByDisplayName(String displayName) {
        if (displayName == null) {
            return null;
        }
        return this.productList.getByDisplayName(displayName);
    }

    public Product getProductByRefNo(int refNo) {
        Product[] productArray = this.getProducts();
        int n = productArray.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            if (refNo == product.getRefNo()) {
                return product;
            }
            ++n2;
        }
        return null;
    }

    public Product getProduct(String name) {
        return this.productList.get(name);
    }

    public int getProductIndex(Product product) {
        return this.productList.indexOf(product);
    }

    public boolean containsProduct(String name) {
        return this.productList.contains(name);
    }

    public boolean contains(Product product) {
        return this.productList.contains(product);
    }

    public void addProduct(Product product) {
        if (product != null) {
            if (this.contains(product)) {
                return;
            }
            if (this.productList.add(product)) {
                this.setProductManager(product);
                if (product.getRefNo() <= 0) {
                    product.setRefNo(this.getNextRefNo() + 1);
                }
                product.addProductNodeListener(this.productNodeNameChangeListener);
                this.fireEvent(product, 1);
            }
        }
    }

    private void updateExpressionToRenamedNode(ProductNode renamedNode, String oldName) {
        Product[] products = this.getProducts();
        String oldExternName = BandArithmetic.createExternalName(oldName);
        String newExternName = BandArithmetic.createExternalName(renamedNode.getName());
        Product[] productArray = products;
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            if (product != renamedNode.getProduct()) {
                product.acceptVisitor(new ExpressionUpdaterVisitor(oldExternName, newExternName));
            }
            ++n2;
        }
    }

    public boolean removeProduct(Product product) {
        int index;
        if (product != null && (index = this.productList.indexOf(product)) >= 0 && this.productList.remove(product)) {
            this.productList.clearRemovedList();
            product.removeProductNodeListener(this.productNodeNameChangeListener);
            product.resetRefNo();
            this.clearProductManager(product);
            this.fireEvent(product, 2);
            return true;
        }
        return false;
    }

    public void removeAllProducts() {
        Product[] products;
        Product[] productArray = products = this.getProducts();
        int n = products.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            this.removeProduct(product);
            ++n2;
        }
    }

    private void setProductManager(Product product) {
        if (product.getProductManager() != this) {
            product.setProductManager(this);
        }
    }

    private void clearProductManager(Product product) {
        if (product.getProductManager() == this) {
            product.setProductManager(null);
        }
    }

    private int getNextRefNo() {
        int numProducts = this.getProductCount();
        int highestRefNo = 0;
        int i = 0;
        while (i < numProducts) {
            int refNo = this.getProduct(i).getRefNo();
            if (refNo > highestRefNo) {
                highestRefNo = refNo;
            }
            ++i;
        }
        return highestRefNo;
    }

    public synchronized boolean addListener(Listener listener) {
        if (listener == null) {
            return false;
        }
        if (this.listeners == null) {
            this.listeners = new Vector(8);
        }
        for (Listener l : this.listeners) {
            if (listener != l) continue;
            return false;
        }
        this.listeners.add(listener);
        return true;
    }

    public synchronized boolean removeListener(Listener listener) {
        if (listener != null && this.listeners != null) {
            int i = 0;
            while (i < this.listeners.size()) {
                Listener l = this.listeners.get(i);
                if (listener == l) {
                    this.listeners.remove(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    private void fireEvent(Product sourceProduct, int eventId) {
        if (this.hasListeners()) {
            Event event = new Event(sourceProduct);
            for (Listener listener : this.listeners) {
                ProductManager.fireEvent(eventId, listener, event);
            }
        }
    }

    private static void fireEvent(int eventId, Listener listener, Event event) {
        switch (eventId) {
            case 1: {
                listener.productAdded(event);
                break;
            }
            case 2: {
                listener.productRemoved(event);
            }
        }
    }

    public static class Event
    extends EventObject {
        public Event(Product product) {
            super(product);
        }

        public Product getProduct() {
            return (Product)this.getSource();
        }
    }

    private static class ExpressionUpdaterVisitor
    extends ProductVisitorAdapter {
        private final String oldExternName;
        private final String newExternName;

        public ExpressionUpdaterVisitor(String oldExternName, String newExternName) {
            this.oldExternName = oldExternName;
            this.newExternName = newExternName;
        }

        @Override
        public void visit(TiePointGrid grid) {
            grid.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(Band band) {
            band.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(VirtualBand virtualBand) {
            virtualBand.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(BitmaskDef bitmaskDef) {
            bitmaskDef.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(Mask mask) {
            mask.updateExpression(this.oldExternName, this.newExternName);
        }

        @Override
        public void visit(ProductNodeGroup group) {
            group.updateExpression(this.oldExternName, this.newExternName);
        }
    }

    public static interface Listener {
        public void productAdded(Event var1);

        public void productRemoved(Event var1);
    }

    private class ProductNodeNameChangeListener
    extends ProductNodeListenerAdapter {
        private ProductNodeNameChangeListener() {
        }

        @Override
        public void nodeChanged(ProductNodeEvent event) {
            if ("name".equals(event.getPropertyName())) {
                ProductManager.this.updateExpressionToRenamedNode(event.getSourceNode(), (String)event.getOldValue());
            }
        }
    }
}

