/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.esa.beam.framework.datamodel.ProgressListener;

public class ProgressListenerList
implements ProgressListener {
    private List _listeners;

    @Override
    public boolean processStarted(String processDescription, int minProgressValue, int maxProgressValue) {
        return this.fireProcessStarted(processDescription, minProgressValue, maxProgressValue);
    }

    @Override
    public boolean processInProgress(int currentProgressValue) {
        return this.fireProcessInProgress(currentProgressValue);
    }

    @Override
    public void processEnded(boolean success) {
        this.fireProcessEnded(success);
    }

    public void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList();
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        if (listener == null || this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    public void removeAllProgressListeners() {
        this._listeners.clear();
    }

    public boolean fireProcessStarted(String processName, int minProgressValue, int maxProgressValue) {
        if (this._listeners != null) {
            int i = 0;
            while (i < this._listeners.size()) {
                if (!((ProgressListener)this._listeners.get(i)).processStarted(processName, minProgressValue, maxProgressValue)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean fireProcessInProgress(int currentProgressValue) {
        if (this._listeners != null) {
            int i = 0;
            while (i < this._listeners.size()) {
                if (!((ProgressListener)this._listeners.get(i)).processInProgress(currentProgressValue)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void fireProcessEnded(boolean success) {
        if (this._listeners != null) {
            int i = 0;
            while (i < this._listeners.size()) {
                ((ProgressListener)this._listeners.get(i)).processEnded(success);
                ++i;
            }
        }
    }

    public boolean isEmpty() {
        return this._listeners.size() > 0;
    }
}

