/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.datamodel;

import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.jexp.ParseException;
import java.awt.image.RenderedImage;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.VirtualBandOpImage;

class VirtualBandMultiLevelImage
extends DefaultMultiLevelImage
implements ProductNodeListener {
    private final Map<Product, Set<ProductNode>> nodeMap = new WeakHashMap<Product, Set<ProductNode>>();

    static MultiLevelImage create(final String expression, final RasterDataNode associatedNode) {
        MultiLevelModel multiLevelModel = ImageManager.getMultiLevelModel(associatedNode);
        AbstractMultiLevelSource multiLevelSource = new AbstractMultiLevelSource(multiLevelModel){

            @Override
            public RenderedImage createImage(int level) {
                return VirtualBandOpImage.create(expression, associatedNode.getDataType(), associatedNode.isNoDataValueUsed() ? Double.valueOf(associatedNode.getGeophysicalNoDataValue()) : null, associatedNode.getProduct(), ResolutionLevel.create(this.getModel(), level));
            }
        };
        return new VirtualBandMultiLevelImage(multiLevelSource, expression, associatedNode.getProduct()){

            @Override
            public void reset() {
                super.reset();
                associatedNode.fireProductNodeDataChanged();
            }
        };
    }

    VirtualBandMultiLevelImage(MultiLevelSource multiLevelSource, String expression, Product product) {
        super(multiLevelSource);
        try {
            ProductManager productManager = product.getProductManager();
            RasterDataNode[] nodes = productManager != null ? BandArithmetic.getRefRasters(expression, productManager.getProducts(), productManager.getProductIndex(product)) : BandArithmetic.getRefRasters(expression, product);
            if (nodes.length > 0) {
                RasterDataNode[] rasterDataNodeArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    RasterDataNode node = rasterDataNodeArray[n2];
                    if (!this.nodeMap.containsKey(node.getProduct())) {
                        this.nodeMap.put(node.getProduct(), new WeakHashSet());
                    }
                    this.nodeMap.get(node.getProduct()).add(node);
                    ++n2;
                }
                for (Product key : this.nodeMap.keySet()) {
                    key.addProductNodeListener(this);
                }
            }
        }
        catch (ParseException parseException) {}
    }

    @Override
    public void dispose() {
        for (Product key : this.nodeMap.keySet()) {
            key.removeProductNodeListener(this);
        }
        this.nodeMap.clear();
        super.dispose();
    }

    @Override
    public void nodeChanged(ProductNodeEvent event) {
    }

    @Override
    public void nodeDataChanged(ProductNodeEvent event) {
        Product product = event.getSourceNode().getProduct();
        if (this.nodeMap.containsKey(product) && this.nodeMap.get(product).contains(event.getSourceNode())) {
            this.reset();
        }
    }

    @Override
    public void nodeAdded(ProductNodeEvent event) {
    }

    @Override
    public void nodeRemoved(ProductNodeEvent event) {
    }

    Map<Product, Set<ProductNode>> getNodeMap() {
        return this.nodeMap;
    }

    private static class WeakHashSet<E>
    extends AbstractSet<E> {
        private static final Object PRESENT = new Object();
        private final WeakHashMap<E, Object> map = new WeakHashMap();

        private WeakHashSet() {
        }

        @Override
        public Iterator<E> iterator() {
            return this.map.keySet().iterator();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean add(E e) {
            return this.map.put(e, PRESENT) == null;
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) == PRESENT;
        }

        @Override
        public void clear() {
            this.map.clear();
        }
    }
}

