/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.framework.dataop.maptransf.MapTransformUI;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

@Deprecated
public class DefaultMapTransformUI
implements MapTransformUI {
    private MapTransform _transform;
    private Parameter[] _parameters;
    private Component _uiComponent;

    public DefaultMapTransformUI(MapTransform transform) {
        Guardian.assertNotNull("transform", transform);
        Debug.trace("DefaultMapTransformUI.init");
        this._transform = transform;
        this._parameters = DefaultMapTransformUI.cloneParameterArray(transform.getDescriptor().getParameters());
        this.setParameterValues(transform.getParameterValues());
        this.traceParameterValues();
    }

    @Override
    public MapTransform createTransform() {
        Debug.trace("DefaultMapTransformUI.createTransform");
        this.traceParameterValues();
        MapTransform transform = this._transform.getDescriptor().createTransform(this.getParameterValues());
        double[] parameterValues = transform.getParameterValues();
        int i = 0;
        while (i < parameterValues.length) {
            Debug.trace("  MapTransform.parameterValues[" + i + "] = " + parameterValues[i]);
            ++i;
        }
        return transform;
    }

    @Override
    public boolean verifyUserInput() {
        Debug.trace("DefaultMapTransformUI.verifyUserInput");
        return true;
    }

    @Override
    public void resetToDefaults() {
        Debug.trace("DefaultMapTransformUI.resetToDefaults");
        this.setParameterValues(this._transform.getDescriptor().getParameterDefaultValues());
    }

    @Override
    public Component getUIComponent() {
        if (this._uiComponent == null) {
            this._uiComponent = this.createUIComponent();
        }
        return this._uiComponent;
    }

    private Component createUIComponent() {
        return DefaultMapTransformUI.createUIComponent(this._parameters);
    }

    private double[] getParameterValues() {
        return DefaultMapTransformUI.getParameterValues(this._parameters);
    }

    private void setParameterValues(double[] parameterValues) {
        int i = 0;
        while (i < this._parameters.length) {
            Parameter parameter = this._parameters[i];
            parameter.setValue(parameterValues[i], null);
            ++i;
        }
    }

    private void traceParameterValues() {
        Debug.trace("DefaultMapTransformUI.traceParameterValues:");
        int i = 0;
        while (i < this._parameters.length) {
            Debug.trace("  DefaultMapTransformUI.parameters[" + i + "] = " + this._parameters[i].getValue());
            ++i;
        }
    }

    private static Component createUIComponent(Parameter[] parameters) {
        JPanel dialogPane = new JPanel(new GridBagLayout());
        dialogPane.setBorder(new EmptyBorder(2, 2, 2, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 3, 0, 3);
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            gbc.gridy = i + 1;
            gbc.gridwidth = 1;
            gbc.insets.top = 0;
            dialogPane.add((Component)parameter.getEditor().getLabelComponent(), gbc);
            dialogPane.add((Component)parameter.getEditor().getComponent(), gbc);
            dialogPane.add((Component)parameter.getEditor().getPhysUnitLabelComponent(), gbc);
            ++i;
        }
        return dialogPane;
    }

    private static double[] getParameterValues(Parameter[] parameters) {
        Guardian.assertNotNull("parameters", parameters);
        double[] parameterValues = new double[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            if (!(parameter.getValue() instanceof Number)) {
                throw new IllegalArgumentException("parameter value is not a number: " + i);
            }
            parameterValues[i] = ((Number)parameter.getValue()).doubleValue();
            ++i;
        }
        return parameterValues;
    }

    private static Parameter[] cloneParameterArray(Parameter[] parameters) {
        Guardian.assertNotNull("parameters", parameters);
        Parameter[] clones = new Parameter[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            Parameter parameter = parameters[i];
            clones[i] = new Parameter(parameter.getName(), parameter.getValue(), parameter.getProperties());
            ++i;
        }
        return clones;
    }
}

