/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

@Deprecated
public class ISEAG {
    private final int totBins;
    private final int numRows;
    private final int[] numBin;
    private final int[] baseBin;
    private final double[] latBin;
    private final double seamLon;
    private int old_row_a = 0;
    private int old_row_b = 0;

    public ISEAG(int nrows) {
        this.seamLon = -180.0;
        this.numRows = nrows;
        this.numBin = new int[this.numRows];
        this.baseBin = new int[this.numRows];
        this.latBin = new double[this.numRows];
        double radfac = Math.PI / 180;
        int i = 0;
        while (i < this.numRows) {
            this.latBin[i] = ((double)i + 0.5) * (180.0 / (double)this.numRows) - 90.0;
            this.numBin[i] = (int)(Math.cos(this.latBin[i] * radfac) * (2.0 * (double)this.numRows) + 0.5);
            ++i;
        }
        this.baseBin[0] = 1;
        i = 1;
        while (i < this.numRows) {
            this.baseBin[i] = this.baseBin[i - 1] + this.numBin[i - 1];
            ++i;
        }
        this.totBins = this.baseBin[this.numRows - 1] + this.numBin[this.numRows - 1] - 1;
    }

    public int getBinCount() {
        return this.totBins;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public int getColumnCount(int row) {
        return this.numBin[row - 1];
    }

    public void bin2ll(int bin, LL ll) {
        int row;
        if (this.old_row_a > 0 && this.baseBin[this.old_row_a - 1] <= bin && this.baseBin[this.old_row_a] > bin) {
            row = this.old_row_a;
        } else {
            if (bin < 1) {
                bin = 1;
            }
            if (bin > this.totBins) {
                bin = this.totBins;
            }
            int rlow = 1;
            int rhi = this.numRows;
            do {
                int rmid;
                if (this.baseBin[rmid = (rlow + rhi - 1) / 2] > bin) {
                    rhi = rmid;
                    continue;
                }
                rlow = rmid + 1;
            } while (rlow != rhi);
            this.old_row_a = row = rlow;
        }
        ll.lat = this.latBin[row - 1];
        ll.lon = 360.0 * ((double)(bin - this.baseBin[row - 1]) + 0.5) / (double)this.numBin[row - 1];
        ll.lon += this.seamLon;
    }

    public int ll2bin(LL ll) {
        return this.ll2bin(ll.lat, ll.lon);
    }

    public int ll2bin(double lat, double lon) {
        int row = (int)((90.0 + lat) * (double)this.numRows / 180.0);
        int col = (int)((double)this.numBin[row] * (lon - this.seamLon) / 360.0);
        return this.baseBin[row] + col;
    }

    public void ll2rc(LL ll, RC rc) {
        this.ll2rc(ll.lat, ll.lon, rc);
    }

    public void ll2rc(double lat, double lon, RC rc) {
        int row = (int)((90.0 + lat) * (double)this.numRows / 180.0);
        if (row < 0) {
            row = 0;
        }
        if (row >= this.numRows) {
            row = this.numRows - 1;
        }
        int col = (int)((double)this.numBin[row] * (lon - this.seamLon) / 360.0);
        rc.row = row + 1;
        rc.col = col + 1;
    }

    public void rc2ll(RC rc, LL ll) {
        this.rc2ll(rc.row, rc.col, ll);
    }

    public void rc2ll(int row, int col, LL ll) {
        if (--row < 0) {
            row = 0;
        }
        if (row >= this.numRows) {
            row = this.numRows - 1;
        }
        ll.lat = this.latBin[row];
        ll.lon = this.seamLon + 360.0 * ((double)col - 0.5) / (double)this.numBin[row];
    }

    public int rc2bin(RC rc) {
        return this.rc2bin(rc.row, rc.col);
    }

    public int rc2bin(int row, int col) {
        return this.baseBin[row - 1] + col - 1;
    }

    public void bin2rc(int bin, RC rc) {
        if (this.old_row_b > 0 && this.baseBin[this.old_row_b - 1] <= bin && this.baseBin[this.old_row_b] > bin) {
            rc.row = this.old_row_b;
        } else {
            if (bin < 1) {
                bin = 1;
            }
            if (bin > this.totBins) {
                bin = this.totBins;
            }
            int rlow = 1;
            int rhi = this.numRows;
            do {
                int rmid;
                if (this.baseBin[rmid = (rlow + rhi - 1) / 2] > bin) {
                    rhi = rmid;
                    continue;
                }
                rlow = rmid + 1;
            } while (rlow != rhi);
            this.old_row_b = rc.row = rlow;
        }
        rc.col = bin - this.baseBin[rc.row - 1] + 1;
    }

    void old_bin2ll(int bin, LL ll) {
        int row = this.numRows - 1;
        while (bin < this.baseBin[row]) {
            --row;
        }
        ll.lat = this.latBin[row];
        ll.lon = 360.0 * ((double)(bin - this.baseBin[row]) + 0.5) / (double)this.numBin[row];
    }

    public static final class LL {
        public double lat;
        public double lon;

        public LL() {
        }

        public LL(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }
    }

    public static final class RC {
        public int row;
        public int col;

        public RC() {
        }

        public RC(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }
}

