/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.dataop.maptransf;

import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.dataop.maptransf.Ellipsoid;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapProjectionRegistry;
import org.esa.beam.framework.dataop.maptransf.UTMProjection;

@Deprecated
public class UTM {
    public static final String AUTO_PROJECTION_NAME = "UTM Automatic";
    public static final int MIN_UTM_ZONE_INDEX = 0;
    public static final int MAX_UTM_ZONE_INDEX = 59;
    public static final int MAX_UTM_ZONE = 60;
    private static boolean _projectionsRegistered;

    public static boolean isAutoZoneProjection(MapProjection mapProjection) {
        return AUTO_PROJECTION_NAME.equals(mapProjection.getName());
    }

    public static UTMProjection createAutoZoneProjection() {
        return UTM.createProjection(AUTO_PROJECTION_NAME, 0, false);
    }

    public static UTMProjection createProjection(int zoneIndex, boolean south) {
        return UTM.createProjection(UTM.getProjectionName(zoneIndex, south), zoneIndex, south);
    }

    public static UTMProjection createProjection(String projName, int zoneIndex, boolean south) {
        return UTMProjection.create(projName, zoneIndex, south);
    }

    public static String getProjectionName(int zoneIndex, boolean south) {
        return "UTM Zone " + (zoneIndex + 1) + (south ? ", South" : "");
    }

    public static double[] getProjectionParams(int zoneIndex, boolean south) {
        return new double[]{Ellipsoid.WGS_84.getSemiMajor(), Ellipsoid.WGS_84.getSemiMinor(), 0.0, UTM.getCentralMeridian(zoneIndex), 0.9996, 500000.0, south ? 1.0E7 : 0.0};
    }

    public static MapProjection getSuitableProjection(GeoPos geoPos) {
        int zoneIndex = UTM.getZoneIndex(geoPos.getLon());
        boolean south = (double)geoPos.getLat() < 0.0;
        String projName = UTM.getProjectionName(zoneIndex, south);
        MapProjection projection = MapProjectionRegistry.getProjection(projName);
        return projection;
    }

    public static double getCentralMeridian(int zoneIndex) {
        if (zoneIndex < 0) {
            zoneIndex = 0;
        }
        if (zoneIndex > 59) {
            zoneIndex = 59;
        }
        return ((double)zoneIndex + 0.5) * 6.0 - 180.0;
    }

    public static int getZoneIndex(float longitude) {
        int zoneIndex = Math.round((longitude + 180.0f) / 6.0f - 0.5f);
        if (zoneIndex < 0) {
            zoneIndex = 0;
        }
        if (zoneIndex > 59) {
            zoneIndex = 59;
        }
        return zoneIndex;
    }

    public static void registerProjections() {
        if (!_projectionsRegistered) {
            MapProjectionRegistry.registerProjection(UTM.createAutoZoneProjection());
            UTM.registerProjections(false);
            UTM.registerProjections(true);
        }
        _projectionsRegistered = true;
    }

    private UTM() {
    }

    private static void registerProjections(boolean south) {
        int zoneIndex = 0;
        while (zoneIndex < 60) {
            UTMProjection mapProjection = UTM.createProjection(zoneIndex, south);
            MapProjectionRegistry.registerProjection(mapProjection);
            ++zoneIndex;
        }
    }
}

