/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param;

import java.awt.Color;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.esa.beam.framework.param.ParamEditor;
import org.esa.beam.framework.param.ParamProperties;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.framework.param.editors.BooleanEditor;
import org.esa.beam.framework.param.editors.ColorEditor;
import org.esa.beam.framework.param.editors.ComboBoxEditor;
import org.esa.beam.framework.param.editors.FileEditor;
import org.esa.beam.framework.param.editors.ListEditor;
import org.esa.beam.framework.param.editors.TextFieldEditor;
import org.esa.beam.util.Debug;
import org.esa.beam.util.Guardian;

public final class ParamEditorFactory {
    public static ParamEditor createParamEditor(Parameter parameter) {
        Guardian.assertNotNull("parameter", parameter);
        ParamProperties paramProps = parameter.getProperties();
        Debug.assertNotNull(paramProps);
        ParamEditor editor = null;
        Class editorClass = paramProps.getEditorClass();
        if (editorClass != null) {
            Constructor editorConstructor = null;
            try {
                editorConstructor = editorClass.getConstructor(Parameter.class);
            }
            catch (NoSuchMethodException e) {
                Debug.trace(e);
            }
            catch (SecurityException e) {
                Debug.trace(e);
            }
            if (editorConstructor != null) {
                try {
                    editor = (ParamEditor)editorConstructor.newInstance(parameter);
                }
                catch (InstantiationException e) {
                    Debug.trace(e);
                }
                catch (IllegalAccessException e) {
                    Debug.trace(e);
                }
                catch (IllegalArgumentException e) {
                    Debug.trace(e);
                }
                catch (InvocationTargetException e) {
                    Debug.trace(e);
                }
            }
        }
        if (editor != null) {
            return editor;
        }
        if (parameter.isTypeOf(Boolean.class)) {
            editor = new BooleanEditor(parameter);
        } else if (parameter.isTypeOf(Color.class)) {
            editor = new ColorEditor(parameter);
        } else if (parameter.isTypeOf(File.class)) {
            editor = new FileEditor(parameter);
        } else if (paramProps.getValueSet() != null && paramProps.getValueSet().length > 0) {
            editor = parameter.isTypeOf(String[].class) ? new ListEditor(parameter) : new ComboBoxEditor(parameter);
        }
        if (editor == null) {
            editor = new TextFieldEditor(parameter);
        }
        return editor;
    }
}

