/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.param.validators;

import org.esa.beam.framework.param.AbstractParamValidator;
import org.esa.beam.framework.param.ParamFormatException;
import org.esa.beam.framework.param.ParamParseException;
import org.esa.beam.framework.param.ParamValidateException;
import org.esa.beam.framework.param.Parameter;
import org.esa.beam.util.Debug;

public class NumberValidator
extends AbstractParamValidator {
    @Override
    public Object parse(Parameter parameter, String text) throws ParamParseException {
        Number number;
        block9: {
            Debug.assertTrue(text != null);
            String trimmedText = text.trim();
            if (NumberValidator.isAllowedNullText(parameter, trimmedText)) {
                return null;
            }
            number = null;
            try {
                if (parameter.getValueType() == Double.class) {
                    number = Double.valueOf(trimmedText);
                    break block9;
                }
                if (parameter.getValueType() == Float.class) {
                    number = Float.valueOf(trimmedText);
                    break block9;
                }
                if (parameter.getValueType() == Long.class) {
                    number = Long.valueOf(trimmedText);
                    break block9;
                }
                if (parameter.getValueType() == Integer.class) {
                    number = Integer.valueOf(trimmedText);
                    break block9;
                }
                if (parameter.getValueType() == Short.class) {
                    number = Short.valueOf(trimmedText);
                    break block9;
                }
                if (parameter.getValueType() == Byte.class) {
                    number = Byte.valueOf(trimmedText);
                    break block9;
                }
                throw new ParamParseException(parameter, "Unsupported number format.");
            }
            catch (NumberFormatException numberFormatException) {
                Object[] msgArgs = new Object[]{parameter.getValueType().getSimpleName().toLowerCase()};
                String message = String.format("Value must be a %s number.", msgArgs);
                throw new ParamParseException(parameter, message);
            }
        }
        return number;
    }

    @Override
    public String format(Parameter parameter, Object value) throws ParamFormatException {
        if (NumberValidator.isAllowedNullValue(parameter, value)) {
            return "";
        }
        Number n = NumberValidator.castToNumber(value);
        if (n == null) {
            throw new ParamFormatException(parameter, "Value of type 'Number' expected.");
        }
        return n.toString();
    }

    @Override
    public void validate(Parameter parameter, Object value) throws ParamValidateException {
        Number max;
        this.validateThatNullValueIsAllowed(parameter, value);
        Number n = NumberValidator.castToNumber(value);
        if (n == null) {
            throw new ParamValidateException(parameter, "Value must be a %s number.");
        }
        Number min = parameter.getProperties().getMinValue();
        if (min != null && n.doubleValue() < min.doubleValue()) {
            this.handleOutOfRangeError(parameter);
        }
        if ((max = parameter.getProperties().getMaxValue()) != null && n.doubleValue() > max.doubleValue()) {
            this.handleOutOfRangeError(parameter);
        }
        this.validateThatValueIsInValueSet(parameter, value);
    }

    @Override
    public boolean equalValues(Parameter parameter, Object value1, Object value2) {
        Number n2;
        Number n1 = NumberValidator.castToNumber(value1);
        if (n1 == (n2 = NumberValidator.castToNumber(value2))) {
            return true;
        }
        if (n1 == null && n2 != null) {
            return false;
        }
        if (n1 != null && n2 == null) {
            return false;
        }
        return n1.equals(n2);
    }

    protected void handleOutOfRangeError(Parameter parameter) throws ParamValidateException {
        Number min = parameter.getProperties().getMinValue();
        Number max = parameter.getProperties().getMaxValue();
        if (min != null && max != null) {
            throw new ParamValidateException(parameter, "Value must be in the range " + min + " to " + max + ".");
        }
        if (min != null) {
            throw new ParamValidateException(parameter, "Value must greater or equal " + min + ".");
        }
        if (max != null) {
            throw new ParamValidateException(parameter, "Value must less or equal " + max + ".");
        }
    }

    protected static Number castToNumber(Object value) {
        return value instanceof Number ? (Number)((Number)value) : (Number)null;
    }
}

