/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glayer;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.glevel.BandImageMultiLevelSource;

@LayerTypeMetadata(name="RasterImageLayerType", aliasNames={"org.esa.beam.glayer.RasterImageLayerType"})
public class RasterImageLayerType
extends ImageLayer.Type {
    public static final String PROPERTY_NAME_RASTER = "raster";

    @Override
    public ImageLayer createLayer(LayerContext ctx, PropertySet configuration) {
        MultiLevelSource multiLevelSource = (MultiLevelSource)configuration.getValue("multiLevelSource");
        if (multiLevelSource == null) {
            RasterDataNode raster = (RasterDataNode)configuration.getValue(PROPERTY_NAME_RASTER);
            multiLevelSource = BandImageMultiLevelSource.create(raster, ProgressMonitor.NULL);
            configuration.setValue("multiLevelSource", multiLevelSource);
        }
        return new ImageLayer(this, multiLevelSource, configuration);
    }

    @Override
    public PropertySet createLayerConfig(LayerContext ctx) {
        PropertySet template = super.createLayerConfig(ctx);
        template.addProperty(Property.create(PROPERTY_NAME_RASTER, RasterDataNode.class));
        template.getDescriptor(PROPERTY_NAME_RASTER).setItemAlias(PROPERTY_NAME_RASTER);
        template.getDescriptor(PROPERTY_NAME_RASTER).setNotNull(true);
        return template;
    }

    public Layer createLayer(RasterDataNode raster, MultiLevelSource multiLevelSource) {
        PropertySet configuration = this.createLayerConfig(null);
        configuration.setValue(PROPERTY_NAME_RASTER, raster);
        if (multiLevelSource == null) {
            multiLevelSource = BandImageMultiLevelSource.create(raster, ProgressMonitor.NULL);
        }
        configuration.setValue("multiLevelSource", multiLevelSource);
        return this.createLayer(null, configuration);
    }
}

