/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.glevel;

import com.bc.ceres.core.Assert;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.esa.beam.jai.TiledFileOpImage;
import org.esa.beam.util.StringUtils;

public class TiledFileMultiLevelSource
extends AbstractMultiLevelSource {
    private final File imageDir;
    private final Properties imageProperties;

    public static TiledFileMultiLevelSource create(File imageDir) throws IOException {
        Assert.notNull(imageDir);
        Properties imageProperties = new Properties();
        imageProperties.load(new FileReader(new File(imageDir, "image.properties")));
        int levelCount = Integer.parseInt(imageProperties.getProperty("numLevels"));
        int sourceWidth = Integer.parseInt(imageProperties.getProperty("width"));
        int sourceHeight = Integer.parseInt(imageProperties.getProperty("height"));
        String s = imageProperties.getProperty("i2mTransform");
        AffineTransform i2mTransform = new AffineTransform();
        if (s != null) {
            try {
                double[] matrix = StringUtils.toDoubleArray(s, ",");
                if (matrix.length == 6) {
                    i2mTransform = new AffineTransform(matrix);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(levelCount, i2mTransform, sourceWidth, sourceHeight);
        return new TiledFileMultiLevelSource(model, imageDir, imageProperties);
    }

    public TiledFileMultiLevelSource(MultiLevelModel model, File imageDir, Properties imageProperties) {
        super(model);
        this.imageDir = imageDir;
        this.imageProperties = imageProperties;
    }

    @Override
    public RenderedImage createImage(int level) {
        TiledFileOpImage image;
        try {
            image = TiledFileOpImage.create(new File(this.imageDir, String.valueOf(level)), this.imageProperties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return image;
    }
}

