/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glevel.MultiLevelImage;
import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.ClampDescriptor;
import javax.media.jai.operator.CompositeDescriptor;
import javax.media.jai.operator.ConstantDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.LookupDescriptor;
import javax.media.jai.operator.MatchCDFDescriptor;
import javax.media.jai.operator.MaxDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.RescaleDescriptor;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.datamodel.ProductNodeListenerAdapter;
import org.esa.beam.framework.datamodel.RGBChannelDef;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.Scene;
import org.esa.beam.framework.datamodel.SceneFactory;
import org.esa.beam.framework.datamodel.Stx;
import org.esa.beam.jai.FillConstantOpImage;
import org.esa.beam.jai.ReplaceValueOpImage;
import org.esa.beam.jai.ResolutionLevel;
import org.esa.beam.jai.VirtualBandOpImage;
import org.esa.beam.util.Debug;
import org.esa.beam.util.ImageUtils;
import org.esa.beam.util.IntMap;
import org.esa.beam.util.jai.JAIUtils;
import org.esa.beam.util.math.MathUtils;
import org.geotools.referencing.crs.DefaultImageCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultImageDatum;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.ImageCRS;
import org.opengis.referencing.cs.AffineCS;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class ImageManager {
    public static final ImageCRS DEFAULT_IMAGE_CRS = new DefaultImageCRS("BEAM_IMAGE_CRS", (ImageDatum)new DefaultImageDatum("BEAM_IMAGE_DATUM", PixelInCell.CELL_CORNER), (AffineCS)DefaultCartesianCS.DISPLAY);
    private static final boolean CACHE_INTERMEDIATE_TILES = Boolean.getBoolean("beam.imageManager.enableIntermediateTileCaching");
    private final Map<MaskKey, MultiLevelImage> maskImageMap = new HashMap<MaskKey, MultiLevelImage>(101);
    private final ProductNodeListener rasterDataChangeListener = new RasterDataChangeListener();

    public static ImageManager getInstance() {
        return Holder.instance;
    }

    public synchronized void dispose() {
        for (MultiLevelSource multiLevelSource : this.maskImageMap.values()) {
            multiLevelSource.reset();
        }
        this.maskImageMap.clear();
    }

    public static MultiLevelModel getMultiLevelModel(RasterDataNode rasterDataNode) {
        if (rasterDataNode.isSourceImageSet()) {
            return rasterDataNode.getSourceImage().getModel();
        }
        return ImageManager.createMultiLevelModel(rasterDataNode);
    }

    public static AffineTransform getImageToModelTransform(GeoCoding geoCoding) {
        if (geoCoding == null) {
            return new AffineTransform();
        }
        MathTransform image2Map = geoCoding.getImageToMapTransform();
        if (image2Map instanceof AffineTransform) {
            return new AffineTransform((AffineTransform)((Object)image2Map));
        }
        return new AffineTransform();
    }

    public static CoordinateReferenceSystem getModelCrs(GeoCoding geoCoding) {
        if (geoCoding != null) {
            MathTransform image2Map = geoCoding.getImageToMapTransform();
            if (image2Map instanceof AffineTransform) {
                return geoCoding.getMapCRS();
            }
            return geoCoding.getImageCRS();
        }
        return DEFAULT_IMAGE_CRS;
    }

    public PlanarImage getSourceImage(RasterDataNode rasterDataNode, int level) {
        return ImageManager.getLevelImage(rasterDataNode.getSourceImage(), level);
    }

    public PlanarImage getValidMaskImage(RasterDataNode rasterDataNode, int level) {
        if (rasterDataNode.isValidMaskUsed()) {
            return ImageManager.getLevelImage(rasterDataNode.getValidMaskImage(), level);
        }
        return null;
    }

    public PlanarImage getGeophysicalImage(RasterDataNode rasterDataNode, int level) {
        return ImageManager.getLevelImage(rasterDataNode.getGeophysicalImage(), level);
    }

    public static ImageLayout createSingleBandedImageLayout(RasterDataNode rasterDataNode) {
        return ImageManager.createSingleBandedImageLayout(rasterDataNode, ImageManager.getDataBufferType(rasterDataNode.getDataType()));
    }

    public static ImageLayout createSingleBandedImageLayout(RasterDataNode rasterDataNode, int dataBufferType) {
        int width = rasterDataNode.getSceneRasterWidth();
        int height = rasterDataNode.getSceneRasterHeight();
        Dimension tileSize = ImageManager.getPreferredTileSize(rasterDataNode.getProduct());
        return ImageManager.createSingleBandedImageLayout(dataBufferType, width, height, tileSize.width, tileSize.height);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, int width, int height, int tileWidth, int tileHeight) {
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel(dataBufferType, tileWidth, tileHeight);
        ColorModel colorModel = PlanarImage.createColorModel(sampleModel);
        return new ImageLayout(0, 0, width, height, 0, 0, tileWidth, tileHeight, sampleModel, colorModel);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        return ImageManager.createSingleBandedImageLayout(dataBufferType, null, sourceWidth, sourceHeight, tileSize, level);
    }

    public static ImageLayout createSingleBandedImageLayout(int dataBufferType, Point sourcePos, int sourceWidth, int sourceHeight, Dimension tileSize, ResolutionLevel level) {
        if (sourceWidth < 0) {
            throw new IllegalArgumentException("sourceWidth");
        }
        if (sourceHeight < 0) {
            throw new IllegalArgumentException("sourceHeight");
        }
        Assert.notNull("level");
        Rectangle sourceBounds = new Rectangle(sourcePos != null ? sourcePos.x : 0, sourcePos != null ? sourcePos.y : 0, sourceWidth, sourceHeight);
        Rectangle destBounds = DefaultMultiLevelSource.getLevelImageBounds(sourceBounds, level.getScale());
        int destWidth = destBounds.width;
        int destHeight = destBounds.height;
        tileSize = tileSize != null ? tileSize : JAIUtils.computePreferredTileSize(destWidth, destHeight, 1);
        SampleModel sampleModel = ImageUtils.createSingleBandedSampleModel(dataBufferType, tileSize.width, tileSize.height);
        ColorModel colorModel = PlanarImage.createColorModel(sampleModel);
        if (colorModel == null) {
            int dataType = sampleModel.getDataType();
            ColorSpace cs = ColorSpace.getInstance(1003);
            int[] nBits = new int[]{DataBuffer.getDataTypeSize(dataType)};
            colorModel = new ComponentColorModel(cs, nBits, false, true, 1, dataType);
        }
        return new ImageLayout(destBounds.x, destBounds.y, destWidth, destHeight, 0, 0, tileSize.width, tileSize.height, sampleModel, colorModel);
    }

    public static int getDataBufferType(int productDataType) {
        switch (productDataType) {
            case 10: 
            case 20: {
                return 0;
            }
            case 11: {
                return 2;
            }
            case 21: {
                return 1;
            }
            case 12: 
            case 22: {
                return 3;
            }
            case 30: {
                return 4;
            }
            case 31: {
                return 5;
            }
        }
        throw new IllegalArgumentException("productDataType");
    }

    public static int getProductDataType(int dataBufferType) {
        switch (dataBufferType) {
            case 0: {
                return 20;
            }
            case 2: {
                return 11;
            }
            case 1: {
                return 21;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
        }
        throw new IllegalArgumentException("dataBufferType");
    }

    public static Dimension getPreferredTileSize(Product product) {
        Dimension preferredTileSize = product.getPreferredTileSize();
        Dimension tileSize = preferredTileSize != null ? preferredTileSize : JAIUtils.computePreferredTileSize(product.getSceneRasterWidth(), product.getSceneRasterHeight(), 1);
        return tileSize;
    }

    public RenderedImage createColoredBandImage(RasterDataNode[] rasterDataNodes, ImageInfo imageInfo, int level) {
        Assert.notNull(rasterDataNodes, "rasterDataNodes");
        Assert.state(rasterDataNodes.length == 1 || rasterDataNodes.length == 3 || rasterDataNodes.length == 4, "invalid number of bands");
        this.prepareImageInfos(rasterDataNodes, ProgressMonitor.NULL);
        if (rasterDataNodes.length == 1) {
            return this.createColored1BandImage(rasterDataNodes[0], imageInfo, level);
        }
        return this.createColored3BandImage(rasterDataNodes, imageInfo, level);
    }

    public static MultiLevelModel createMultiLevelModel(ProductNode productNode) {
        Scene scene = SceneFactory.createScene(productNode);
        if (scene == null) {
            return null;
        }
        int w = scene.getRasterWidth();
        int h = scene.getRasterHeight();
        AffineTransform i2mTransform = ImageManager.getImageToModelTransform(scene.getGeoCoding());
        Product product = scene.getProduct();
        if (product != null && product.getNumResolutionsMax() > 0) {
            return new DefaultMultiLevelModel(product.getNumResolutionsMax(), i2mTransform, w, h);
        }
        return new DefaultMultiLevelModel(i2mTransform, w, h);
    }

    private RenderedImage createColored1BandImage(RasterDataNode raster, ImageInfo imageInfo, int level) {
        Assert.notNull(raster, "raster");
        if (imageInfo == null) {
            imageInfo = raster.getImageInfo(ProgressMonitor.NULL);
        }
        Assert.notNull(imageInfo, "imageInfo");
        PlanarImage sourceImage = this.getSourceImage(raster, level);
        PlanarImage validMaskImage = this.getValidMaskImage(raster, level);
        PlanarImage image = ImageManager.createByteIndexedImage(raster, sourceImage, imageInfo);
        image = ImageManager.createMatchCdfImage(image, imageInfo.getHistogramMatching(), new Stx[]{raster.getStx()});
        image = ImageManager.createLookupRgbImage(raster, image, validMaskImage, imageInfo);
        return image;
    }

    private PlanarImage createColored3BandImage(RasterDataNode[] rasters, ImageInfo rgbImageInfo, int level) {
        Assert.notNull(rasters, "rasters");
        Assert.notNull(rgbImageInfo, "rgbImageInfo");
        RenderedImage[] images = new RenderedImage[rasters.length];
        RenderedImage[] validMaskImages = new RenderedImage[rasters.length];
        Stx[] stxs = new Stx[rasters.length];
        int i = 0;
        while (i < rasters.length) {
            RasterDataNode raster = rasters[i];
            stxs[i] = raster.getStx();
            PlanarImage sourceImage = this.getSourceImage(raster, level);
            images[i] = ImageManager.createByteIndexedImage(raster, sourceImage, rgbImageInfo.getRgbChannelDef().getMinDisplaySample(i), rgbImageInfo.getRgbChannelDef().getMaxDisplaySample(i), rgbImageInfo.getRgbChannelDef().getGamma(i));
            validMaskImages[i] = this.getValidMaskImage(raster, level);
            ++i;
        }
        return ImageManager.createMergeRgbaOp(images, validMaskImages, rgbImageInfo.getHistogramMatching(), stxs);
    }

    private static PlanarImage createByteIndexedImage(RasterDataNode raster, RenderedImage sourceImage, ImageInfo imageInfo) {
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        double minSample = colorPaletteDef.getMinDisplaySample();
        double maxSample = colorPaletteDef.getMaxDisplaySample();
        if (ImageManager.isClassificationBand(raster)) {
            IntMap sampleColorIndexMap = new IntMap((int)minSample - 1, 4098);
            ColorPaletteDef.Point[] points = colorPaletteDef.getPoints();
            int colorIndex = 0;
            while (colorIndex < points.length) {
                sampleColorIndexMap.putValue((int)ImageManager.getSample(points[colorIndex]), colorIndex);
                ++colorIndex;
            }
            int undefinedIndex = colorPaletteDef.getNumPoints();
            return ImageManager.createIndexedImage(sourceImage, sampleColorIndexMap, undefinedIndex);
        }
        return ImageManager.createByteIndexedImage(raster, sourceImage, minSample, maxSample, 1.0);
    }

    private static boolean isClassificationBand(RasterDataNode raster) {
        return (raster instanceof Band ? ((Band)raster).getIndexCoding() : null) != null;
    }

    private static PlanarImage createByteIndexedImage(RasterDataNode raster, RenderedImage sourceImage, double minSample, double maxSample, double gamma) {
        double newMin = raster.scaleInverse(minSample);
        double newMax = raster.scaleInverse(maxSample);
        if (ImageManager.mustReinterpretSourceImage(raster, sourceImage)) {
            sourceImage = ReinterpretDescriptor.create(sourceImage, 1.0, 0.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.INTERPRET_BYTE_SIGNED, null);
        }
        boolean logarithmicDisplay = raster.getImageInfo().isLogScaled();
        boolean rasterIsLog10Scaled = raster.isLog10Scaled();
        if (logarithmicDisplay) {
            if (!rasterIsLog10Scaled) {
                double offset = raster.scaleInverse(0.0);
                sourceImage = ReinterpretDescriptor.create(sourceImage, 1.0, -offset, ReinterpretDescriptor.LOGARITHMIC, ReinterpretDescriptor.AWT, null);
                newMin = Math.log10(newMin - offset);
                newMax = Math.log10(newMax - offset);
            }
        } else if (rasterIsLog10Scaled) {
            sourceImage = ReinterpretDescriptor.create(sourceImage, raster.getScalingFactor(), raster.getScalingOffset(), ReinterpretDescriptor.EXPONENTIAL, ReinterpretDescriptor.AWT, null);
            newMin = minSample;
            newMax = maxSample;
        }
        double factor = 255.0 / (newMax - newMin);
        double offset = 255.0 * newMin / (newMin - newMax);
        PlanarImage image = ImageManager.createRescaleOp(sourceImage, factor, offset);
        image = ImageManager.createByteFormatOp(image);
        if (gamma != 1.0) {
            byte[] gammaCurve = MathUtils.createGammaCurve(gamma, new byte[256]);
            LookupTableJAI lookupTable = new LookupTableJAI(gammaCurve);
            image = LookupDescriptor.create(image, lookupTable, ImageManager.createDefaultRenderingHints(image, null));
        }
        return image;
    }

    private static boolean mustReinterpretSourceImage(RasterDataNode raster, RenderedImage sourceImage) {
        return sourceImage.getSampleModel().getDataType() == 0 && raster.getDataType() == 10;
    }

    private static RenderingHints createDefaultRenderingHints(RenderedImage sourceImage, ImageLayout targetLayout) {
        HashMap<RenderingHints.Key, ImageLayout> map = new HashMap<RenderingHints.Key, ImageLayout>(7);
        if (!CACHE_INTERMEDIATE_TILES) {
            map.put(JAI.KEY_TILE_CACHE, null);
        }
        if (sourceImage != null) {
            if (targetLayout == null) {
                targetLayout = new ImageLayout();
            }
            if (!targetLayout.isValid(16)) {
                targetLayout.setTileGridXOffset(sourceImage.getTileGridXOffset());
            }
            if (!targetLayout.isValid(32)) {
                targetLayout.setTileGridYOffset(sourceImage.getTileGridYOffset());
            }
            if (!targetLayout.isValid(64)) {
                targetLayout.setTileWidth(sourceImage.getTileWidth());
            }
            if (!targetLayout.isValid(128)) {
                targetLayout.setTileHeight(sourceImage.getTileHeight());
            }
            map.put(JAI.KEY_IMAGE_LAYOUT, targetLayout);
        }
        return new RenderingHints(map);
    }

    private static PlanarImage createIndexedImage(RenderedImage sourceImage, IntMap intMap, int undefinedIndex) {
        LookupTableJAI lookup;
        Object[] table;
        if (sourceImage.getSampleModel().getNumBands() != 1) {
            throw new IllegalArgumentException();
        }
        int[][] ranges = intMap.getRanges();
        int keyMin = ranges[0][0];
        int keyMax = ranges[0][1];
        int valueMin = ranges[1][0];
        int valueMax = ranges[1][1];
        int keyRange = 1 + keyMax - keyMin;
        int valueRange = 1 + valueMax - valueMin;
        if (keyRange > Short.MAX_VALUE) {
            throw new IllegalArgumentException("intMap: keyRange > Short.MAX_VALUE");
        }
        if (valueRange <= 256) {
            table = new byte[keyRange + 2];
            int i = 1;
            while (i < table.length - 1) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (byte)(value != Integer.MIN_VALUE ? value : undefinedIndex);
                ++i;
            }
            table[0] = (byte)undefinedIndex;
            table[table.length - 1] = (byte)undefinedIndex;
            lookup = new LookupTableJAI((byte[])table, keyMin - 1);
        } else if (valueRange <= 65536) {
            table = new short[keyRange + 2];
            int i = 1;
            while (i < table.length) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = (short)(value != Integer.MIN_VALUE ? value : undefinedIndex);
                ++i;
            }
            table[0] = (short)undefinedIndex;
            table[table.length - 1] = (short)undefinedIndex;
            lookup = new LookupTableJAI((short[])table, keyMin - 1, valueRange > Short.MAX_VALUE);
        } else {
            table = new int[keyRange + 2];
            int i = 1;
            while (i < table.length) {
                int value = intMap.getValue(keyMin + i - 1);
                table[i] = value != Integer.MIN_VALUE ? value : undefinedIndex;
                ++i;
            }
            table[0] = undefinedIndex;
            table[table.length - 1] = undefinedIndex;
            lookup = new LookupTableJAI((int[])table, keyMin - 1);
        }
        RenderingHints hints = ImageManager.createDefaultRenderingHints(sourceImage, null);
        sourceImage = ClampDescriptor.create(sourceImage, new double[]{keyMin - 1}, new double[]{keyMax + 1}, hints);
        return LookupDescriptor.create(sourceImage, lookup, hints);
    }

    private static PlanarImage createMergeRgbaOp(RenderedImage[] sourceImages, RenderedImage[] maskOpImages, ImageInfo.HistogramMatching histogramMatching, Stx[] stxs) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(sourceImages[0], null);
        if (histogramMatching == ImageInfo.HistogramMatching.None) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(sourceImages[0]);
            pb.addSource(sourceImages[1]);
            pb.addSource(sourceImages[2]);
            RenderedImage alpha = ImageManager.createMapOp(maskOpImages);
            if (alpha != null) {
                pb.addSource(alpha);
            }
            return JAI.create("bandmerge", pb, hints);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImages[0]);
        pb.addSource(sourceImages[1]);
        pb.addSource(sourceImages[2]);
        PlanarImage image = JAI.create("bandmerge", pb, hints);
        image = histogramMatching == ImageInfo.HistogramMatching.Equalize ? ImageManager.createMatchCdfEqualizeImage(image, stxs) : ImageManager.createMatchCdfNormalizeImage(image, stxs);
        RenderedImage alpha = ImageManager.createMapOp(maskOpImages);
        if (alpha != null) {
            pb = new ParameterBlock();
            pb.addSource(image);
            pb.addSource(alpha);
            image = JAI.create("bandmerge", pb, hints);
        }
        return image;
    }

    private static RenderedImage createMapOp(RenderedImage[] maskOpImages) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(maskOpImages.length > 0 ? maskOpImages[0] : null, null);
        RenderedImage alpha = null;
        RenderedImage[] renderedImageArray = maskOpImages;
        int n = maskOpImages.length;
        int n2 = 0;
        while (n2 < n) {
            RenderedImage maskOpImage = renderedImageArray[n2];
            if (maskOpImage != null) {
                alpha = alpha != null ? MaxDescriptor.create(alpha, maskOpImage, hints) : maskOpImage;
            }
            ++n2;
        }
        return alpha;
    }

    private static PlanarImage createLookupRgbImage(RasterDataNode rasterDataNode, RenderedImage sourceImage, RenderedImage maskImage, ImageInfo imageInfo) {
        Color[] palette;
        ColorPaletteDef colorPaletteDef = imageInfo.getColorPaletteDef();
        if (ImageManager.isClassificationBand(rasterDataNode)) {
            Color[] origPalette = colorPaletteDef.getColors();
            palette = Arrays.copyOf(origPalette, origPalette.length + 1);
            palette[palette.length - 1] = imageInfo.getNoDataColor();
        } else {
            palette = ImageManager.createColorPalette(imageInfo);
        }
        byte[][] lutData = new byte[3][palette.length];
        int i = 0;
        while (i < palette.length) {
            lutData[0][i] = (byte)palette[i].getRed();
            lutData[1][i] = (byte)palette[i].getGreen();
            lutData[2][i] = (byte)palette[i].getBlue();
            ++i;
        }
        PlanarImage image = ImageManager.createLookupOp(sourceImage, lutData);
        if (maskImage != null) {
            Color noDataColor = imageInfo.getNoDataColor();
            Number[] noDataRGB = new Byte[]{(byte)noDataColor.getRed(), (byte)noDataColor.getGreen(), (byte)noDataColor.getBlue()};
            RenderedOp noDataColorImage = ConstantDescriptor.create(Float.valueOf(image.getWidth()), Float.valueOf(image.getHeight()), noDataRGB, ImageManager.createDefaultRenderingHints(sourceImage, null));
            byte noDataAlpha = (byte)noDataColor.getAlpha();
            RenderedOp noDataAlphaImage = ConstantDescriptor.create(Float.valueOf(image.getWidth()), Float.valueOf(image.getHeight()), new Byte[]{noDataAlpha}, ImageManager.createDefaultRenderingHints(sourceImage, null));
            image = CompositeDescriptor.create(image, noDataColorImage, maskImage, noDataAlphaImage, false, CompositeDescriptor.DESTINATION_ALPHA_LAST, ImageManager.createDefaultRenderingHints(sourceImage, null));
        }
        return image;
    }

    private static PlanarImage createMatchCdfImage(PlanarImage sourceImage, ImageInfo.HistogramMatching histogramMatching, Stx[] stxs) {
        boolean doNormalize;
        boolean doEqualize = ImageInfo.HistogramMatching.Equalize == histogramMatching;
        boolean bl = doNormalize = ImageInfo.HistogramMatching.Normalize == histogramMatching;
        if (doEqualize) {
            sourceImage = ImageManager.createMatchCdfEqualizeImage(sourceImage, stxs);
        } else if (doNormalize) {
            sourceImage = ImageManager.createMatchCdfNormalizeImage(sourceImage, stxs);
        }
        return sourceImage;
    }

    private static PlanarImage createMatchCdfEqualizeImage(PlanarImage sourceImage, Stx[] stxs) {
        Assert.notNull(sourceImage, "sourceImage");
        Assert.notNull(stxs, "stxs");
        int numBands = sourceImage.getSampleModel().getNumBands();
        Assert.argument(stxs.length == numBands, "stxs");
        Histogram histogram = ImageManager.createHistogram(sourceImage, stxs);
        float[][] eqCDF = new float[numBands][];
        int b = 0;
        while (b < numBands) {
            int binCount = histogram.getNumBins(b);
            eqCDF[b] = new float[binCount];
            int i = 0;
            while (i < binCount) {
                eqCDF[b][i] = (float)(i + 1) / (float)binCount;
                ++i;
            }
            ++b;
        }
        return MatchCDFDescriptor.create(sourceImage, eqCDF, ImageManager.createDefaultRenderingHints(sourceImage, null));
    }

    private static Histogram createHistogram(PlanarImage sourceImage, Stx[] stxs) {
        Histogram histogram = ImageManager.createHistogram(stxs);
        sourceImage.setProperty("histogram", histogram);
        if (sourceImage instanceof RenderedOp) {
            RenderedOp renderedOp = (RenderedOp)sourceImage;
            renderedOp.getRendering().setProperty("histogram", histogram);
        }
        return histogram;
    }

    private static Histogram createHistogram(Stx[] stxs) {
        Histogram histogram = new Histogram(stxs[0].getHistogramBinCount(), 0.0, 256.0, stxs.length);
        int i = 0;
        while (i < stxs.length) {
            System.arraycopy(stxs[i].getHistogramBins(), 0, histogram.getBins(i), 0, stxs[0].getHistogramBinCount());
            ++i;
        }
        return histogram;
    }

    private static PlanarImage createMatchCdfNormalizeImage(PlanarImage sourceImage, Stx[] stxs) {
        int numBands = sourceImage.getSampleModel().getNumBands();
        double[] means = new double[numBands];
        Arrays.fill(means, 128.0);
        double[] stdDevs = new double[numBands];
        Arrays.fill(stdDevs, 64.0);
        return ImageManager.createHistogramNormalizedImage(sourceImage, stxs, means, stdDevs);
    }

    private static PlanarImage createHistogramNormalizedImage(PlanarImage sourceImage, Stx[] stxs, double[] mean, double[] stdDev) {
        int binCount;
        int numBands = sourceImage.getSampleModel().getNumBands();
        Assert.argument(numBands == mean.length, "length of mean must be equal to number of bands in the image");
        Assert.argument(numBands == stdDev.length, "length of stdDev must be equal to number of bands in the image");
        Histogram histogram = ImageManager.createHistogram(sourceImage, stxs);
        float[][] normCDF = new float[numBands][];
        int b = 0;
        while (b < numBands) {
            binCount = histogram.getNumBins(b);
            normCDF[b] = new float[binCount];
            double mu = mean[b];
            double twoSigmaSquared = 2.0 * stdDev[b] * stdDev[b];
            normCDF[b][0] = (float)Math.exp(-mu * mu / twoSigmaSquared);
            int i = 1;
            while (i < binCount) {
                double deviation = (double)i - mu;
                normCDF[b][i] = normCDF[b][i - 1] + (float)Math.exp(-deviation * deviation / twoSigmaSquared);
                ++i;
            }
            ++b;
        }
        b = 0;
        while (b < numBands) {
            binCount = histogram.getNumBins(b);
            double CDFnormLast = normCDF[b][binCount - 1];
            int i = 0;
            while (i < binCount) {
                float[] fArray = normCDF[b];
                int n = i++;
                fArray[n] = (float)((double)fArray[n] / CDFnormLast);
            }
            ++b;
        }
        return MatchCDFDescriptor.create(sourceImage, normCDF, ImageManager.createDefaultRenderingHints(sourceImage, null));
    }

    private static PlanarImage getLevelImage(MultiLevelImage levelZeroImage, int level) {
        RenderedImage image = levelZeroImage.getImage(level);
        return PlanarImage.wrapRenderedImage(image);
    }

    public RenderedImage getMaskImage(Product product, String expression, int level) {
        MultiLevelImage mli = this.getMaskImage(expression, product);
        return mli.getImage(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiLevelImage getMaskImage(final String expression, final Product product) {
        Map<MaskKey, MultiLevelImage> map = this.maskImageMap;
        synchronized (map) {
            MaskKey key = new MaskKey(product, expression);
            MultiLevelImage mli = this.maskImageMap.get(key);
            if (mli == null) {
                AbstractMultiLevelSource mls = new AbstractMultiLevelSource(ImageManager.createMultiLevelModel(product)){

                    @Override
                    public RenderedImage createImage(int level) {
                        return VirtualBandOpImage.createMask(expression, product, ResolutionLevel.create(this.getModel(), level));
                    }
                };
                mli = new DefaultMultiLevelImage(mls);
                product.addProductNodeListener(this.rasterDataChangeListener);
                this.maskImageMap.put(key, mli);
            }
            return mli;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMaskImageCache(Product product) {
        Map<MaskKey, MultiLevelImage> map = this.maskImageMap;
        synchronized (map) {
            Iterator<MaskKey> keySetIterator = this.maskImageMap.keySet().iterator();
            while (keySetIterator.hasNext()) {
                MaskKey next = keySetIterator.next();
                if (next.product.get() != product) continue;
                keySetIterator.remove();
            }
        }
    }

    public ImageInfo getImageInfo(RasterDataNode[] rasters) {
        Assert.notNull(rasters, "rasters");
        Assert.argument(rasters.length == 1 || rasters.length == 3, "rasters.length == 1 || rasters.length == 3");
        if (rasters.length == 1) {
            RasterDataNode raster = rasters[0];
            Assert.state(raster.getImageInfo() != null, "raster.getImageInfo() != null");
            return raster.getImageInfo();
        }
        RGBChannelDef rgbChannelDef = new RGBChannelDef();
        int i = 0;
        while (i < rasters.length) {
            RasterDataNode raster = rasters[i];
            Assert.state(rasters[i].getImageInfo() != null, "rasters[i].getImageInfo() != null");
            ImageInfo imageInfo = raster.getImageInfo();
            rgbChannelDef.setSourceName(i, raster.getName());
            rgbChannelDef.setMinDisplaySample(i, imageInfo.getColorPaletteDef().getMinDisplaySample());
            rgbChannelDef.setMaxDisplaySample(i, imageInfo.getColorPaletteDef().getMaxDisplaySample());
            ++i;
        }
        return new ImageInfo(rgbChannelDef);
    }

    public void prepareImageInfos(RasterDataNode[] rasterDataNodes, ProgressMonitor pm) {
        RasterDataNode raster;
        int numTaskSteps = 0;
        RasterDataNode[] rasterDataNodeArray = rasterDataNodes;
        int n = rasterDataNodes.length;
        int n2 = 0;
        while (n2 < n) {
            raster = rasterDataNodeArray[n2];
            numTaskSteps += raster.getImageInfo() == null ? 1 : 0;
            ++n2;
        }
        pm.beginTask("Computing image statistics", numTaskSteps);
        try {
            rasterDataNodeArray = rasterDataNodes;
            n = rasterDataNodes.length;
            n2 = 0;
            while (n2 < n) {
                raster = rasterDataNodeArray[n2];
                ImageInfo imageInfo = raster.getImageInfo();
                if (imageInfo == null) {
                    raster.getImageInfo(SubProgressMonitor.create(pm, 1));
                }
                ++n2;
            }
        }
        finally {
            pm.done();
        }
    }

    public int getStatisticsLevel(RasterDataNode raster, int levelCount) {
        long imageSize = (long)raster.getSceneRasterWidth() * (long)raster.getSceneRasterHeight();
        int statisticsLevel = imageSize <= 65536L ? 0 : levelCount - 1;
        return statisticsLevel;
    }

    public PlanarImage createColoredMaskImage(Product product, String expression, Color color, boolean invertMask, int level) {
        RenderedImage image = this.getMaskImage(product, expression, level);
        return ImageManager.createColoredMaskImage(color, image, invertMask);
    }

    public static PlanarImage createColoredMaskImage(Color color, RenderedImage alphaImage, boolean invertAlpha) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(alphaImage, null);
        return ImageManager.createColoredMaskImage(color, invertAlpha ? InvertDescriptor.create(alphaImage, hints) : alphaImage, hints);
    }

    public static PlanarImage createColoredMaskImage(RenderedImage maskImage, Color color, double opacity) {
        RenderingHints hints = ImageManager.createDefaultRenderingHints(maskImage, null);
        RenderedOp alphaImage = MultiplyConstDescriptor.create(maskImage, new double[]{opacity}, hints);
        return ImageManager.createColoredMaskImage(color, (RenderedImage)alphaImage, hints);
    }

    public static PlanarImage createColoredMaskImage(Color color, RenderedImage alphaImage, RenderingHints hints) {
        RenderedOp colorImage = ConstantDescriptor.create(Float.valueOf(alphaImage.getWidth()), Float.valueOf(alphaImage.getHeight()), new Byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()}, hints);
        return BandMergeDescriptor.create(colorImage, alphaImage, hints);
    }

    public static MultiLevelImage createMaskedGeophysicalImage(RasterDataNode node, Number maskValue) {
        MultiLevelImage varImage = node.getGeophysicalImage();
        if (node.getValidPixelExpression() != null) {
            varImage = ImageManager.replaceInvalidValuesByNaN(node, varImage, node.getValidMaskImage(), maskValue);
        } else if (node.isNoDataValueSet() && node.isNoDataValueUsed() && Double.compare(maskValue.doubleValue(), node.getGeophysicalNoDataValue()) != 0) {
            varImage = ImageManager.replaceNoDataValueByNaN(node, varImage, node.getGeophysicalNoDataValue(), maskValue);
        }
        return varImage;
    }

    private static MultiLevelImage replaceInvalidValuesByNaN(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final MultiLevelImage maskImage, final Number fillValue) {
        MultiLevelModel multiLevelModel = ImageManager.getMultiLevelModel(rasterDataNode);
        return new DefaultMultiLevelImage(new AbstractMultiLevelSource(multiLevelModel){

            @Override
            public RenderedImage createImage(int sourceLevel) {
                return new FillConstantOpImage(srcImage.getImage(sourceLevel), maskImage.getImage(sourceLevel), fillValue);
            }
        });
    }

    private static MultiLevelImage replaceNoDataValueByNaN(RasterDataNode rasterDataNode, final MultiLevelImage srcImage, final double noDataValue, final Number newValue) {
        MultiLevelModel multiLevelModel = ImageManager.getMultiLevelModel(rasterDataNode);
        final int targetDataType = ImageManager.getDataBufferType(rasterDataNode.getGeophysicalDataType());
        return new DefaultMultiLevelImage(new AbstractMultiLevelSource(multiLevelModel){

            @Override
            public RenderedImage createImage(int sourceLevel) {
                return new ReplaceValueOpImage((RenderedImage)srcImage, noDataValue, newValue, targetDataType);
            }
        });
    }

    public static RenderedImage createFormatOp(RenderedImage image, int dataType) {
        if (image.getSampleModel().getDataType() == dataType) {
            return PlanarImage.wrapRenderedImage(image);
        }
        return FormatDescriptor.create(image, dataType, ImageManager.createDefaultRenderingHints(image, null));
    }

    private static PlanarImage createRescaleOp(RenderedImage src, double factor, double offset) {
        if (factor == 1.0 && offset == 0.0) {
            return PlanarImage.wrapRenderedImage(src);
        }
        return RescaleDescriptor.create(src, new double[]{factor}, new double[]{offset}, ImageManager.createDefaultRenderingHints(src, null));
    }

    private static PlanarImage createLookupOp(RenderedImage src, byte[][] lookupTable) {
        LookupTableJAI lookup = new LookupTableJAI(lookupTable);
        return LookupDescriptor.create(src, lookup, ImageManager.createDefaultRenderingHints(src, null));
    }

    private static PlanarImage createByteFormatOp(RenderedImage src) {
        ColorModel cm = ImageUtils.create8BitGreyscaleColorModel();
        SampleModel sm = cm.createCompatibleSampleModel(src.getTileWidth(), src.getTileHeight());
        ImageLayout layout = new ImageLayout(src);
        layout.setColorModel(cm);
        layout.setSampleModel(sm);
        return FormatDescriptor.create(src, 0, ImageManager.createDefaultRenderingHints(src, layout));
    }

    public static Color[] createColorPalette(ImageInfo imageInfo) {
        double maxSample;
        double minSample;
        Debug.assertNotNull(imageInfo);
        boolean logScaled = imageInfo.isLogScaled();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        Debug.assertNotNull(cpd);
        Debug.assertTrue(cpd.getNumPoints() >= 2);
        if (logScaled) {
            minSample = ImageManager.getSampleLog(cpd.getFirstPoint());
            maxSample = ImageManager.getSampleLog(cpd.getLastPoint());
        } else {
            minSample = ImageManager.getSample(cpd.getFirstPoint());
            maxSample = ImageManager.getSample(cpd.getLastPoint());
        }
        int numColors = cpd.getNumColors();
        double scalingFactor = 1.0 / ((double)numColors - 1.0);
        Color[] colorPalette = new Color[numColors];
        int pointIndex = 0;
        int maxPointIndex = cpd.getNumPoints() - 2;
        BorderSamplesAndColors boSaCo = ImageManager.getBorderSamplesAndColors(imageInfo, pointIndex, null);
        int i = 0;
        while (i < numColors - 1) {
            double w = (double)i * scalingFactor;
            double sample = minSample + w * (maxSample - minSample);
            if (sample >= boSaCo.sample2) {
                ++pointIndex;
                pointIndex = Math.min(pointIndex, maxPointIndex);
                boSaCo = ImageManager.getBorderSamplesAndColors(imageInfo, pointIndex, boSaCo);
            }
            colorPalette[i] = cpd.isDiscrete() ? boSaCo.color1 : ImageManager.computeColor(sample, boSaCo);
            ++i;
        }
        colorPalette[numColors - 1] = boSaCo.color2;
        return colorPalette;
    }

    private static double getSample(ColorPaletteDef.Point point) {
        return point.getSample();
    }

    private static double getSampleLog(ColorPaletteDef.Point point) {
        return Stx.LOG10_SCALING.scale(ImageManager.getSample(point));
    }

    private static BorderSamplesAndColors getBorderSamplesAndColors(ImageInfo imageInfo, int pointIdx, BorderSamplesAndColors boSaCo) {
        if (boSaCo == null) {
            boSaCo = new BorderSamplesAndColors();
        }
        boolean logScaled = imageInfo.isLogScaled();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        ColorPaletteDef.Point p1 = cpd.getPointAt(pointIdx);
        ColorPaletteDef.Point p2 = cpd.getPointAt(pointIdx + 1);
        if (logScaled) {
            boSaCo.sample1 = ImageManager.getSampleLog(p1);
            boSaCo.sample2 = ImageManager.getSampleLog(p2);
        } else {
            boSaCo.sample1 = ImageManager.getSample(p1);
            boSaCo.sample2 = ImageManager.getSample(p2);
        }
        boSaCo.color1 = p1.getColor();
        boSaCo.color2 = p2.getColor();
        return boSaCo;
    }

    public static Color computeColor(ImageInfo imageInfo, Double rasterValue) {
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        if (rasterValue <= cpd.getMinDisplaySample()) {
            return cpd.getFirstPoint().getColor();
        }
        if (rasterValue >= cpd.getMaxDisplaySample()) {
            return cpd.getLastPoint().getColor();
        }
        BorderSamplesAndColors boSaCo = new BorderSamplesAndColors();
        boolean logScaled = imageInfo.isLogScaled();
        if (logScaled) {
            rasterValue = Stx.LOG10_SCALING.scale(rasterValue);
        }
        int i = 0;
        while (i < cpd.getNumPoints() - 1) {
            boSaCo = ImageManager.getBorderSamplesAndColors(imageInfo, i, boSaCo);
            if (rasterValue >= boSaCo.sample1 && rasterValue <= boSaCo.sample2) {
                return ImageManager.computeColor(rasterValue, boSaCo);
            }
            ++i;
        }
        return Color.black;
    }

    private static Color computeColor(double sample, BorderSamplesAndColors boSaCo) {
        double f = (sample - boSaCo.sample1) / (boSaCo.sample2 - boSaCo.sample1);
        double r1 = boSaCo.color1.getRed();
        double r2 = boSaCo.color2.getRed();
        double g1 = boSaCo.color1.getGreen();
        double g2 = boSaCo.color2.getGreen();
        double b1 = boSaCo.color1.getBlue();
        double b2 = boSaCo.color2.getBlue();
        double a1 = boSaCo.color1.getAlpha();
        double a2 = boSaCo.color2.getAlpha();
        int red = (int)MathUtils.roundAndCrop(r1 + f * (r2 - r1), 0L, 255L);
        int green = (int)MathUtils.roundAndCrop(g1 + f * (g2 - g1), 0L, 255L);
        int blue = (int)MathUtils.roundAndCrop(b1 + f * (b2 - b1), 0L, 255L);
        int alpha = (int)MathUtils.roundAndCrop(a1 + f * (a2 - a1), 0L, 255L);
        return new Color(red, green, blue, alpha);
    }

    private static class BorderSamplesAndColors {
        double sample1;
        double sample2;
        Color color1;
        Color color2;

        private BorderSamplesAndColors() {
        }
    }

    private static class Holder {
        private static final ImageManager instance = new ImageManager();

        private Holder() {
        }
    }

    private static class MaskKey {
        private final WeakReference<Product> product;
        private final String expression;

        private MaskKey(Product product, String expression) {
            Assert.notNull(product, "product");
            Assert.notNull(expression, "expression");
            this.product = new WeakReference<Product>(product);
            this.expression = expression;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            MaskKey key = (MaskKey)o;
            return this.product.get() == key.product.get() && this.expression.equals(key.expression);
        }

        public int hashCode() {
            int result = ((Product)this.product.get()).hashCode();
            result = 31 * result + this.expression.hashCode();
            return result;
        }
    }

    private class RasterDataChangeListener
    extends ProductNodeListenerAdapter {
        private RasterDataChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeDataChanged(ProductNodeEvent event) {
            super.nodeDataChanged(event);
            ProductNode node = event.getSourceNode();
            Map map = ImageManager.this.maskImageMap;
            synchronized (map) {
                Set keySet = ImageManager.this.maskImageMap.keySet();
                for (MaskKey maskKey : keySet) {
                    if (maskKey.product.get() != node.getProduct() || !maskKey.expression.contains(node.getName())) continue;
                    ((MultiLevelImage)ImageManager.this.maskImageMap.get(maskKey)).reset();
                }
            }
        }
    }
}

