/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.jai;

import com.bc.ceres.jai.NoDataRaster;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.SourcelessOpImage;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.jai.LevelImageSupport;
import org.esa.beam.jai.ResolutionLevel;

public abstract class SingleBandedOpImage
extends SourcelessOpImage {
    private LevelImageSupport levelImageSupport;

    protected SingleBandedOpImage(int dataBufferType, int sourceWidth, int sourceHeight, Dimension tileSize, Map configuration, ResolutionLevel level) {
        this(dataBufferType, null, sourceWidth, sourceHeight, tileSize, configuration, level);
    }

    protected SingleBandedOpImage(int dataBufferType, Point sourcePos, int sourceWidth, int sourceHeight, Dimension tileSize, Map configuration, ResolutionLevel level) {
        this(ImageManager.createSingleBandedImageLayout(dataBufferType, sourcePos, sourceWidth, sourceHeight, tileSize, level), sourceWidth, sourceHeight, configuration, level);
    }

    private SingleBandedOpImage(ImageLayout layout, int sourceWidth, int sourceHeight, Map configuration, ResolutionLevel level) {
        super(layout, configuration, layout.getSampleModel(null), layout.getMinX(null), layout.getMinY(null), layout.getWidth(null), layout.getHeight(null));
        this.levelImageSupport = new LevelImageSupport(sourceWidth, sourceHeight, level);
        if (this.getTileCache() == null) {
            this.setTileCache(JAI.getDefaultInstance().getTileCache());
        }
    }

    public final int getLevel() {
        return this.levelImageSupport.getLevel();
    }

    protected final double getScale() {
        return this.levelImageSupport.getScale();
    }

    protected final int getSourceX(int targetX) {
        return this.levelImageSupport.getSourceX(targetX);
    }

    protected final int getSourceY(int targetY) {
        return this.levelImageSupport.getSourceY(targetY);
    }

    protected final int getSourceWidth(int targetWidth) {
        return this.levelImageSupport.getSourceWidth(targetWidth);
    }

    protected final int getSourceHeight(int targetHeight) {
        return this.levelImageSupport.getSourceHeight(targetHeight);
    }

    protected final int getSourceCoord(double targetCoord, int min, int max) {
        return this.levelImageSupport.getSourceCoord(targetCoord, min, max);
    }

    protected LevelImageSupport getLevelImageSupport() {
        return this.levelImageSupport;
    }

    protected NoDataRaster createNoDataRaster(double noDataValue) {
        WritableRaster raster = this.createWritableRaster(this.getSampleModel(), new Point(0, 0));
        DataBuffer buffer = raster.getDataBuffer();
        int i = 0;
        while (i < buffer.getSize()) {
            buffer.setElemDouble(i, noDataValue);
            ++i;
        }
        return new NoDataRaster(raster);
    }

    @Override
    protected final void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
    }
}

