/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import java.beans.PropertyChangeEvent;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Logger;
import org.esa.beam.util.AssertionFailure;
import org.esa.beam.util.logging.BeamLogManager;

public class Debug {
    private static final boolean DEBUG = true;
    private static boolean _enabled = false;
    private static PrintWriter _writer = null;
    private static PrintWriter _defaultWriter = null;
    private static final String _tracePrefix = "beam-debug: ";
    private static Logger _logger = null;
    private static boolean _logging;

    public static boolean isLogging() {
        return _logging;
    }

    public static void setLogging(boolean logging) {
        _logging = logging;
    }

    public static boolean setEnabled(boolean enabled) {
        boolean oldValue = _enabled;
        _enabled = enabled;
        return oldValue;
    }

    public static boolean isEnabled() {
        return _enabled;
    }

    public static PrintWriter getDefaultWriter() {
        if (Debug.isEnabled() && _defaultWriter == null) {
            _defaultWriter = Debug.createPrintWriter(System.out);
        }
        return _defaultWriter;
    }

    public static PrintWriter getWriter() {
        if (Debug.isEnabled() && _writer == null) {
            _writer = Debug.getDefaultWriter();
        }
        return _writer;
    }

    public static void setWriter(Writer writer) {
        if (Debug.isEnabled() && writer != null) {
            _writer = Debug.createPrintWriter(writer);
        }
    }

    public static void setWriter(OutputStream stream) {
        if (Debug.isEnabled() && stream != null) {
            _writer = Debug.createPrintWriter(stream);
        }
    }

    public static void trace(String message) {
        if (Debug.isEnabled() && message != null) {
            PrintWriter w = Debug.getWriter();
            w.print(_tracePrefix);
            w.println(message);
            Debug.log(message);
        }
    }

    public static void trace(Throwable exception) {
        if (Debug.isEnabled() && exception != null) {
            PrintWriter w = Debug.getWriter();
            w.print(_tracePrefix);
            w.println("An exception occurred: ");
            exception.printStackTrace(w);
            Debug.log("An exception occurred: ");
            Debug.log(exception);
        }
    }

    public static void trace(PropertyChangeEvent event) {
        if (Debug.isEnabled() && event != null) {
            PrintWriter w = Debug.getWriter();
            w.print("property ");
            w.print(event.getPropertyName());
            w.print(" changed from ");
            w.print(event.getOldValue());
            w.print(" to ");
            w.print(event.getNewValue());
            w.println();
        }
    }

    public static void traceMemoryUsage() {
        Debug.traceMemoryUsage(null);
    }

    public static void traceMemoryUsage(String label) {
        if (Debug.isEnabled()) {
            String message = Debug.createMemoryUsageMessage(label);
            PrintWriter w = Debug.getWriter();
            w.print(_tracePrefix);
            w.println(message);
            Debug.log(message);
        }
    }

    private static String createMemoryUsageMessage(String label) {
        StringBuffer sb = new StringBuffer(128);
        long freeMem = Runtime.getRuntime().freeMemory();
        long totalMem = Runtime.getRuntime().totalMemory();
        long usedMem = totalMem - freeMem;
        float accuracy = 0.1f;
        float mbFactor = 1.0f / accuracy * 9.536743E-7f;
        sb.append("total memory: ");
        sb.append(accuracy * (float)Math.round(mbFactor * (float)totalMem));
        sb.append(" MB, in use: ");
        sb.append(accuracy * (float)Math.round(mbFactor * (float)usedMem));
        sb.append(" MB");
        if (label != null) {
            sb.append(": label <");
            sb.append(label);
            sb.append(">");
        }
        return sb.toString();
    }

    public static void traceMethodNotImplemented(Class clazz, String methodName) {
        if (Debug.isEnabled()) {
            PrintWriter w = Debug.getWriter();
            w.print(_tracePrefix);
            w.print("Method not implemented: ");
            if (methodName != null) {
                if (clazz != null) {
                    w.print(clazz.getName());
                } else {
                    w.print("<unknown class>");
                }
                w.print(".");
                w.print(methodName);
                w.print("()");
                w.println();
            }
        }
    }

    public static void assertTrue(boolean condition) throws AssertionFailure {
        if (Debug.isEnabled() && !condition) {
            Debug.handleAssertionFailed(null);
        }
    }

    public static void assertTrue(boolean condition, String message) throws AssertionFailure {
        if (Debug.isEnabled() && !condition) {
            Debug.handleAssertionFailed(message);
        }
    }

    public static void assertNotNull(Object object) throws AssertionFailure {
        if (Debug.isEnabled() && object == null) {
            Debug.handleAssertionFailed("Object is null.");
        }
    }

    public static void assertNotNullOrEmpty(String string) throws AssertionFailure {
        if (Debug.isEnabled() && (string == null || string.length() < 1)) {
            Debug.handleAssertionFailed("String is null or empty.");
        }
    }

    protected static void log(String message) {
        if (Debug.isEnabled() && Debug.isLogging()) {
            if (_logger == null) {
                _logger = BeamLogManager.getSystemLogger();
            }
            _logger.finest(message);
        }
    }

    protected static void log(Throwable exception) {
        if (Debug.isEnabled() && Debug.isLogging()) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            Debug.log(stringWriter.getBuffer().toString());
        }
    }

    private static void handleAssertionFailed(String message) throws AssertionFailure {
        if (Debug.isEnabled()) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.print(_tracePrefix);
                printWriter.print("assertion failed: ");
                if (message != null) {
                    printWriter.print(message);
                    printWriter.print(": ");
                }
                printWriter.println();
                e.printStackTrace(printWriter);
                String messageToTrace = stringWriter.getBuffer().toString();
                printWriter.close();
                printWriter = null;
                stringWriter = null;
                PrintWriter w = Debug.getWriter();
                w.print(messageToTrace);
                Debug.log(messageToTrace);
                throw new AssertionFailure(message);
            }
        }
    }

    private static PrintWriter createPrintWriter(Writer writer) {
        return new PrintWriter(writer, true);
    }

    private static PrintWriter createPrintWriter(OutputStream stream) {
        return Debug.createPrintWriter(new OutputStreamWriter(stream));
    }

    protected Debug() {
    }

    public static void trace(String name, double[][] v) {
        int m = v.length;
        StringBuffer sb = new StringBuffer(m * 8 + 8);
        int i = 0;
        while (i < m) {
            sb.setLength(0);
            sb.append(name);
            sb.append("[");
            sb.append(i);
            sb.append("] = {");
            int n = v[i].length;
            int j = 0;
            while (j < n) {
                if (j > 0) {
                    sb.append(", ");
                }
                sb.append(v[i][j]);
                ++j;
            }
            sb.append("}");
            Debug.trace(sb.toString());
            ++i;
        }
    }

    public static void trace(String name, double[] v) {
        int n = v.length;
        StringBuffer sb = new StringBuffer(n * 8 + 8);
        sb.append(name);
        sb.append(" = {");
        int i = 0;
        while (i < n) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(v[i]);
            ++i;
        }
        sb.append("}");
        Debug.trace(sb.toString());
    }
}

