/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.grender.support.BufferedImageRendering;
import com.vividsolutions.jts.geom.Geometry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.media.jai.PlanarImage;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.BitmaskDef;
import org.esa.beam.framework.datamodel.ColorPaletteDef;
import org.esa.beam.framework.datamodel.DensityPlot;
import org.esa.beam.framework.datamodel.FlagCoding;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.ImageInfo;
import org.esa.beam.framework.datamodel.IndexCoding;
import org.esa.beam.framework.datamodel.Mask;
import org.esa.beam.framework.datamodel.MetadataAttribute;
import org.esa.beam.framework.datamodel.MetadataElement;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.datamodel.ProductNodeGroup;
import org.esa.beam.framework.datamodel.ProductVisitorAdapter;
import org.esa.beam.framework.datamodel.RGBChannelDef;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.TiePointGrid;
import org.esa.beam.framework.datamodel.VectorDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.maptransf.MapInfo;
import org.esa.beam.framework.dataop.maptransf.MapProjection;
import org.esa.beam.framework.dataop.maptransf.MapTransform;
import org.esa.beam.glayer.MaskLayerType;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Debug;
import org.esa.beam.util.FeatureUtils;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.IntMap;
import org.esa.beam.util.geotiff.GeoCoding2GeoTIFFMetadata;
import org.esa.beam.util.geotiff.GeoTIFFMetadata;
import org.esa.beam.util.jai.JAIUtils;
import org.esa.beam.util.math.IndexValidator;
import org.esa.beam.util.math.MathUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ProductUtils {
    private static final int[] RGB_BAND_OFFSETS;
    private static final int[] RGBA_BAND_OFFSETS;
    private static final String MSG_CREATING_IMAGE = "Creating image";

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 1;
        RGB_BAND_OFFSETS = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 3;
        nArray2[1] = 2;
        nArray2[2] = 1;
        RGBA_BAND_OFFSETS = nArray2;
    }

    public static ImageInfo createImageInfo(RasterDataNode[] rasters, boolean assignMissingImageInfos, ProgressMonitor pm) throws IOException {
        Assert.notNull(rasters, "rasters");
        Assert.argument(rasters.length == 1 || rasters.length == 3, "rasters.length == 1 || rasters.length == 3");
        if (rasters.length == 1) {
            return assignMissingImageInfos ? rasters[0].getImageInfo(pm) : rasters[0].createDefaultImageInfo(null, pm);
        }
        try {
            pm.beginTask("Computing image information", 3);
            RGBChannelDef rgbChannelDef = new RGBChannelDef();
            int i = 0;
            while (i < rasters.length) {
                RasterDataNode raster = rasters[i];
                ProgressMonitor subPm = SubProgressMonitor.create(pm, 1);
                ImageInfo imageInfo = assignMissingImageInfos ? raster.getImageInfo(subPm) : raster.createDefaultImageInfo(null, subPm);
                rgbChannelDef.setSourceName(i, raster.getName());
                rgbChannelDef.setMinDisplaySample(i, imageInfo.getColorPaletteDef().getMinDisplaySample());
                rgbChannelDef.setMaxDisplaySample(i, imageInfo.getColorPaletteDef().getMaxDisplaySample());
                ++i;
            }
            ImageInfo imageInfo = new ImageInfo(rgbChannelDef);
            return imageInfo;
        }
        finally {
            pm.done();
        }
    }

    public static BufferedImage createRgbImage(RasterDataNode[] rasters, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull(rasters, "rasters");
        Assert.argument(rasters.length == 1 || rasters.length == 3, "rasters.length == 1 || rasters.length == 3");
        RasterDataNode raster0 = rasters[0];
        ProductNodeGroup<Mask> maskGroup = raster0.getOverlayMaskGroup();
        pm.beginTask(MSG_CREATING_IMAGE, 6 + maskGroup.getNodeCount());
        try {
            BufferedImage overlayBIm = rasters.length == 1 ? ProductUtils.create1BandRgbImage(raster0, imageInfo, SubProgressMonitor.create(pm, 3)) : ProductUtils.create3BandRgbImage(rasters, imageInfo, SubProgressMonitor.create(pm, 3));
            if (maskGroup.getNodeCount() > 0) {
                overlayBIm = ProductUtils.overlayMasks(raster0, overlayBIm, SubProgressMonitor.create(pm, maskGroup.getNodeCount()));
            }
            BufferedImage bufferedImage = overlayBIm;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    private static BufferedImage create1BandRgbImage(final RasterDataNode raster, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull(raster, "raster");
        Assert.notNull(imageInfo, "imageInfo");
        Assert.argument(imageInfo.getColorPaletteDef() != null, "imageInfo.getColorPaletteDef() != null");
        Assert.notNull(pm, "pm");
        IndexCoding indexCoding = raster instanceof Band ? ((Band)raster).getIndexCoding() : null;
        int width = raster.getSceneRasterWidth();
        int height = raster.getSceneRasterHeight();
        int numPixels = width * height;
        final int numColorComponents = imageInfo.getColorComponentCount();
        final byte[] rgbSamples = new byte[numColorComponents * numPixels];
        double minSample = imageInfo.getColorPaletteDef().getMinDisplaySample();
        double maxSample = imageInfo.getColorPaletteDef().getMaxDisplaySample();
        pm.beginTask(MSG_CREATING_IMAGE, 100);
        try {
            Color[] palette;
            IndexValidator indexValidator;
            if (indexCoding == null) {
                raster.quantizeRasterData(minSample, maxSample, 1.0, rgbSamples, 0, numColorComponents, ProgressMonitor.NULL);
                indexValidator = new IndexValidator(){

                    @Override
                    public boolean validateIndex(int pixelIndex) {
                        return raster.isPixelValid(pixelIndex);
                    }
                };
                palette = ImageManager.createColorPalette(raster.getImageInfo());
                pm.worked(50);
                ProductUtils.checkCanceled(pm);
            } else {
                IntMap sampleColorIndexMap = new IntMap((int)minSample - 1, 4098);
                ColorPaletteDef.Point[] points = imageInfo.getColorPaletteDef().getPoints();
                int colorIndex = 0;
                while (colorIndex < points.length) {
                    sampleColorIndexMap.putValue((int)points[colorIndex].getSample(), colorIndex);
                    ++colorIndex;
                }
                final int noDataIndex = points.length < 255 ? points.length + 1 : 0;
                ProductData data = raster.getSceneRasterData();
                int pixelIndex = 0;
                while (pixelIndex < data.getNumElems()) {
                    int sample = data.getElemIntAt(pixelIndex);
                    int colorIndex2 = sampleColorIndexMap.getValue(sample);
                    rgbSamples[pixelIndex * numColorComponents] = colorIndex2 != Integer.MIN_VALUE ? (byte)colorIndex2 : (byte)noDataIndex;
                    ++pixelIndex;
                }
                palette = raster.getImageInfo().getColors();
                if (noDataIndex > 0) {
                    palette = Arrays.copyOf(palette, palette.length + 1);
                    palette[palette.length - 1] = ImageInfo.NO_COLOR;
                }
                indexValidator = new IndexValidator(){

                    @Override
                    public boolean validateIndex(int pixelIndex) {
                        return raster.isPixelValid(pixelIndex) && (noDataIndex == 0 || (rgbSamples[pixelIndex * numColorComponents] & 0xFF) != noDataIndex);
                    }
                };
                pm.worked(50);
                ProductUtils.checkCanceled(pm);
            }
            ProductUtils.convertPaletteToRgbSamples(palette, imageInfo.getNoDataColor(), numColorComponents, rgbSamples, indexValidator);
            pm.worked(40);
            ProductUtils.checkCanceled(pm);
            BufferedImage image = ProductUtils.createBufferedImage(imageInfo, width, height, rgbSamples);
            image = ProductUtils.applyHistogramMatching(image, imageInfo.getHistogramMatching());
            pm.worked(10);
            ProductUtils.checkCanceled(pm);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    private static void convertPaletteToRgbSamples(Color[] palette, Color noDataColor, int numColorComponents, byte[] rgbSamples, IndexValidator indexValidator) {
        byte[] r = new byte[palette.length];
        byte[] g = new byte[palette.length];
        byte[] b = new byte[palette.length];
        byte[] a = new byte[palette.length];
        int i = 0;
        while (i < palette.length) {
            r[i] = (byte)palette[i].getRed();
            g[i] = (byte)palette[i].getGreen();
            b[i] = (byte)palette[i].getBlue();
            a[i] = (byte)palette[i].getAlpha();
            ++i;
        }
        int pixelIndex = 0;
        int i2 = 0;
        while (i2 < rgbSamples.length) {
            if (indexValidator.validateIndex(pixelIndex)) {
                int colorIndex = rgbSamples[i2] & 0xFF;
                if (numColorComponents == 4) {
                    rgbSamples[i2] = a[colorIndex];
                    rgbSamples[i2 + 1] = b[colorIndex];
                    rgbSamples[i2 + 2] = g[colorIndex];
                    rgbSamples[i2 + 3] = r[colorIndex];
                } else {
                    rgbSamples[i2] = b[colorIndex];
                    rgbSamples[i2 + 1] = g[colorIndex];
                    rgbSamples[i2 + 2] = r[colorIndex];
                }
            } else if (numColorComponents == 4) {
                rgbSamples[i2] = (byte)noDataColor.getAlpha();
                rgbSamples[i2 + 1] = (byte)noDataColor.getBlue();
                rgbSamples[i2 + 2] = (byte)noDataColor.getGreen();
                rgbSamples[i2 + 3] = (byte)noDataColor.getRed();
            } else {
                rgbSamples[i2] = (byte)noDataColor.getBlue();
                rgbSamples[i2 + 1] = (byte)noDataColor.getGreen();
                rgbSamples[i2 + 2] = (byte)noDataColor.getRed();
            }
            ++pixelIndex;
            i2 += numColorComponents;
        }
    }

    private static BufferedImage create3BandRgbImage(RasterDataNode[] rasters, ImageInfo imageInfo, ProgressMonitor pm) throws IOException {
        Assert.notNull(rasters, "rasters");
        Assert.argument(rasters.length == 3, "rasters.length == 3");
        Assert.notNull(imageInfo, "imageInfo");
        Assert.argument(imageInfo.getRgbChannelDef() != null, "imageInfo.getRgbChannelDef() != null");
        Assert.notNull(pm, "pm");
        Color noDataColor = imageInfo.getNoDataColor();
        int width = rasters[0].getSceneRasterWidth();
        int height = rasters[0].getSceneRasterHeight();
        int numColorComponents = imageInfo.getColorComponentCount();
        int numPixels = width * height;
        byte[] rgbSamples = new byte[numColorComponents * numPixels];
        String[] taskMessages = new String[]{"Computing red channel", "Computing green channel", "Computing blue channel"};
        pm.beginTask(MSG_CREATING_IMAGE, 100);
        try {
            int i = 0;
            while (i < rasters.length) {
                RasterDataNode raster = rasters[i];
                pm.setSubTaskName(taskMessages[i]);
                raster.quantizeRasterData(imageInfo.getRgbChannelDef().getMinDisplaySample(i), imageInfo.getRgbChannelDef().getMaxDisplaySample(i), imageInfo.getRgbChannelDef().getGamma(i), rgbSamples, numColorComponents - 1 - i, numColorComponents, ProgressMonitor.NULL);
                pm.worked(30);
                ProductUtils.checkCanceled(pm);
                ++i;
            }
            boolean validMaskUsed = rasters[0].isValidMaskUsed() || rasters[1].isValidMaskUsed() || rasters[2].isValidMaskUsed();
            int pixelIndex = 0;
            int i2 = 0;
            while (i2 < rgbSamples.length) {
                boolean pixelValid;
                boolean bl = pixelValid = !validMaskUsed || rasters[0].isPixelValid(pixelIndex) && rasters[1].isPixelValid(pixelIndex) && rasters[2].isPixelValid(pixelIndex);
                if (pixelValid) {
                    if (numColorComponents == 4) {
                        rgbSamples[i2] = -1;
                    }
                } else if (numColorComponents == 4) {
                    rgbSamples[i2] = (byte)noDataColor.getAlpha();
                    rgbSamples[i2 + 1] = (byte)noDataColor.getBlue();
                    rgbSamples[i2 + 2] = (byte)noDataColor.getGreen();
                    rgbSamples[i2 + 3] = (byte)noDataColor.getRed();
                } else {
                    rgbSamples[i2] = (byte)noDataColor.getBlue();
                    rgbSamples[i2 + 1] = (byte)noDataColor.getGreen();
                    rgbSamples[i2 + 2] = (byte)noDataColor.getRed();
                }
                ++pixelIndex;
                i2 += numColorComponents;
            }
            pm.worked(5);
            ProductUtils.checkCanceled(pm);
            BufferedImage image = ProductUtils.createBufferedImage(imageInfo, width, height, rgbSamples);
            image = ProductUtils.applyHistogramMatching(image, imageInfo.getHistogramMatching());
            pm.worked(5);
            ProductUtils.checkCanceled(pm);
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        finally {
            pm.done();
        }
    }

    private static BufferedImage createBufferedImage(ImageInfo imageInfo, int width, int height, byte[] rgbSamples) {
        int colorComponentCount;
        ComponentColorModel cm = imageInfo.createComponentColorModel();
        DataBufferByte db = new DataBufferByte(rgbSamples, rgbSamples.length);
        WritableRaster wr = Raster.createInterleavedRaster(db, width, height, colorComponentCount * width, colorComponentCount, (colorComponentCount = imageInfo.getColorComponentCount()) == 4 ? RGBA_BAND_OFFSETS : RGB_BAND_OFFSETS, null);
        return new BufferedImage(cm, wr, false, null);
    }

    public static BufferedImage createColorIndexedImage(RasterDataNode rasterDataNode, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("rasterDataNode", rasterDataNode);
        int width = rasterDataNode.getSceneRasterWidth();
        int height = rasterDataNode.getSceneRasterHeight();
        ImageInfo imageInfo = rasterDataNode.getImageInfo(ProgressMonitor.NULL);
        double newMin = imageInfo.getColorPaletteDef().getMinDisplaySample();
        double newMax = imageInfo.getColorPaletteDef().getMaxDisplaySample();
        byte[] colorIndexes = rasterDataNode.quantizeRasterData(newMin, newMax, 1.0, pm);
        IndexColorModel cm = imageInfo.createIndexColorModel(rasterDataNode);
        SampleModel sm = cm.createCompatibleSampleModel(width, height);
        DataBufferByte db = new DataBufferByte(colorIndexes, colorIndexes.length);
        WritableRaster wr = WritableRaster.createWritableRaster(sm, db, null);
        return new BufferedImage(cm, wr, false, null);
    }

    private static BufferedImage applyHistogramMatching(BufferedImage overlayBIm, ImageInfo.HistogramMatching histogramMatching) {
        boolean doNormalize;
        boolean doEqualize = ImageInfo.HistogramMatching.Equalize == histogramMatching;
        boolean bl = doNormalize = ImageInfo.HistogramMatching.Normalize == histogramMatching;
        if (doEqualize || doNormalize) {
            PlanarImage sourcePIm = PlanarImage.wrapRenderedImage(overlayBIm);
            sourcePIm = JAIUtils.createTileFormatOp(sourcePIm, 512, 512);
            sourcePIm = doEqualize ? JAIUtils.createHistogramEqualizedImage(sourcePIm) : JAIUtils.createHistogramNormalizedImage(sourcePIm);
            overlayBIm = sourcePIm.getAsBufferedImage();
        }
        return overlayBIm;
    }

    private static void checkCanceled(ProgressMonitor pm) throws IOException {
        if (pm.isCanceled()) {
            throw new IOException("Process terminated by user.");
        }
    }

    public static MapInfo createSuitableMapInfo(Product product, Rectangle rect, MapProjection mapProjection) {
        double mapH;
        Guardian.assertNotNull("product", product);
        Guardian.assertNotNull("mapProjection", mapProjection);
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        int sourceW = product.getSceneRasterWidth();
        int sourceH = product.getSceneRasterHeight();
        MapTransform mapTransform = mapProjection.getMapTransform();
        Point2D[] envelope = ProductUtils.createMapEnvelope(product, rect, mapTransform);
        double mapW = Math.abs(envelope[1].getX() - envelope[0].getX());
        float pixelSize = (float)Math.min(mapW / (double)sourceW, (mapH = Math.abs(envelope[1].getY() - envelope[0].getY())) / (double)sourceH);
        if (MathUtils.equalValues(pixelSize, 0.0f)) {
            pixelSize = 1.0f;
        }
        int targetW = 1 + (int)Math.floor(mapW / (double)pixelSize);
        int targetH = 1 + (int)Math.floor(mapH / (double)pixelSize);
        float easting = (float)envelope[0].getX();
        float northing = (float)envelope[1].getY();
        MapInfo mapInfo = new MapInfo(mapProjection, 0.5f, 0.5f, easting, northing, pixelSize, pixelSize, gc.getDatum());
        mapInfo.setSceneSizeFitted(true);
        mapInfo.setSceneWidth(targetW);
        mapInfo.setSceneHeight(targetH);
        mapInfo.setNoDataValue(9999.0);
        return mapInfo;
    }

    @Deprecated
    public static MapInfo createSuitableMapInfo(Product product, MapProjection mapProjection, double orientation, double noDataValue) {
        double mapH;
        Guardian.assertNotNull("product", product);
        Guardian.assertNotNull("mapProjection", mapProjection);
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        int sourceW = product.getSceneRasterWidth();
        int sourceH = product.getSceneRasterHeight();
        MapTransform mapTransform = mapProjection.getMapTransform();
        Point2D[] envelope = ProductUtils.createMapEnvelope(product, new Rectangle(sourceW, sourceH), mapTransform);
        Point2D pMin = envelope[0];
        Point2D pMax = envelope[1];
        double mapW = pMax.getX() - pMin.getX();
        float pixelSize = (float)Math.min(mapW / (double)sourceW, (mapH = pMax.getY() - pMin.getY()) / (double)sourceH);
        if (MathUtils.equalValues(pixelSize, 0.0f)) {
            pixelSize = 1.0f;
        }
        int targetW = 1 + (int)Math.floor(mapW / (double)pixelSize);
        int targetH = 1 + (int)Math.floor(mapH / (double)pixelSize);
        float pixelX = 0.5f * (float)targetW;
        float pixelY = 0.5f * (float)targetH;
        float easting = (float)pMin.getX() + pixelX * pixelSize;
        float northing = (float)pMax.getY() - pixelY * pixelSize;
        MapInfo mapInfo = new MapInfo(mapProjection, pixelX, pixelY, easting, northing, pixelSize, pixelSize, gc.getDatum());
        mapInfo.setOrientation((float)orientation);
        mapInfo.setSceneSizeFitted(true);
        mapInfo.setSceneWidth(targetW);
        mapInfo.setSceneHeight(targetH);
        mapInfo.setNoDataValue(noDataValue);
        return mapInfo;
    }

    public static Dimension getOutputRasterSize(Product product, Rectangle rect, MapTransform mapTransform, double pixelSizeX, double pixelSizeY) {
        Point2D[] envelope = ProductUtils.createMapEnvelope(product, rect, mapTransform);
        double mapW = envelope[1].getX() - envelope[0].getX();
        double mapH = envelope[1].getY() - envelope[0].getY();
        return new Dimension(1 + (int)Math.floor(mapW / pixelSizeX), 1 + (int)Math.floor(mapH / pixelSizeY));
    }

    public static Point2D[] createMapEnvelope(Product product, Rectangle rect, MapTransform mapTransform) {
        int step = Math.min(product.getSceneRasterWidth(), product.getSceneRasterHeight()) / 2;
        return ProductUtils.createMapEnvelope(product, rect, step, mapTransform);
    }

    public static Point2D[] createMapEnvelope(Product product, Rectangle rect, int step, MapTransform mapTransform) {
        Point2D[] boundary = ProductUtils.createMapBoundary(product, rect, step, mapTransform);
        return ProductUtils.getMinMax(boundary);
    }

    public static Point2D[] getMinMax(Point2D[] boundary) {
        Point2D.Float min = new Point2D.Float();
        Point2D.Float max = new Point2D.Float();
        min.x = Float.MAX_VALUE;
        min.y = Float.MAX_VALUE;
        max.x = -3.4028235E38f;
        max.y = -3.4028235E38f;
        Point2D[] point2DArray = boundary;
        int n = boundary.length;
        int n2 = 0;
        while (n2 < n) {
            Point2D point = point2DArray[n2];
            min.x = Math.min(min.x, (float)point.getX());
            min.y = Math.min(min.y, (float)point.getY());
            max.x = Math.max(max.x, (float)point.getX());
            max.y = Math.max(max.y, (float)point.getY());
            ++n2;
        }
        return new Point2D[]{min, max};
    }

    public static Point2D[] createMapBoundary(Product product, Rectangle rect, int step, MapTransform mapTransform) {
        GeoPos[] geoPoints = ProductUtils.createGeoBoundary(product, rect, step);
        ProductUtils.normalizeGeoPolygon(geoPoints);
        Point2D[] mapPoints = new Point2D[geoPoints.length];
        int i = 0;
        while (i < geoPoints.length) {
            mapPoints[i] = mapTransform.forward(geoPoints[i], new Point2D.Float());
            ++i;
        }
        return mapPoints;
    }

    public static GeoPos[] createGeoBoundary(Product product, int step) {
        Rectangle rect = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        return ProductUtils.createGeoBoundary(product, rect, step);
    }

    public static GeoPos[] createGeoBoundary(Product product, Rectangle region, int step) {
        return ProductUtils.createGeoBoundary(product, region, step, true);
    }

    public static GeoPos[] createGeoBoundary(Product product, Rectangle region, int step, boolean usePixelCenter) {
        Guardian.assertNotNull("product", product);
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        if (region == null) {
            region = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        }
        PixelPos[] points = ProductUtils.createRectBoundary(region, step, usePixelCenter);
        ArrayList<GeoPos> geoPoints = new ArrayList<GeoPos>(points.length);
        PixelPos[] pixelPosArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            PixelPos pixelPos = pixelPosArray[n2];
            GeoPos gcGeoPos = gc.getGeoPos(pixelPos, null);
            geoPoints.add(gcGeoPos);
            ++n2;
        }
        return geoPoints.toArray(new GeoPos[geoPoints.size()]);
    }

    public static GeoPos[] createGeoBoundary(RasterDataNode raster, Rectangle region, int step) {
        Guardian.assertNotNull("raster", raster);
        GeoCoding gc = raster.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        PixelPos[] points = ProductUtils.createPixelBoundary(raster, region, step);
        GeoPos[] geoPoints = new GeoPos[points.length];
        int i = 0;
        while (i < geoPoints.length) {
            geoPoints[i] = gc.getGeoPos(points[i], null);
            ++i;
        }
        return geoPoints;
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product) {
        Rectangle rect = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        int step = Math.min(rect.width, rect.height) / 8;
        return ProductUtils.createGeoBoundaryPaths(product, rect, step > 0 ? step : 1);
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product, Rectangle region, int step) {
        return ProductUtils.createGeoBoundaryPaths(product, region, step, true);
    }

    public static GeneralPath[] createGeoBoundaryPaths(Product product, Rectangle region, int step, boolean usePixelCenter) {
        Guardian.assertNotNull("product", product);
        GeoCoding gc = product.getGeoCoding();
        if (gc == null) {
            throw new IllegalArgumentException("Product without geo-coding.");
        }
        GeoPos[] geoPoints = ProductUtils.createGeoBoundary(product, region, step, usePixelCenter);
        ProductUtils.normalizeGeoPolygon(geoPoints);
        ArrayList<GeneralPath> pathList = ProductUtils.assemblePathList(geoPoints);
        return pathList.toArray(new GeneralPath[pathList.size()]);
    }

    public static PixelPos[] createPixelBoundary(Product product, Rectangle rect, int step) {
        return ProductUtils.createPixelBoundary(product, rect, step, true);
    }

    public static PixelPos[] createPixelBoundary(Product product, Rectangle rect, int step, boolean usePixelCenter) {
        if (rect == null) {
            rect = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        }
        return ProductUtils.createRectBoundary(rect, step, usePixelCenter);
    }

    public static PixelPos[] createPixelBoundary(RasterDataNode raster, Rectangle rect, int step) {
        if (rect == null) {
            rect = new Rectangle(0, 0, raster.getSceneRasterWidth(), raster.getSceneRasterHeight());
        }
        return ProductUtils.createRectBoundary(rect, step);
    }

    public static PixelPos[] createRectBoundary(Rectangle rect, int step) {
        return ProductUtils.createRectBoundary(rect, step, true);
    }

    public static PixelPos[] createRectBoundary(Rectangle rect, int step, boolean usePixelCenter) {
        float insetDistance = usePixelCenter ? 0.5f : 0.0f;
        int x1 = rect.x;
        int y1 = rect.y;
        int w = usePixelCenter ? rect.width - 1 : rect.width;
        int h = usePixelCenter ? rect.height - 1 : rect.height;
        int x2 = x1 + w;
        int y2 = y1 + h;
        if (step <= 0) {
            step = 2 * Math.max(rect.width, rect.height);
        }
        ArrayList<PixelPos> pixelPosList = new ArrayList<PixelPos>(2 * (rect.width + rect.height) / step + 10);
        int lastX = 0;
        int x = x1;
        while (x < x2) {
            pixelPosList.add(new PixelPos((float)x + insetDistance, (float)y1 + insetDistance));
            lastX = x;
            x += step;
        }
        int lastY = 0;
        int y = y1;
        while (y < y2) {
            pixelPosList.add(new PixelPos((float)x2 + insetDistance, (float)y + insetDistance));
            lastY = y;
            y += step;
        }
        pixelPosList.add(new PixelPos((float)x2 + insetDistance, (float)y2 + insetDistance));
        int x3 = lastX;
        while (x3 > x1) {
            pixelPosList.add(new PixelPos((float)x3 + insetDistance, (float)y2 + insetDistance));
            x3 -= step;
        }
        pixelPosList.add(new PixelPos((float)x1 + insetDistance, (float)y2 + insetDistance));
        y = lastY;
        while (y > y1) {
            pixelPosList.add(new PixelPos((float)x1 + insetDistance, (float)y + insetDistance));
            y -= step;
        }
        return pixelPosList.toArray(new PixelPos[pixelPosList.size()]);
    }

    public static void copyFlagCodings(Product source, Product target) {
        Guardian.assertNotNull("source", source);
        Guardian.assertNotNull("target", target);
        int numCodings = source.getFlagCodingGroup().getNodeCount();
        int n = 0;
        while (n < numCodings) {
            FlagCoding sourceFlagCoding = source.getFlagCodingGroup().get(n);
            ProductUtils.copyFlagCoding(sourceFlagCoding, target);
            ++n;
        }
    }

    public static FlagCoding copyFlagCoding(FlagCoding sourceFlagCoding, Product target) {
        FlagCoding flagCoding = target.getFlagCodingGroup().get(sourceFlagCoding.getName());
        if (flagCoding == null) {
            flagCoding = new FlagCoding(sourceFlagCoding.getName());
            flagCoding.setDescription(sourceFlagCoding.getDescription());
            target.getFlagCodingGroup().add(flagCoding);
            ProductUtils.copyMetadata(sourceFlagCoding, flagCoding);
        }
        return flagCoding;
    }

    public static void copyIndexCodings(Product source, Product target) {
        Guardian.assertNotNull("source", source);
        Guardian.assertNotNull("target", target);
        int numCodings = source.getIndexCodingGroup().getNodeCount();
        int n = 0;
        while (n < numCodings) {
            IndexCoding sourceFlagCoding = source.getIndexCodingGroup().get(n);
            ProductUtils.copyIndexCoding(sourceFlagCoding, target);
            ++n;
        }
    }

    public static IndexCoding copyIndexCoding(IndexCoding sourceIndexCoding, Product target) {
        IndexCoding indexCoding = target.getIndexCodingGroup().get(sourceIndexCoding.getName());
        if (indexCoding == null) {
            indexCoding = new IndexCoding(sourceIndexCoding.getName());
            indexCoding.setDescription(sourceIndexCoding.getDescription());
            target.getIndexCodingGroup().add(indexCoding);
            ProductUtils.copyMetadata(sourceIndexCoding, indexCoding);
        }
        return indexCoding;
    }

    public static void copyMasks(Product sourceProduct, Product targetProduct) {
        ProductNodeGroup<Mask> sourceMaskGroup = sourceProduct.getMaskGroup();
        int i = 0;
        while (i < sourceMaskGroup.getNodeCount()) {
            Mask mask = sourceMaskGroup.get(i);
            if (!targetProduct.getMaskGroup().contains(mask.getName()) && mask.getImageType().canTransferMask(mask, targetProduct)) {
                mask.getImageType().transferMask(mask, targetProduct);
            }
            ++i;
        }
    }

    public static void copyOverlayMasks(Product sourceProduct, Product targetProduct) {
        RasterDataNode sourceNode;
        RasterDataNode[] rasterDataNodeArray = sourceProduct.getTiePointGrids();
        int n = rasterDataNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            sourceNode = rasterDataNodeArray[n2];
            ProductUtils.copyOverlayMasks(sourceNode, targetProduct);
            ++n2;
        }
        rasterDataNodeArray = sourceProduct.getBands();
        n = rasterDataNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            sourceNode = rasterDataNodeArray[n2];
            ProductUtils.copyOverlayMasks(sourceNode, targetProduct);
            ++n2;
        }
    }

    @Deprecated
    public static void copyRoiMasks(Product sourceProduct, Product targetProduct) {
        RasterDataNode sourceNode;
        RasterDataNode[] rasterDataNodeArray = sourceProduct.getTiePointGrids();
        int n = rasterDataNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            sourceNode = rasterDataNodeArray[n2];
            ProductUtils.copyRoiMasks(sourceNode, targetProduct);
            ++n2;
        }
        rasterDataNodeArray = sourceProduct.getBands();
        n = rasterDataNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            sourceNode = rasterDataNodeArray[n2];
            ProductUtils.copyRoiMasks(sourceNode, targetProduct);
            ++n2;
        }
    }

    private static void copyOverlayMasks(RasterDataNode sourceNode, Product targetProduct) {
        String[] maskNames = sourceNode.getOverlayMaskGroup().getNodeNames();
        RasterDataNode targetNode = targetProduct.getRasterDataNode(sourceNode.getName());
        if (targetNode != null) {
            ProductNodeGroup<Mask> overlayMaskGroup = targetNode.getOverlayMaskGroup();
            ProductNodeGroup<Mask> maskGroup = targetProduct.getMaskGroup();
            ProductUtils.addMasksToGroup(maskNames, maskGroup, overlayMaskGroup);
        }
    }

    @Deprecated
    private static void copyRoiMasks(RasterDataNode sourceNode, Product targetProduct) {
        String[] maskNames = sourceNode.getRoiMaskGroup().getNodeNames();
        RasterDataNode targetNode = targetProduct.getRasterDataNode(sourceNode.getName());
        if (targetNode != null) {
            ProductNodeGroup<Mask> roiMaskGroup = targetNode.getRoiMaskGroup();
            ProductNodeGroup<Mask> maskGroup = targetProduct.getMaskGroup();
            ProductUtils.addMasksToGroup(maskNames, maskGroup, roiMaskGroup);
        }
    }

    private static void addMasksToGroup(String[] maskNames, ProductNodeGroup<Mask> maskGroup, ProductNodeGroup<Mask> specialMaskGroup) {
        String[] stringArray = maskNames;
        int n = maskNames.length;
        int n2 = 0;
        while (n2 < n) {
            String maskName = stringArray[n2];
            Mask mask = maskGroup.get(maskName);
            if (mask != null) {
                specialMaskGroup.add(mask);
            }
            ++n2;
        }
    }

    public static void copyFlagBands(Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("source", sourceProduct);
        Guardian.assertNotNull("target", targetProduct);
        if (sourceProduct.getFlagCodingGroup().getNodeCount() > 0) {
            int i = 0;
            while (i < sourceProduct.getNumBands()) {
                Band sourceBand = sourceProduct.getBandAt(i);
                String bandName = sourceBand.getName();
                if (sourceBand.isFlagBand() && targetProduct.getBand(bandName) == null) {
                    ProductUtils.copyBand(bandName, sourceProduct, targetProduct, copySourceImage);
                }
                ++i;
            }
            ProductUtils.copyMasks(sourceProduct, targetProduct);
            ProductUtils.copyOverlayMasks(sourceProduct, targetProduct);
        }
    }

    @Deprecated
    public static void copyFlagBands(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyFlagBands(sourceProduct, targetProduct, false);
    }

    public static TiePointGrid copyTiePointGrid(String gridName, Product sourceProduct, Product targetProduct) {
        Guardian.assertNotNull("sourceProduct", sourceProduct);
        Guardian.assertNotNull("targetProduct", targetProduct);
        if (gridName == null || gridName.length() == 0) {
            return null;
        }
        TiePointGrid sourceGrid = sourceProduct.getTiePointGrid(gridName);
        if (sourceGrid == null) {
            return null;
        }
        TiePointGrid targetGrid = sourceGrid.cloneTiePointGrid();
        targetProduct.addTiePointGrid(targetGrid);
        return targetGrid;
    }

    public static Band copyBand(String sourceBandName, Product sourceProduct, Product targetProduct, boolean copySourceImage) {
        return ProductUtils.copyBand(sourceBandName, sourceProduct, sourceBandName, targetProduct, copySourceImage);
    }

    public static Band copyBand(String sourceBandName, Product sourceProduct, String targetBandName, Product targetProduct, boolean copySourceImage) {
        Guardian.assertNotNull("sourceProduct", sourceProduct);
        Guardian.assertNotNull("targetProduct", targetProduct);
        if (sourceBandName == null || sourceBandName.length() == 0) {
            return null;
        }
        Band sourceBand = sourceProduct.getBand(sourceBandName);
        if (sourceBand == null) {
            return null;
        }
        Band targetBand = targetProduct.addBand(targetBandName, sourceBand.getDataType());
        ProductUtils.copyRasterDataNodeProperties(sourceBand, targetBand);
        if (copySourceImage) {
            targetBand.setSourceImage(sourceBand.getSourceImage());
        }
        return targetBand;
    }

    public static void copyRasterDataNodeProperties(RasterDataNode sourceRaster, RasterDataNode targetRaster) {
        targetRaster.setDescription(sourceRaster.getDescription());
        targetRaster.setUnit(sourceRaster.getUnit());
        targetRaster.setScalingFactor(sourceRaster.getScalingFactor());
        targetRaster.setScalingOffset(sourceRaster.getScalingOffset());
        targetRaster.setLog10Scaled(sourceRaster.isLog10Scaled());
        targetRaster.setNoDataValueUsed(sourceRaster.isNoDataValueUsed());
        targetRaster.setNoDataValue(sourceRaster.getNoDataValue());
        targetRaster.setValidPixelExpression(sourceRaster.getValidPixelExpression());
        if (sourceRaster instanceof Band && targetRaster instanceof Band) {
            Band sourceBand = (Band)sourceRaster;
            Band targetBand = (Band)targetRaster;
            ProductUtils.copySpectralBandProperties(sourceBand, targetBand);
            Product targetProduct = targetBand.getProduct();
            if (targetProduct == null) {
                return;
            }
            if (sourceBand.getFlagCoding() != null) {
                FlagCoding srcFlagCoding = sourceBand.getFlagCoding();
                ProductUtils.copyFlagCoding(srcFlagCoding, targetProduct);
                targetBand.setSampleCoding(targetProduct.getFlagCodingGroup().get(srcFlagCoding.getName()));
            }
            if (sourceBand.getIndexCoding() != null) {
                IndexCoding srcIndexCoding = sourceBand.getIndexCoding();
                ProductUtils.copyIndexCoding(srcIndexCoding, targetProduct);
                targetBand.setSampleCoding(targetProduct.getIndexCodingGroup().get(srcIndexCoding.getName()));
                ImageInfo imageInfo = sourceBand.getImageInfo();
                if (imageInfo != null) {
                    targetBand.setImageInfo(imageInfo.clone());
                }
            }
        }
    }

    @Deprecated
    public static Band copyBand(String sourceBandName, Product sourceProduct, Product targetProduct) {
        return ProductUtils.copyBand(sourceBandName, sourceProduct, sourceBandName, targetProduct, false);
    }

    @Deprecated
    public static Band copyBand(String sourceBandName, Product sourceProduct, String targetBandName, Product targetProduct) {
        return ProductUtils.copyBand(sourceBandName, sourceProduct, targetBandName, targetProduct, false);
    }

    public static void copySpectralBandProperties(Band sourceBand, Band targetBand) {
        Guardian.assertNotNull("source", sourceBand);
        Guardian.assertNotNull("target", targetBand);
        targetBand.setSpectralBandIndex(sourceBand.getSpectralBandIndex());
        targetBand.setSpectralWavelength(sourceBand.getSpectralWavelength());
        targetBand.setSpectralBandwidth(sourceBand.getSpectralBandwidth());
        targetBand.setSolarFlux(sourceBand.getSolarFlux());
    }

    public static void copyProductNodes(Product sourceProduct, Product targetProduct) {
        ProductUtils.copyMetadata(sourceProduct, targetProduct);
        ProductUtils.copyTiePointGrids(sourceProduct, targetProduct);
        ProductUtils.copyFlagCodings(sourceProduct, targetProduct);
        ProductUtils.copyGeoCoding(sourceProduct, targetProduct);
        ProductUtils.copyMasks(sourceProduct, targetProduct);
        ProductUtils.copyVectorData(sourceProduct, targetProduct);
        ProductUtils.copyIndexCodings(sourceProduct, targetProduct);
        targetProduct.setStartTime(sourceProduct.getStartTime());
        targetProduct.setEndTime(sourceProduct.getEndTime());
        targetProduct.setDescription(sourceProduct.getDescription());
    }

    public static void copyGeoCoding(Product sourceProduct, Product targetProduct) {
        Guardian.assertNotNull("sourceProduct", sourceProduct);
        Guardian.assertNotNull("targetProduct", targetProduct);
        sourceProduct.transferGeoCodingTo(targetProduct, null);
    }

    public static void copyTiePointGrids(Product sourceProduct, Product targetProduct) {
        int i = 0;
        while (i < sourceProduct.getNumTiePointGrids()) {
            TiePointGrid srcTPG = sourceProduct.getTiePointGridAt(i);
            targetProduct.addTiePointGrid(srcTPG.cloneTiePointGrid());
            ++i;
        }
    }

    public static void copyVectorData(Product sourceProduct, Product targetProduct) {
        VectorDataNode sourceVDN;
        ProductNodeGroup<VectorDataNode> vectorDataGroup = sourceProduct.getVectorDataGroup();
        boolean allPermanentAndEmpty = true;
        int i = 0;
        while (i < vectorDataGroup.getNodeCount()) {
            sourceVDN = vectorDataGroup.get(i);
            if (!sourceVDN.isPermanent() || !sourceVDN.getFeatureCollection().isEmpty()) {
                allPermanentAndEmpty = false;
                break;
            }
            ++i;
        }
        if (allPermanentAndEmpty) {
            return;
        }
        if (sourceProduct.isCompatibleProduct(targetProduct, 0.001f)) {
            i = 0;
            while (i < vectorDataGroup.getNodeCount()) {
                sourceVDN = vectorDataGroup.get(i);
                String name = sourceVDN.getName();
                DefaultFeatureCollection featureCollection = sourceVDN.getFeatureCollection();
                featureCollection = new DefaultFeatureCollection(featureCollection);
                if (!targetProduct.getVectorDataGroup().contains(name)) {
                    targetProduct.getVectorDataGroup().add(new VectorDataNode(name, (SimpleFeatureType)featureCollection.getSchema()));
                }
                VectorDataNode targetVDN = targetProduct.getVectorDataGroup().get(name);
                targetVDN.getFeatureCollection().addAll(featureCollection);
                targetVDN.setDefaultStyleCss(sourceVDN.getDefaultStyleCss());
                targetVDN.setDescription(sourceVDN.getDescription());
                ++i;
            }
        } else {
            Geometry clipGeometry;
            if (sourceProduct.getGeoCoding() == null || targetProduct.getGeoCoding() == null) {
                return;
            }
            try {
                Geometry sourceGeometryWGS84 = FeatureUtils.createGeoBoundaryPolygon(sourceProduct);
                Geometry targetGeometryWGS84 = FeatureUtils.createGeoBoundaryPolygon(targetProduct);
                if (!sourceGeometryWGS84.intersects(targetGeometryWGS84)) {
                    return;
                }
                clipGeometry = sourceGeometryWGS84.intersection(targetGeometryWGS84);
            }
            catch (Exception exception) {
                return;
            }
            CoordinateReferenceSystem srcModelCrs = ImageManager.getModelCrs(sourceProduct.getGeoCoding());
            CoordinateReferenceSystem targetModelCrs = ImageManager.getModelCrs(targetProduct.getGeoCoding());
            int i2 = 0;
            while (i2 < vectorDataGroup.getNodeCount()) {
                VectorDataNode sourceVDN2 = vectorDataGroup.get(i2);
                String name = sourceVDN2.getName();
                FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection = sourceVDN2.getFeatureCollection();
                featureCollection = FeatureUtils.clipCollection(featureCollection, srcModelCrs, clipGeometry, DefaultGeographicCRS.WGS84, null, targetModelCrs, ProgressMonitor.NULL);
                if (!targetProduct.getVectorDataGroup().contains(name)) {
                    targetProduct.getVectorDataGroup().add(new VectorDataNode(name, featureCollection.getSchema()));
                }
                VectorDataNode targetVDN = targetProduct.getVectorDataGroup().get(name);
                targetVDN.getPlacemarkGroup();
                targetVDN.getFeatureCollection().addAll(featureCollection);
                targetVDN.setDefaultStyleCss(sourceVDN2.getDefaultStyleCss());
                targetVDN.setDescription(sourceVDN2.getDescription());
                ++i2;
            }
        }
    }

    public static boolean canGetPixelPos(Product product) {
        return product != null && product.getGeoCoding() != null && product.getGeoCoding().canGetPixelPos();
    }

    public static boolean canGetPixelPos(RasterDataNode raster) {
        return raster != null && raster.getGeoCoding() != null && raster.getGeoCoding().canGetPixelPos();
    }

    public static BufferedImage createDensityPlotImage(RasterDataNode raster1, float sampleMin1, float sampleMax1, RasterDataNode raster2, float sampleMin2, float sampleMax2, Mask roiMask, int width, int height, Color background, BufferedImage image, ProgressMonitor pm) throws IOException {
        Guardian.assertNotNull("raster1", raster1);
        Guardian.assertNotNull("raster2", raster2);
        Guardian.assertNotNull("background", background);
        if (raster1.getSceneRasterWidth() != raster2.getSceneRasterWidth() || raster1.getSceneRasterHeight() != raster2.getSceneRasterHeight()) {
            throw new IllegalArgumentException("'raster1' has not the same size as 'raster2'");
        }
        image = ProductUtils.getCompatibleBufferedImageForDensityPlot(image, width, height, background);
        byte[] pixelValues = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        DensityPlot.accumulate(raster1, sampleMin1, sampleMax1, raster2, sampleMin2, sampleMax2, roiMask, width, height, pixelValues, pm);
        return image;
    }

    private static BufferedImage getCompatibleBufferedImageForDensityPlot(BufferedImage image, int width, int height, Color background) {
        if (image == null || image.getWidth() != width || image.getHeight() != height || !(image.getColorModel() instanceof IndexColorModel) || !(image.getRaster().getDataBuffer() instanceof DataBufferByte)) {
            byte[] r = new byte[256];
            byte[] g = new byte[256];
            byte[] b = new byte[256];
            byte[] a = new byte[256];
            r[0] = (byte)background.getRed();
            g[0] = (byte)background.getGreen();
            b[0] = (byte)background.getBlue();
            a[0] = (byte)background.getAlpha();
            int i = 1;
            while (i < 128) {
                r[i] = (byte)(2 * i);
                g[i] = 0;
                b[i] = 0;
                a[i] = -1;
                ++i;
            }
            i = 128;
            while (i < 256) {
                r[i] = -1;
                g[i] = (byte)(2 * (i - 128));
                b[i] = 0;
                a[i] = -1;
                ++i;
            }
            image = new BufferedImage(width, height, 13, new IndexColorModel(8, 256, r, g, b, a));
        }
        return image;
    }

    public static BufferedImage overlayMasks(RasterDataNode raster, BufferedImage overlayBIm, ProgressMonitor pm) {
        ProductNodeGroup<Mask> maskGroup = raster.getOverlayMaskGroup();
        if (maskGroup.getNodeCount() == 0) {
            return overlayBIm;
        }
        BufferedImageRendering imageRendering = new BufferedImageRendering(overlayBIm);
        pm.beginTask("Creating masks ...", maskGroup.getNodeCount());
        try {
            Mask[] masks;
            Mask[] maskArray = masks = (Mask[])maskGroup.toArray(new Mask[maskGroup.getNodeCount()]);
            int n = masks.length;
            int n2 = 0;
            while (n2 < n) {
                Mask mask = maskArray[n2];
                pm.setSubTaskName(String.format("Applying mask '%s'", mask.getName()));
                Layer layer = MaskLayerType.createLayer(raster, mask);
                layer.render(imageRendering);
                pm.worked(1);
                ++n2;
            }
        }
        finally {
            pm.done();
        }
        return imageRendering.getImage();
    }

    public static GeoPos getCenterGeoPos(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        if (geoCoding != null) {
            PixelPos centerPixelPos = new PixelPos(0.5f * (float)product.getSceneRasterWidth() + 0.5f, 0.5f * (float)product.getSceneRasterHeight() + 0.5f);
            return geoCoding.getGeoPos(centerPixelPos, null);
        }
        return null;
    }

    public static int normalizeGeoPolygon(GeoPos[] polygon) {
        float[] originalLon = new float[polygon.length];
        int i = 0;
        while (i < originalLon.length) {
            originalLon[i] = polygon[i].lon;
            ++i;
        }
        float increment = 0.0f;
        float minLon = Float.MAX_VALUE;
        float maxLon = -3.4028235E38f;
        int i2 = 1;
        while (i2 < polygon.length) {
            GeoPos geoPos = polygon[i2];
            float lonDiff = originalLon[i2] - originalLon[i2 - 1];
            if (lonDiff > 180.0f) {
                increment -= 360.0f;
            } else if (lonDiff < -180.0f) {
                increment += 360.0f;
            }
            geoPos.lon += increment;
            if (geoPos.lon < minLon) {
                minLon = geoPos.lon;
            }
            if (geoPos.lon > maxLon) {
                maxLon = geoPos.lon;
            }
            ++i2;
        }
        int normalized = 0;
        boolean negNormalized = false;
        boolean posNormalized = false;
        if (minLon < -180.0f) {
            posNormalized = true;
        }
        if (maxLon > 180.0f) {
            negNormalized = true;
        }
        if (negNormalized && !posNormalized) {
            normalized = 1;
        } else if (!negNormalized && posNormalized) {
            normalized = -1;
            GeoPos[] geoPosArray = polygon;
            int n = polygon.length;
            int n2 = 0;
            while (n2 < n) {
                GeoPos aPolygon = geoPosArray[n2];
                aPolygon.lon += 360.0f;
                ++n2;
            }
        } else if (negNormalized && posNormalized) {
            normalized = 2;
        }
        return normalized;
    }

    @Deprecated
    public static int normalizeGeoPolygon_old(GeoPos[] polygon) {
        boolean negNormalized = false;
        boolean posNormalized = false;
        int numValues = polygon.length;
        int i = 0;
        while (i < numValues - 1) {
            GeoPos p1 = polygon[i];
            GeoPos p2 = polygon[(i + 1) % numValues];
            float lonDiff = p2.lon - p1.lon;
            if (lonDiff >= 180.0f) {
                p2.lon -= 360.0f;
                negNormalized = true;
            } else if (lonDiff <= -180.0f) {
                p2.lon += 360.0f;
                posNormalized = true;
            }
            ++i;
        }
        int normalized = 0;
        if (negNormalized && !posNormalized) {
            GeoPos[] geoPosArray = polygon;
            int n = polygon.length;
            int n2 = 0;
            while (n2 < n) {
                GeoPos aPolygon = geoPosArray[n2];
                aPolygon.lon += 360.0f;
                ++n2;
            }
            normalized = -1;
        } else if (!negNormalized && posNormalized) {
            normalized = 1;
        } else if (negNormalized && posNormalized) {
            normalized = 2;
        }
        return normalized;
    }

    public static void denormalizeGeoPolygon(GeoPos[] polygon) {
        GeoPos[] geoPosArray = polygon;
        int n = polygon.length;
        int n2 = 0;
        while (n2 < n) {
            GeoPos geoPos = geoPosArray[n2];
            ProductUtils.denormalizeGeoPos(geoPos);
            ++n2;
        }
    }

    public static void denormalizeGeoPos(GeoPos geoPos) {
        int factor = geoPos.lon >= 0.0f ? (int)((geoPos.lon + 180.0f) / 360.0f) : (int)((geoPos.lon - 180.0f) / 360.0f);
        geoPos.lon -= (float)factor * 360.0f;
    }

    @Deprecated
    public static void denormalizeGeoPos_old(GeoPos geoPos) {
        if (geoPos.lon > 180.0f) {
            geoPos.lon -= 360.0f;
        } else if (geoPos.lon < -180.0f) {
            geoPos.lon += 360.0f;
        }
    }

    public static int getRotationDirection(GeoPos[] polygon) {
        return ProductUtils.getAngleSum(polygon) > 0.0 ? 1 : -1;
    }

    public static double getAngleSum(GeoPos[] polygon) {
        int length = polygon.length;
        double angleSum = 0.0;
        int i = 0;
        while (i < length) {
            GeoPos p1 = polygon[i];
            GeoPos p2 = polygon[(i + 1) % length];
            GeoPos p3 = polygon[(i + 2) % length];
            double ax = p2.lon - p1.lon;
            double ay = p2.lat - p1.lat;
            double bx = p3.lon - p2.lon;
            double by = p3.lat - p2.lat;
            double a = Math.sqrt(ax * ax + ay * ay);
            double b = Math.sqrt(bx * bx + by * by);
            double cosAB = (ax * bx + ay * by) / (a * b);
            double sinAB = (ax * by - ay * bx) / (a * b);
            angleSum += Math.atan2(sinAB, cosAB);
            ++i;
        }
        return angleSum;
    }

    public static GeneralPath convertToPixelPath(GeneralPath geoPath, GeoCoding geoCoding) {
        Guardian.assertNotNull("geoPath", geoPath);
        Guardian.assertNotNull("geoCoding", geoCoding);
        PathIterator pathIterator = geoPath.getPathIterator(null);
        float[] floats = new float[6];
        PixelPos pixelPos = new PixelPos();
        GeoPos geoPos = new GeoPos();
        GeneralPath pixelPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            int segmentType = pathIterator.currentSegment(floats);
            geoPos.setLocation(floats[1], floats[0]);
            if (segmentType == 4) {
                pixelPath.closePath();
            } else if (segmentType == 1) {
                geoCoding.getPixelPos(geoPos, pixelPos);
                pixelPath.lineTo(pixelPos.x, pixelPos.y);
            } else if (segmentType == 0) {
                geoCoding.getPixelPos(geoPos, pixelPos);
                pixelPath.moveTo(pixelPos.x, pixelPos.y);
            } else {
                throw new IllegalStateException("Unexpected path iterator segment: " + segmentType);
            }
            pathIterator.next();
        }
        return pixelPath;
    }

    public static GeneralPath convertToGeoPath(Shape shape, GeoCoding geoCoding) {
        Guardian.assertNotNull("shape", shape);
        Guardian.assertNotNull("geoCoding", geoCoding);
        if (!geoCoding.canGetGeoPos()) {
            throw new IllegalArgumentException("invalid 'geoCoding'");
        }
        PathIterator pathIterator = shape.getPathIterator(null, 0.1);
        float[] floats = new float[6];
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        PixelPos lastPixelPos = new PixelPos();
        GeneralPath geoPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            int segmentType = pathIterator.currentSegment(floats);
            pixelPos.x = floats[0];
            pixelPos.y = floats[1];
            if (segmentType == 4) {
                geoPath.closePath();
            } else if (segmentType == 1) {
                double distance = lastPixelPos.distance(pixelPos);
                if (distance > 1.5) {
                    float startX = lastPixelPos.x;
                    float startY = lastPixelPos.y;
                    float endX = pixelPos.x;
                    float endY = pixelPos.y;
                    int numParts = (int)(distance / 1.5) + 1;
                    float addX = (endX - startX) / (float)numParts;
                    float addY = (endY - startY) / (float)numParts;
                    pixelPos.setLocation(startX + addX, startY + addY);
                    int i = 1;
                    while (i < numParts) {
                        geoCoding.getGeoPos(pixelPos, geoPos);
                        geoPath.lineTo(geoPos.lon, geoPos.lat);
                        ++i;
                        pixelPos.x += addX;
                        pixelPos.y += addY;
                    }
                    pixelPos.setLocation(endX, endY);
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    geoPath.lineTo(geoPos.lon, geoPos.lat);
                    lastPixelPos.setLocation(pixelPos);
                } else {
                    geoCoding.getGeoPos(pixelPos, geoPos);
                    geoPath.lineTo(geoPos.lon, geoPos.lat);
                    lastPixelPos.setLocation(pixelPos);
                }
            } else if (segmentType == 0) {
                geoCoding.getGeoPos(pixelPos, geoPos);
                geoPath.moveTo(geoPos.lon, geoPos.lat);
                lastPixelPos.setLocation(pixelPos);
            } else {
                throw new IllegalStateException("Unexpected path iterator segment: " + segmentType);
            }
            pathIterator.next();
        }
        return geoPath;
    }

    public static void copyMetadata(Product source, Product target) {
        Assert.notNull(source, "source");
        Assert.notNull(target, "target");
        ProductUtils.copyMetadata(source.getMetadataRoot(), target.getMetadataRoot());
    }

    public static void copyMetadata(MetadataElement source, MetadataElement target) {
        Assert.notNull(source, "source");
        Assert.notNull(target, "target");
        ProductNode[] productNodeArray = source.getElements();
        int n = productNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataElement element = productNodeArray[n2];
            target.addElement(element.createDeepClone());
            ++n2;
        }
        productNodeArray = source.getAttributes();
        n = productNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            ProductNode attribute = productNodeArray[n2];
            target.addAttribute(((MetadataAttribute)attribute).createDeepClone());
            ++n2;
        }
    }

    public static void copyPreferredTileSize(Product sourceProduct, Product targetProduct) {
        Dimension preferredTileSize = sourceProduct.getPreferredTileSize();
        if (preferredTileSize != null) {
            Rectangle targetRect = new Rectangle(targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
            Rectangle tileRect = new Rectangle(preferredTileSize).intersection(targetRect);
            targetProduct.setPreferredTileSize(tileRect.width, tileRect.height);
        }
    }

    public static GeoTIFFMetadata createGeoTIFFMetadata(Product product) {
        GeoCoding geoCoding = product.getGeoCoding();
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        return ProductUtils.createGeoTIFFMetadata(geoCoding, w, h);
    }

    public static GeoTIFFMetadata createGeoTIFFMetadata(GeoCoding geoCoding, int width, int height) {
        return GeoCoding2GeoTIFFMetadata.createGeoTIFFMetadata(geoCoding, width, height);
    }

    public static GeneralPath areaToPath(Area negativeArea, double deltaX) {
        GeneralPath pixelPath = new GeneralPath(1);
        float[] floats = new float[6];
        AffineTransform transform = AffineTransform.getTranslateInstance(deltaX, 0.0);
        PathIterator iterator = negativeArea.getPathIterator(transform);
        while (!iterator.isDone()) {
            int segmentType = iterator.currentSegment(floats);
            if (segmentType == 1) {
                pixelPath.lineTo(floats[0], floats[1]);
            } else if (segmentType == 0) {
                pixelPath.moveTo(floats[0], floats[1]);
            } else if (segmentType == 4) {
                pixelPath.closePath();
            } else {
                throw new IllegalStateException("unhandled segment type in path iterator: " + segmentType);
            }
            iterator.next();
        }
        return pixelPath;
    }

    public static void addElementToHistory(Product product, MetadataElement elem) {
        Guardian.assertNotNull("product", product);
        if (elem != null) {
            MetadataElement historyElem;
            MetadataElement metadataRoot = product.getMetadataRoot();
            if (!metadataRoot.containsElement("history")) {
                metadataRoot.addElement(new MetadataElement("history"));
            }
            if ((historyElem = metadataRoot.getElement("history")).containsElement(elem.getName())) {
                MetadataElement previousElem = historyElem.getElement(elem.getName());
                historyElem.removeElement(previousElem);
                elem.addElement(previousElem);
            }
            historyElem.addElement(elem);
        }
    }

    public static String[] removeInvalidExpressions(final Product product) {
        final ArrayList messages = new ArrayList(10);
        product.acceptVisitor(new ProductVisitorAdapter(){

            @Override
            public void visit(BitmaskDef bitmaskDef) {
                if (!product.isCompatibleBandArithmeticExpression(bitmaskDef.getExpr())) {
                    String pattern = "Bitmask definition ''{0}'' removed from output product because it is not applicable.";
                    messages.add(MessageFormat.format(pattern, bitmaskDef.getName()));
                }
            }

            @Override
            public void visit(TiePointGrid grid) {
                this.checkRaster(grid, "tie point grid");
            }

            @Override
            public void visit(Band band) {
                this.checkRaster(band, "band");
            }

            @Override
            public void visit(VirtualBand virtualBand) {
                if (!product.isCompatibleBandArithmeticExpression(virtualBand.getExpression())) {
                    product.removeBand(virtualBand);
                    String pattern = "Virtual band ''{0}'' removed from output product because it is not applicable.";
                    messages.add(MessageFormat.format(pattern, virtualBand.getName()));
                } else {
                    this.checkRaster(virtualBand, "virtual band");
                }
            }

            private void checkRaster(RasterDataNode raster, String type) {
                String validExpr = raster.getValidPixelExpression();
                if (validExpr != null && !product.isCompatibleBandArithmeticExpression(validExpr)) {
                    raster.setValidPixelExpression(null);
                    String pattern = "Valid pixel expression ''{0}'' removed from output {1} ''{2}'' because it is not applicable.";
                    messages.add(MessageFormat.format(pattern, validExpr, type, raster.getName()));
                }
            }
        });
        return messages.toArray(new String[messages.size()]);
    }

    public static String findSuitableQuicklookBandName(Product product) {
        String bandName = product.getQuicklookBandName();
        if (bandName != null && product.containsBand(bandName)) {
            return bandName;
        }
        Band[] bands = product.getBands();
        if (bands.length == 0) {
            return null;
        }
        double wavelengthMax = 0.0;
        Band[] bandArray = bands;
        int n = bands.length;
        int n2 = 0;
        while (n2 < n) {
            Band band = bandArray[n2];
            float wavelength = band.getSpectralWavelength();
            if (wavelength > 1000.0f && (double)wavelength > wavelengthMax) {
                wavelengthMax = wavelength;
                bandName = band.getName();
            }
            ++n2;
        }
        if (bandName != null) {
            return bandName;
        }
        double minValue = Double.MAX_VALUE;
        Band[] bandArray2 = bands;
        int n3 = bands.length;
        int n4 = 0;
        while (n4 < n3) {
            double value;
            Band band = bandArray2[n4];
            double wavelength = band.getSpectralWavelength();
            if (wavelength > 860.0 && wavelength < 890.0 && (value = wavelength - 860.0) < minValue) {
                minValue = value;
                bandName = band.getName();
            }
            ++n4;
        }
        if (bandName != null) {
            return bandName;
        }
        wavelengthMax = 0.0;
        bandArray2 = bands;
        n3 = bands.length;
        n4 = 0;
        while (n4 < n3) {
            Band band = bandArray2[n4];
            float wavelength = band.getSpectralWavelength();
            if ((double)wavelength > wavelengthMax) {
                wavelengthMax = wavelength;
                bandName = band.getName();
            }
            ++n4;
        }
        if (bandName != null) {
            return bandName;
        }
        return bands[0].getName();
    }

    public static PixelPos[] computeSourcePixelCoordinates(GeoCoding sourceGeoCoding, int sourceWidth, int sourceHeight, GeoCoding destGeoCoding, Rectangle destArea) {
        Guardian.assertNotNull("sourceGeoCoding", sourceGeoCoding);
        Guardian.assertEquals("sourceGeoCoding.canGetPixelPos()", sourceGeoCoding.canGetPixelPos(), true);
        Guardian.assertNotNull("destGeoCoding", destGeoCoding);
        Guardian.assertEquals("destGeoCoding.canGetGeoPos()", destGeoCoding.canGetGeoPos(), true);
        Guardian.assertNotNull("destArea", destArea);
        int minX = destArea.x;
        int minY = destArea.y;
        int maxX = minX + destArea.width - 1;
        int maxY = minY + destArea.height - 1;
        PixelPos[] pixelCoords = new PixelPos[destArea.width * destArea.height];
        GeoPos geoPos = new GeoPos();
        PixelPos pixelPos = new PixelPos();
        int coordIndex = 0;
        int y = minY;
        while (y <= maxY) {
            int x = minX;
            while (x <= maxX) {
                pixelPos.x = (float)x + 0.5f;
                pixelPos.y = (float)y + 0.5f;
                destGeoCoding.getGeoPos(pixelPos, geoPos);
                sourceGeoCoding.getPixelPos(geoPos, pixelPos);
                pixelCoords[coordIndex] = pixelPos.x >= 0.0f && pixelPos.x < (float)sourceWidth && pixelPos.y >= 0.0f && pixelPos.y < (float)sourceHeight ? new PixelPos(pixelPos.x, pixelPos.y) : null;
                ++coordIndex;
                ++x;
            }
            ++y;
        }
        return pixelCoords;
    }

    public static float[] computeMinMaxY(PixelPos[] pixelPositions) {
        Guardian.assertNotNull("pixelPositions", pixelPositions);
        float min = 2.1474836E9f;
        float max = -2.1474836E9f;
        PixelPos[] pixelPosArray = pixelPositions;
        int n = pixelPositions.length;
        int n2 = 0;
        while (n2 < n) {
            PixelPos pixelPos = pixelPosArray[n2];
            if (pixelPos != null) {
                if (pixelPos.y < min) {
                    min = pixelPos.y;
                }
                if (pixelPos.y > max) {
                    max = pixelPos.y;
                }
            }
            ++n2;
        }
        if (min > max) {
            return null;
        }
        return new float[]{min, max};
    }

    public static void copyBandsForGeomTransform(Product sourceProduct, Product targetProduct, double defaultNoDataValue, Map<Band, RasterDataNode> addedRasterDataNodes) {
        ProductUtils.copyBandsForGeomTransform(sourceProduct, targetProduct, false, defaultNoDataValue, addedRasterDataNodes);
    }

    public static void copyBandsForGeomTransform(Product sourceProduct, Product targetProduct, boolean includeTiePointGrids, double defaultNoDataValue, Map<Band, RasterDataNode> targetToSourceMap) {
        Band targetBand;
        Debug.assertNotNull(sourceProduct);
        Debug.assertNotNull(targetProduct);
        HashMap<Band, RasterDataNode> sourceNodes = new HashMap<Band, RasterDataNode>(sourceProduct.getNumBands() + sourceProduct.getNumTiePointGrids() + 10);
        Band[] sourceBands = sourceProduct.getBands();
        RasterDataNode[] rasterDataNodeArray = sourceBands;
        int n = sourceBands.length;
        int n2 = 0;
        while (n2 < n) {
            Band sourceBand = rasterDataNodeArray[n2];
            if (sourceBand.getGeoCoding() != null) {
                if (sourceBand instanceof VirtualBand) {
                    targetBand = new VirtualBand(sourceBand.getName(), sourceBand.getDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight(), ((VirtualBand)sourceBand).getExpression());
                } else if (sourceBand.isScalingApplied()) {
                    targetBand = new Band(sourceBand.getName(), 30, targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
                    targetBand.setLog10Scaled(sourceBand.isLog10Scaled());
                } else {
                    targetBand = new Band(sourceBand.getName(), sourceBand.getDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
                }
                targetBand.setUnit(sourceBand.getUnit());
                if (sourceBand.getDescription() != null) {
                    targetBand.setDescription(sourceBand.getDescription());
                }
                if (sourceBand.isNoDataValueUsed()) {
                    if (sourceBand.isScalingApplied()) {
                        targetBand.setGeophysicalNoDataValue(sourceBand.getGeophysicalNoDataValue());
                    } else {
                        targetBand.setNoDataValue(sourceBand.getNoDataValue());
                    }
                } else {
                    targetBand.setGeophysicalNoDataValue(defaultNoDataValue);
                }
                targetBand.setNoDataValueUsed(true);
                ProductUtils.copySpectralBandProperties(sourceBand, targetBand);
                FlagCoding sourceFlagCoding = sourceBand.getFlagCoding();
                IndexCoding sourceIndexCoding = sourceBand.getIndexCoding();
                if (sourceFlagCoding != null) {
                    String flagCodingName = sourceFlagCoding.getName();
                    FlagCoding destFlagCoding = targetProduct.getFlagCodingGroup().get(flagCodingName);
                    Debug.assertNotNull(destFlagCoding);
                    targetBand.setSampleCoding(destFlagCoding);
                } else if (sourceIndexCoding != null) {
                    String indexCodingName = sourceIndexCoding.getName();
                    IndexCoding destIndexCoding = targetProduct.getIndexCodingGroup().get(indexCodingName);
                    Debug.assertNotNull(destIndexCoding);
                    targetBand.setSampleCoding(destIndexCoding);
                } else {
                    targetBand.setSampleCoding(null);
                }
                ImageInfo sourceImageInfo = sourceBand.getImageInfo();
                if (sourceImageInfo != null) {
                    targetBand.setImageInfo(sourceImageInfo.createDeepCopy());
                }
                targetProduct.addBand(targetBand);
                sourceNodes.put(targetBand, sourceBand);
            }
            ++n2;
        }
        if (includeTiePointGrids) {
            rasterDataNodeArray = sourceProduct.getTiePointGrids();
            n = rasterDataNodeArray.length;
            n2 = 0;
            while (n2 < n) {
                RasterDataNode sourceGrid = rasterDataNodeArray[n2];
                if (sourceGrid.getGeoCoding() != null) {
                    targetBand = new Band(sourceGrid.getName(), ((TiePointGrid)sourceGrid).getGeophysicalDataType(), targetProduct.getSceneRasterWidth(), targetProduct.getSceneRasterHeight());
                    targetBand.setUnit(sourceGrid.getUnit());
                    if (sourceGrid.getDescription() != null) {
                        targetBand.setDescription(sourceGrid.getDescription());
                    }
                    if (sourceGrid.isNoDataValueUsed()) {
                        targetBand.setNoDataValue(sourceGrid.getNoDataValue());
                    } else {
                        targetBand.setNoDataValue(defaultNoDataValue);
                    }
                    targetBand.setNoDataValueUsed(true);
                    targetProduct.addBand(targetBand);
                    sourceNodes.put(targetBand, sourceGrid);
                }
                ++n2;
            }
        }
        rasterDataNodeArray = targetProduct.getBands();
        n = rasterDataNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            String sourceExpression;
            RasterDataNode targetBand2 = rasterDataNodeArray[n2];
            RasterDataNode sourceNode = (RasterDataNode)sourceNodes.get(targetBand2);
            if (sourceNode != null && (sourceExpression = sourceNode.getValidPixelExpression()) != null && !targetProduct.isCompatibleBandArithmeticExpression(sourceExpression)) {
                targetBand2.setValidPixelExpression(sourceExpression);
            }
            ++n2;
        }
        if (targetToSourceMap != null) {
            targetToSourceMap.putAll(sourceNodes);
        }
    }

    public static ArrayList<GeneralPath> assemblePathList(GeoPos[] geoPoints) {
        GeneralPath path = new GeneralPath(1, geoPoints.length + 8);
        ArrayList<GeneralPath> pathList = new ArrayList<GeneralPath>(16);
        if (geoPoints.length > 1) {
            float lon;
            float minLon = lon = geoPoints[0].getLon();
            float maxLon = lon;
            path.moveTo(lon, geoPoints[0].getLat());
            int i = 1;
            while (i < geoPoints.length) {
                lon = geoPoints[i].getLon();
                float lat = geoPoints[i].getLat();
                if (!Float.isNaN(lon) && !Float.isNaN(lat)) {
                    if (lon < minLon) {
                        minLon = lon;
                    }
                    if (lon > maxLon) {
                        maxLon = lon;
                    }
                    path.lineTo(lon, lat);
                }
                ++i;
            }
            path.closePath();
            int runIndexMin = (int)Math.floor((minLon + 180.0f) / 360.0f);
            int runIndexMax = (int)Math.floor((maxLon + 180.0f) / 360.0f);
            if (runIndexMin == 0 && runIndexMax == 0) {
                pathList.add(path);
                return pathList;
            }
            Area pathArea = new Area(path);
            int k = runIndexMin;
            while (k <= runIndexMax) {
                Area currentArea = new Area(new Rectangle2D.Float((float)k * 360.0f - 180.0f, -90.0f, 360.0f, 180.0f));
                currentArea.intersect(pathArea);
                if (!currentArea.isEmpty()) {
                    pathList.add(ProductUtils.areaToPath(currentArea, (double)(-k) * 360.0));
                }
                ++k;
            }
        }
        return pathList;
    }

    public static ProductData.UTC getScanLineTime(Product product, double y) {
        ProductData.UTC utcStartTime = product.getStartTime();
        ProductData.UTC utcEndTime = product.getEndTime();
        if (utcStartTime == null && utcEndTime == null) {
            return null;
        }
        if (utcStartTime == null) {
            return utcEndTime;
        }
        if (utcEndTime == null) {
            return utcStartTime;
        }
        double start = utcStartTime.getMJD();
        double stop = utcEndTime.getMJD();
        if (product.getSceneRasterHeight() == 1) {
            return new ProductData.UTC(utcStartTime.getMJD());
        }
        double timePerLine = (stop - start) / (double)(product.getSceneRasterHeight() - 1);
        double currentLine = timePerLine * y + start;
        return new ProductData.UTC(currentLine);
    }

    public static double getGeophysicalSampleDouble(Band band, int pixelX, int pixelY, int level) {
        int tileY;
        int tileX;
        PlanarImage image = ImageManager.getInstance().getSourceImage(band, level);
        Raster data = image.getTile(tileX = image.XToTileX(pixelX), tileY = image.YToTileY(pixelY));
        if (data == null) {
            return Double.NaN;
        }
        double sample = band.getDataType() == 10 ? (double)((byte)data.getSample(pixelX, pixelY, 0)) : (band.getDataType() == 22 ? (double)((long)data.getSample(pixelX, pixelY, 0) & 0xFFFFFFFFL) : data.getSampleDouble(pixelX, pixelY, 0));
        if (band.isScalingApplied()) {
            return band.scale(sample);
        }
        return sample;
    }

    public static long getGeophysicalSampleLong(Band band, int pixelX, int pixelY, int level) {
        PlanarImage image = ImageManager.getInstance().getSourceImage(band, level);
        int tileX = image.XToTileX(pixelX);
        int tileY = image.YToTileY(pixelY);
        Raster data = image.getTile(tileX, tileY);
        long sample = band.getDataType() == 10 ? (long)((byte)data.getSample(pixelX, pixelY, 0)) : (band.getDataType() == 22 ? (long)data.getSample(pixelX, pixelY, 0) & 0xFFFFFFFFL : (long)data.getSample(pixelX, pixelY, 0));
        if (band.isScalingApplied()) {
            return (long)band.scale(sample);
        }
        return sample;
    }
}

