/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.converters;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.Converter;

public class JavaTypeConverter
implements Converter<Class> {
    private static final String[] DEFAULT_PACKAGE_QUALIFIERS = new String[]{"", "java.lang.", "java.util.", "com.vividsolutions.jts.geom."};

    @Override
    public Class<Class> getValueType() {
        return Class.class;
    }

    @Override
    public Class parse(String text) throws ConversionException {
        Class<?> type = null;
        String[] stringArray = DEFAULT_PACKAGE_QUALIFIERS;
        int n = DEFAULT_PACKAGE_QUALIFIERS.length;
        int n2 = 0;
        while (n2 < n) {
            String defaultPackageQualifier = stringArray[n2];
            try {
                type = this.getClass().getClassLoader().loadClass(String.valueOf(defaultPackageQualifier) + text);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n2;
            }
        }
        if (type == null) {
            throw new ConversionException(text);
        }
        return type;
    }

    @Override
    public String format(Class javaType) {
        String name = javaType.getName();
        int i = 1;
        while (i < DEFAULT_PACKAGE_QUALIFIERS.length) {
            String defaultPackageQualifier = DEFAULT_PACKAGE_QUALIFIERS[i];
            if (name.startsWith(defaultPackageQualifier)) {
                return name.substring(defaultPackageQualifier.length());
            }
            ++i;
        }
        return name;
    }
}

