/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

public class LinearAlgebra {
    public static boolean isMatrix(double[][] array) {
        if (array == null || array.length == 0) {
            return false;
        }
        double[][] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row = dArray[n2];
            if (row == null || row.length == 0) {
                return false;
            }
            ++n2;
        }
        int i = 1;
        while (i < array.length) {
            if (array[i].length != array[0].length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isMatrix(int rowCount, int colCount, double[][] array) {
        int m = Math.max(0, rowCount);
        int n = Math.max(0, colCount);
        if (array == null || array.length != m) {
            return false;
        }
        double[][] dArray = array;
        int n2 = array.length;
        int n3 = 0;
        while (n3 < n2) {
            double[] row = dArray[n3];
            if (row == null || row.length != n) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static double[] multiply(double[] b, double c) {
        int i = 0;
        while (i < b.length) {
            int n = i++;
            b[n] = b[n] * c;
        }
        return b;
    }

    public static double[] multiply(double[][] a, double[] b) {
        return LinearAlgebra.multiply(a, b, new double[a[0].length]);
    }

    public static double[] multiply(double[][] a, double[] b, double[] c) {
        int i = 0;
        while (i < a.length) {
            c[i] = LinearAlgebra.innerProduct(a[i], b);
            ++i;
        }
        return c;
    }

    public static double[] multiply(double[] b, double[][] a) {
        return LinearAlgebra.multiply(b, a, new double[a[0].length]);
    }

    public static double[] multiply(double[] b, double[][] a, double[] c) {
        int j = 0;
        while (j < a[0].length) {
            c[j] = LinearAlgebra.innerProduct(b, a, j);
            ++j;
        }
        return c;
    }

    public static double[] multiplyAndSubtract(double[] b, double[][] a, double s) {
        return LinearAlgebra.multiplyAndSubtract(b, a, s, new double[a[0].length]);
    }

    public static double[] multiplyAndSubtract(double[] b, double[][] a, double s, double[] c) {
        int j = 0;
        while (j < a[0].length) {
            c[j] = LinearAlgebra.innerProduct(b, a, j) - s;
            ++j;
        }
        return c;
    }

    public static double innerProduct(double[] a, double[] b) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i] * b[i];
            ++i;
        }
        return sum;
    }

    public static double innerProduct(double[] a, double[][] b, int j) {
        double sum = 0.0;
        int i = 0;
        while (i < a.length) {
            sum += a[i] * b[i][j];
            ++i;
        }
        return sum;
    }

    public static double innerProduct(double[][] a, double[][] b, int i, int j) {
        return LinearAlgebra.innerProduct(a[i], b, j);
    }

    public static double[][] outerProduct(double[] a, double[] b) {
        return LinearAlgebra.outerProduct(a, b, new double[a.length][b.length]);
    }

    public static double[][] outerProduct(double[] a, double[] b, double[][] c) {
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b.length) {
                c[i][j] = a[i] * b[j];
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static double[][] multiply(double[][] a, double[][] b) {
        return LinearAlgebra.multiply(a, b, new double[a.length][b[0].length]);
    }

    public static double[][] multiply(double[][] a, double[][] b, double[][] c) {
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < b[0].length) {
                c[i][j] = LinearAlgebra.innerProduct(a, b, i, j);
                ++j;
            }
            ++i;
        }
        return c;
    }

    public static double[][] subtract(double[][] a, double[] b, double[] c) {
        int m = b.length;
        int n = c.length;
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < n) {
                double[] dArray = a[i];
                int n2 = j;
                dArray[n2] = dArray[n2] - b[i] * c[j];
                ++j;
            }
            ++i;
        }
        return a;
    }
}

