/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import java.awt.Dimension;
import java.awt.Rectangle;

public class MathUtils {
    public static final float EPS_F = 1.0E-6f;
    public static final double EPS = 1.0E-12;
    public static final double DTOR = Math.PI / 180;
    public static final double RTOD = 57.29577951308232;
    public static final float DTOR_F = (float)Math.PI / 180;
    public static final float RTOD_F = 57.29578f;
    public static final double LOG10 = Math.log(10.0);
    public static final double HALFPI = 1.5707963267948966;

    public static boolean equalValues(float x1, float x2) {
        return Math.abs(x1 - x2) <= 1.0E-6f;
    }

    public static boolean equalValues(double x1, double x2) {
        return Math.abs(x1 - x2) <= 1.0E-12;
    }

    public static boolean equalValues(float x1, float x2, float eps) {
        return Math.abs(x1 - x2) <= eps;
    }

    public static boolean equalValues(double x1, double x2, double eps) {
        return Math.abs(x1 - x2) <= eps;
    }

    public static float interpolate2D(float wi, float wj, float x00, float x10, float x01, float x11) {
        return x00 + wi * (x10 - x00) + wj * (x01 - x00) + wi * wj * (x11 + x00 - x01 - x10);
    }

    public static double interpolate2D(double wi, double wj, double x00, double x10, double x01, double x11) {
        return x00 + wi * (x10 - x00) + wj * (x01 - x00) + wi * wj * (x11 + x00 - x01 - x10);
    }

    public static int floorAndCrop(double x, int min, int max) {
        int rx = MathUtils.floorInt(x);
        return MathUtils.crop(rx, min, max);
    }

    public static int roundAndCrop(float x, int min, int max) {
        int rx = Math.round(x);
        return MathUtils.crop(rx, min, max);
    }

    public static long roundAndCrop(double value, long min, long max) {
        long rx = Math.round(value);
        return MathUtils.crop(rx, min, max);
    }

    public static int floorInt(double value) {
        return (int)Math.floor(value);
    }

    public static long floorLong(double x) {
        return (long)Math.floor(x);
    }

    public static int ceilInt(double x) {
        return (int)Math.ceil(x);
    }

    public static long ceilLong(double x) {
        return (long)Math.ceil(x);
    }

    public static float computeRoundFactor(float min, float max, int numDigits) {
        return (float)MathUtils.computeRoundFactor((double)min, (double)max, numDigits);
    }

    public static double computeRoundFactor(double min, double max, int numDigits) {
        double exponent = MathUtils.log10(Math.abs(max - min));
        int numLeadingZeroDigits = -((int)Math.round(exponent));
        if (numLeadingZeroDigits > 0) {
            numDigits += numLeadingZeroDigits;
        }
        return Math.pow(10.0, numDigits);
    }

    public static float round(float x, float roundFactor) {
        return (float)Math.round(x * roundFactor) / roundFactor;
    }

    public static double round(double x, double roundFactor) {
        return (double)Math.round(x * roundFactor) / roundFactor;
    }

    public static double getOrderOfMagnitude(double x) {
        return Math.floor(MathUtils.log10(x));
    }

    public static double log10(double x) {
        return Math.log(x) / LOG10;
    }

    public static byte[] createGammaCurve(double gamma, byte[] f) {
        if (gamma <= 0.0) {
            throw new IllegalArgumentException("gamma was <= zero");
        }
        if (f == null || f.length != 256) {
            f = new byte[256];
        }
        if (gamma == 1.0) {
            int i = 0;
            while (i < f.length) {
                f[i] = (byte)i;
                ++i;
            }
        } else {
            int i = 0;
            while (i < f.length) {
                double x = (double)i / 255.0;
                double y = Math.pow(x, gamma);
                int j = (int)(y * 256.0);
                f[i] = (byte)(j < 0 ? 0 : (j > 255 ? 255 : j));
                ++i;
            }
        }
        return f;
    }

    public static byte crop(byte val, byte min, byte max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static short crop(short val, short min, short max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static int crop(int val, int min, int max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static long crop(long val, long min, long max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static float crop(float val, float min, float max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static double crop(double val, double min, double max) {
        return val < min ? min : (val > max ? max : val);
    }

    public static Dimension fitDimension(int n, double a, double b) {
        int h2;
        int w2;
        if (n == 0) {
            return new Dimension(0, 0);
        }
        double wd = Math.sqrt((double)n * a / b);
        double hd = (double)n / wd;
        int w1 = (int)Math.floor(wd);
        int h1 = (int)Math.floor(hd);
        if (w1 > 0) {
            w2 = w1 + 1;
        } else {
            w1 = 1;
            w2 = 1;
        }
        if (h1 > 0) {
            h2 = h1 + 1;
        } else {
            h1 = 1;
            h2 = 1;
        }
        double[] d = new double[]{Math.abs(b * (double)w1 - a * (double)h1), Math.abs(b * (double)w1 - a * (double)h2), Math.abs(b * (double)w2 - a * (double)h1), Math.abs(b * (double)w2 - a * (double)h2)};
        int index = -1;
        double dMin = Double.MAX_VALUE;
        int i = 0;
        while (i < d.length) {
            if (d[i] < dMin) {
                dMin = d[i];
                index = i;
            }
            ++i;
        }
        if (index == 0) {
            return new Dimension(w1, h1);
        }
        if (index == 1) {
            return new Dimension(w1, h2);
        }
        if (index == 2) {
            return new Dimension(w2, h1);
        }
        return new Dimension(w2, h2);
    }

    public static Rectangle[] subdivideRectangle(int width, int height, int numTilesX, int numTilesY, int extraBorder) {
        Rectangle[] rectangles = new Rectangle[numTilesX * numTilesY];
        int k = 0;
        float w = (float)width / (float)numTilesX;
        float h = (float)height / (float)numTilesY;
        int j = 0;
        while (j < numTilesY) {
            int y1 = (int)Math.floor((float)(j + 0) * h);
            int y2 = (int)Math.floor((float)(j + 1) * h) - 1;
            if (y2 < y1) {
                y2 = y1;
            }
            y2 += extraBorder;
            if ((y1 -= extraBorder) < 0) {
                y1 = 0;
            }
            if (y2 > height - 1) {
                y2 = height - 1;
            }
            int i = 0;
            while (i < numTilesX) {
                int x1 = (int)Math.floor((float)(i + 0) * w);
                int x2 = (int)Math.floor((float)(i + 1) * w) - 1;
                if (x2 < x1) {
                    x2 = x1;
                }
                x2 += extraBorder;
                if ((x1 -= extraBorder) < 0) {
                    x1 = 0;
                }
                if (x2 > width - 1) {
                    x2 = width - 1;
                }
                rectangles[k] = new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
                ++k;
                ++i;
            }
            ++j;
        }
        return rectangles;
    }

    public static final double sphereDistanceDeg(double sphereRadius, double lambda1_deg, double phi1_deg, double lambda2_deg, double phi2_deg) {
        return MathUtils.sphereDistance(sphereRadius, Math.PI / 180 * lambda1_deg, Math.PI / 180 * phi1_deg, Math.PI / 180 * lambda2_deg, Math.PI / 180 * phi2_deg);
    }

    public static final double sphereDistance(double sphereRadius, double lambda1_rad, double phi1_rad, double lambda2_rad, double phi2_rad) {
        double deltaLambda = lambda1_rad - lambda2_rad;
        double cosDeltaLambda = Math.cos(deltaLambda);
        double sinPhi = Math.sin(phi1_rad) * Math.sin(phi2_rad);
        double cosPhi = Math.cos(phi1_rad) * Math.cos(phi2_rad);
        return sphereRadius * Math.acos(sinPhi + cosPhi * cosDeltaLambda);
    }
}

