/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import org.esa.beam.util.math.DistanceMeasure;

public final class SphericalDistance
implements DistanceMeasure {
    private final double lon;
    private final double si;
    private final double co;

    public SphericalDistance(double lon, double lat) {
        this.lon = lon;
        this.si = Math.sin(Math.toRadians(lat));
        this.co = Math.cos(Math.toRadians(lat));
    }

    @Override
    public double distance(double lon, double lat) {
        double phi = Math.toRadians(lat);
        return Math.acos(this.si * Math.sin(phi) + this.co * Math.cos(phi) * Math.cos(Math.toRadians(lon - this.lon)));
    }
}

