/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.util.math;

import Jama.Matrix;
import java.text.MessageFormat;
import org.esa.beam.util.math.LinearAlgebra;
import org.esa.beam.util.math.SpectralUnmixing;

public class UnconstrainedLSU
implements SpectralUnmixing {
    private final double[][] endmemberMatrix;
    private final double[][] inverseEndmemberMatrix;

    public UnconstrainedLSU(double[][] endmembers) {
        if (!LinearAlgebra.isMatrix(endmembers)) {
            throw new IllegalArgumentException("Parameter 'endmembers' is not a matrix.");
        }
        this.endmemberMatrix = endmembers;
        this.inverseEndmemberMatrix = new Matrix(endmembers).inverse().getArrayCopy();
    }

    public double[][] getEndmembers() {
        return this.endmemberMatrix;
    }

    @Override
    public double[][] unmix(double[][] spectra) {
        int actualRowCount = spectra.length;
        int expectedRowCount = this.endmemberMatrix.length;
        if (actualRowCount != expectedRowCount) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''spectra'' is not a matrix with {0} rows.", expectedRowCount));
        }
        return LinearAlgebra.multiply(this.inverseEndmemberMatrix, spectra);
    }

    @Override
    public double[][] mix(double[][] abundances) {
        int actualRowCount = abundances.length;
        int expectedRowCount = this.endmemberMatrix[0].length;
        if (actualRowCount != expectedRowCount) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''abundances'' is not a matrix with {0} rows.", expectedRowCount));
        }
        return LinearAlgebra.multiply(this.endmemberMatrix, abundances);
    }
}

