/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.feature.PropertyImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.identity.Identifier;

public class AttributeImpl
extends PropertyImpl
implements Attribute {
    protected Identifier id = null;

    public AttributeImpl(Object content, AttributeDescriptor descriptor, Identifier id) {
        super(content, descriptor);
        this.id = id;
    }

    public AttributeImpl(Object content, AttributeType type, Identifier id) {
        this(content, new AttributeDescriptorImpl(type, type.getName(), 1, 1, true, null), id);
    }

    public Identifier getIdentifier() {
        return this.id;
    }

    public AttributeDescriptor getDescriptor() {
        return (AttributeDescriptor)super.getDescriptor();
    }

    public AttributeType getType() {
        return (AttributeType)super.getType();
    }

    public void setValue(Object newValue) throws IllegalArgumentException, IllegalStateException {
        newValue = this.parse(newValue);
        super.setValue(newValue);
    }

    public int hashCode() {
        return super.hashCode() + 37 * (this.id == null ? 0 : ((Object)this.id).hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Attribute)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        Attribute att = (Attribute)obj;
        return Utilities.equals(this.id, att.getIdentifier());
    }

    public void validate() {
        Types.validate(this, this.getValue());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName()).append(":");
        sb.append(this.getDescriptor().getName().getLocalPart());
        if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || this.id != null) {
            sb.append("<");
            sb.append(this.getDescriptor().getType().getName().getLocalPart());
            if (this.id != null) {
                sb.append(" id=");
                sb.append(this.id);
            }
            sb.append(">");
        }
        sb.append("=");
        sb.append(this.value);
        return sb.toString();
    }

    protected Object parse(Object value) throws IllegalArgumentException {
        Object converted;
        Class<?> target;
        if (value != null && !(target = this.getType().getBinding()).isAssignableFrom(value.getClass()) && (converted = Converters.convert(value, target)) != null) {
            value = converted;
        }
        return value;
    }
}

