/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.palette;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import org.geotools.image.palette.CustomPaletteBuilder;

public class ColorReduction
extends PointOpImage {
    private int numColors;
    private int alphaThreshold;
    private CustomPaletteBuilder paletteBuilder;
    private boolean initialized = false;
    private RenderingHints hints;

    public ColorReduction(RenderedImage image, RenderingHints hints, int numColors, int alpaThreshold, int subsx, int subsy) {
        super(image, new ImageLayout(image), null, false);
        this.numColors = numColors;
        this.alphaThreshold = alpaThreshold;
        if (image.getColorModel().hasAlpha()) {
            RenderedOp alpha = BandSelectDescriptor.create(image, new int[]{image.getSampleModel().getNumBands() - 1}, null);
            alpha = MultiplyConstDescriptor.create(alpha, new double[]{this.alphaThreshold}, null);
            image = BandSelectDescriptor.create(image, new int[]{0, 1, 2}, null);
            ImageLayout layout = new ImageLayout();
            layout.setColorModel(new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 2, 0));
            image = BandMergeDescriptor.create(image, alpha, new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout)).getNewRendering();
            this.setSource(image, 0);
        }
        this.paletteBuilder = new CustomPaletteBuilder(image, this.numColors, subsx, subsy, 1);
        this.hints = hints;
    }

    private ImageLayout getImageLayout(RenderedImage image, RenderingHints hints) {
        ImageLayout layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
        if (layout == null) {
            layout = new ImageLayout(image);
        }
        layout.setColorModel(this.paletteBuilder.getIndexColorModel());
        layout.setSampleModel(this.paletteBuilder.getIndexColorModel().createCompatibleSampleModel(image.getWidth(), image.getHeight()));
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster computeTile(int tx, int ty) {
        ColorReduction colorReduction = this;
        synchronized (colorReduction) {
            if (!this.initialized) {
                this.paletteBuilder.buildPalette();
                this.setImageLayout(this.getImageLayout(this.getSourceImage(0), this.hints));
            }
        }
        PlanarImage sourceImage = this.getSourceImage(0);
        ColorModel sourceColorModel = sourceImage.getColorModel();
        Raster sourceRaster = sourceImage.getTile(tx, ty);
        int w = sourceRaster.getWidth();
        int h = sourceRaster.getHeight();
        int numBands = sourceRaster.getSampleModel().getNumBands();
        int[] rgba = new int[numBands];
        boolean sourceHasAlpha = sourceColorModel.hasAlpha();
        int alphaBand = sourceHasAlpha ? numBands - 1 : -1;
        int minx = sourceRaster.getMinX();
        int maxx = minx + w;
        int miny = sourceRaster.getMinY();
        int maxy = miny + h;
        WritableRaster destRaster = this.colorModel.createCompatibleWritableRaster(w, h).createWritableTranslatedChild(minx, miny);
        for (int i = minx; i < maxx; ++i) {
            for (int j = miny; j < maxy; ++j) {
                sourceRaster.getPixel(i, j, rgba);
                destRaster.setSample(i, j, 0, this.paletteBuilder.findNearestColorIndex(rgba, alphaBand));
            }
        }
        return destRaster;
    }
}

