/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.FactoryPrinter;
import org.geotools.resources.Arguments;
import org.geotools.resources.LazySet;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReferencingFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;
    private static Set<String> authorityNames;

    private ReferencingFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(ReferencingFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(new Class[]{DatumFactory.class, CSFactory.class, CRSFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CRSAuthorityFactory.class, MathTransformFactory.class, CoordinateOperationFactory.class, CoordinateOperationAuthorityFactory.class});
        }
        return registry;
    }

    public static synchronized Set<String> getAuthorityNames() {
        if (authorityNames == null) {
            authorityNames = new LinkedHashSet<String>();
            Hints hints = EMPTY_HINTS;
            int i = 0;
            block6: while (true) {
                Set<AuthorityFactory> factories;
                switch (i) {
                    case 0: {
                        factories = ReferencingFactoryFinder.getCRSAuthorityFactories(hints);
                        break;
                    }
                    case 1: {
                        factories = ReferencingFactoryFinder.getCSAuthorityFactories(hints);
                        break;
                    }
                    case 2: {
                        factories = ReferencingFactoryFinder.getDatumAuthorityFactories(hints);
                        break;
                    }
                    case 3: {
                        factories = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(hints);
                        break;
                    }
                    default: {
                        break block6;
                    }
                }
                for (AuthorityFactory factory : factories) {
                    Citation authority = factory.getAuthority();
                    if (authority == null) continue;
                    authorityNames.add(Citations.getIdentifier(authority));
                    for (Identifier identifier : authority.getIdentifiers()) {
                        authorityNames.add(identifier.getCode());
                    }
                }
                ++i;
            }
            authorityNames = Collections.unmodifiableSet(authorityNames);
        }
        return authorityNames;
    }

    private static synchronized <T extends Factory> Set<T> getFactories(Class<T> category, Hints hints) {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return new LazySet<T>(ReferencingFactoryFinder.getServiceRegistry().getServiceProviders(category, null, hints));
    }

    private static synchronized <T extends Factory> T getFactory(Class<T> category, Hints hints, Hints.Key key) throws FactoryRegistryException {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return (T)((Factory)ReferencingFactoryFinder.getServiceRegistry().getServiceProvider(category, null, hints, key));
    }

    private static synchronized <T extends AuthorityFactory> T getAuthorityFactory(Class<T> category, String authority, Hints hints, Hints.Key key) throws FactoryRegistryException {
        hints = ReferencingFactoryFinder.mergeSystemHints(hints);
        return (T)((AuthorityFactory)ReferencingFactoryFinder.getServiceRegistry().getServiceProvider(category, new AuthorityFilter(authority), hints, key));
    }

    public static DatumFactory getDatumFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(DatumFactory.class, hints, Hints.DATUM_FACTORY);
    }

    public static Set<DatumFactory> getDatumFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(DatumFactory.class, hints);
    }

    public static CSFactory getCSFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CSFactory.class, hints, Hints.CS_FACTORY);
    }

    public static Set<CSFactory> getCSFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CSFactory.class, hints);
    }

    public static CRSFactory getCRSFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CRSFactory.class, hints, Hints.CRS_FACTORY);
    }

    public static Set<CRSFactory> getCRSFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CRSFactory.class, hints);
    }

    public static CoordinateOperationFactory getCoordinateOperationFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(CoordinateOperationFactory.class, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static Set<CoordinateOperationFactory> getCoordinateOperationFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CoordinateOperationFactory.class, hints);
    }

    public static DatumAuthorityFactory getDatumAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getAuthorityFactory(DatumAuthorityFactory.class, authority, hints, Hints.DATUM_AUTHORITY_FACTORY);
    }

    public static Set<DatumAuthorityFactory> getDatumAuthorityFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(DatumAuthorityFactory.class, hints);
    }

    public static CSAuthorityFactory getCSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getAuthorityFactory(CSAuthorityFactory.class, authority, hints, Hints.CS_AUTHORITY_FACTORY);
    }

    public static Set<CSAuthorityFactory> getCSAuthorityFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CSAuthorityFactory.class, hints);
    }

    public static CRSAuthorityFactory getCRSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getAuthorityFactory(CRSAuthorityFactory.class, authority, hints, Hints.CRS_AUTHORITY_FACTORY);
    }

    public static Set<CRSAuthorityFactory> getCRSAuthorityFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CRSAuthorityFactory.class, hints);
    }

    public static CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, authority, hints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
    }

    public static Set<CoordinateOperationAuthorityFactory> getCoordinateOperationAuthorityFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(CoordinateOperationAuthorityFactory.class, hints);
    }

    public static MathTransformFactory getMathTransformFactory(Hints hints) throws FactoryRegistryException {
        return ReferencingFactoryFinder.getFactory(MathTransformFactory.class, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    public static Set<MathTransformFactory> getMathTransformFactories(Hints hints) {
        return ReferencingFactoryFinder.getFactories(MathTransformFactory.class, hints);
    }

    public static synchronized boolean setVendorOrdering(String vendor1, String vendor2) {
        return ReferencingFactoryFinder.getServiceRegistry().setOrdering(Factory.class, true, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static synchronized boolean unsetVendorOrdering(String vendor1, String vendor2) {
        return ReferencingFactoryFinder.getServiceRegistry().setOrdering(Factory.class, false, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static synchronized boolean setAuthorityOrdering(String authority1, String authority2) {
        return ReferencingFactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, true, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static synchronized boolean unsetAuthorityOrdering(String authority1, String authority2) {
        return ReferencingFactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, false, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static synchronized void addAuthorityFactory(AuthorityFactory authority) {
        if (registry == null) {
            ReferencingFactoryFinder.scanForPlugins();
        }
        ReferencingFactoryFinder.getServiceRegistry().registerServiceProvider(authority);
        authorityNames = null;
    }

    public static synchronized void removeAuthorityFactory(AuthorityFactory authority) {
        ReferencingFactoryFinder.getServiceRegistry().deregisterServiceProvider(authority);
        authorityNames = null;
    }

    public static synchronized boolean isRegistered(Factory factory) {
        return factory.equals(ReferencingFactoryFinder.getServiceRegistry().getServiceProviderByClass(factory.getClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanForPlugins() {
        Class<ReferencingFactoryFinder> clazz = ReferencingFactoryFinder.class;
        synchronized (ReferencingFactoryFinder.class) {
            authorityNames = null;
            if (registry != null) {
                registry.scanForPlugins();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            GeoTools.fireConfigurationChanged();
            return;
        }
    }

    public static synchronized void listProviders(Writer out, Locale locale) throws IOException {
        FactoryRegistry registry = ReferencingFactoryFinder.getServiceRegistry();
        new FactoryPrinter().list(registry, out, locale);
    }

    public static void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        try {
            ReferencingFactoryFinder.listProviders(arguments.out, arguments.locale);
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
        }
    }

    private static final class AuthorityFilter
    implements ServiceRegistry.Filter {
        private final String authority;

        public AuthorityFilter(String authority) {
            this.authority = authority;
        }

        public boolean filter(Object provider) {
            if (this.authority == null) {
                return false;
            }
            return Citations.identifierMatches(((AuthorityFactory)provider).getAuthority(), this.authority);
        }
    }

    private static final class VendorFilter
    implements ServiceRegistry.Filter {
        private final String vendor;

        public VendorFilter(String vendor) {
            this.vendor = vendor;
        }

        public boolean filter(Object provider) {
            return Citations.titleMatches(((Factory)provider).getVendor(), this.vendor);
        }
    }
}

