/*
 * Decompiled with CFR 0.152.
 */
package org.n52.math;

import org.n52.math.Vector3D;

public class TerrainTriangulation {
    private double lat = Double.NaN;
    private double lon = Double.NaN;
    private double phi;
    private double lam;
    private double sinphi;
    private double cosphi;
    private double sinlam;
    private double coslam;
    private final double a;
    private final double f;

    public TerrainTriangulation(double a, double fInv) {
        this.a = a;
        this.f = 1.0 / fInv;
    }

    public double getEquatorRadius() {
        return this.a;
    }

    public double getPhi() {
        return this.phi;
    }

    public double getLam() {
        return this.lam;
    }

    private void setLatLon(double lat, double lon) {
        if (this.lat != lat || this.lon != lon) {
            this.lat = lat;
            this.lon = lon;
            this.phi = lat * Math.PI / 180.0;
            this.lam = lon * Math.PI / 180.0;
            this.sinphi = Math.sin(this.phi);
            this.cosphi = Math.cos(this.phi);
            this.sinlam = Math.sin(this.lam);
            this.coslam = Math.cos(this.lam);
        }
    }

    public Vector3D getUnitVerticalVector(double lat, double lon) {
        this.setLatLon(lat, lon);
        Vector3D u = new Vector3D();
        u.set(0, this.coslam * this.cosphi);
        u.set(1, this.sinlam * this.cosphi);
        u.set(2, this.sinphi);
        return u;
    }

    public Vector3D getUnitNorthVector(double lat, double lon) {
        this.setLatLon(lat, lon);
        Vector3D u = new Vector3D();
        u.set(0, -this.sinphi * this.coslam);
        u.set(1, -this.sinphi * this.sinlam);
        u.set(2, this.cosphi);
        return u;
    }

    public Vector3D getUnitEastVector(double lat, double lon) {
        this.setLatLon(lat, lon);
        Vector3D u = new Vector3D();
        u.set(0, -this.sinlam);
        u.set(1, this.coslam);
        u.set(2, 0.0);
        return u;
    }

    public Vector3D getTerrainPositionVector(double lat, double lon) {
        this.setLatLon(lat, lon);
        Vector3D vec = new Vector3D();
        double e2 = 2.0 * this.f - this.f * this.f;
        double N = this.a / Math.sqrt(1.0 - e2 * this.sinphi * this.sinphi);
        vec.set(0, N * this.coslam * this.cosphi);
        vec.set(1, N * this.sinlam * this.cosphi);
        vec.set(2, N * (1.0 - e2) * this.sinphi);
        return vec;
    }
}

