/*
 * Decompiled with CFR 0.152.
 */
package org.n52.operation.cropmodeling;

import java.util.ArrayList;
import org.n52.operation.cropmodeling.JulianTime;
import org.n52.operation.cropmodeling.SawToothLeg;
import org.n52.operation.cropmodeling.TimeTemperature;
import org.n52.operation.cropmodeling.Weather;
import org.n52.operation.cropmodeling.WeatherData;

public class InterpolatedWeather
extends Weather {
    public InterpolatedWeather(WeatherData d) {
        super(d);
    }

    double getCurrentTemperature(JulianTime time) {
        if (this.weatherData.isUseRealData()) {
            return this.weatherData.getCurrentTemperatureFromData(time);
        }
        double temp1 = this.weatherData.getDayWeatherData(time).getAttributeData("TMin");
        double temp2 = this.weatherData.getDayWeatherData(time).getAttributeData("TMax");
        if (Double.isNaN(temp1) || Double.isNaN(temp2)) {
            this.approximateDesertLegs(time);
        }
        if (this.weatherData.isUseRealData()) {
            return this.weatherData.getCurrentTemperatureFromData(time);
        }
        return this.getWeightedTemperatureAverage(time);
    }

    private void approximateDesertLegs(JulianTime time) {
        JulianTime startTime = this.findBeginDesert(time);
        TimeTemperature[] ttemps = this.weatherData.getTemperatures(startTime);
        JulianTime currentTime = startTime;
        boolean inDesert = ttemps.length < 2;
        while (ttemps.length < 2) {
            JulianTime timeInNextInterval = currentTime.getTimeInNextInterval();
            ttemps = this.weatherData.getTemperatures(timeInNextInterval);
            currentTime = timeInNextInterval;
        }
        this.setEndDesertTMinTMax(currentTime);
        if (inDesert) {
            SawToothLeg[] correctionTemps;
            this.setBeginDesertTMinTMax(startTime.getTimeInPreviousInterval());
            TimeTemperature[] prevTemps = this.weatherData.getTemperatures(startTime.getTimeInPreviousInterval());
            SawToothLeg firstPair = new SawToothLeg(startTime.getTimeInPreviousInterval(), prevTemps, this.weatherData);
            SawToothLeg lastPair = new SawToothLeg(currentTime, ttemps, this.weatherData);
            SawToothLeg[] sawToothLegArray = correctionTemps = this.getCorrectionTemps(firstPair, lastPair);
            int n = 0;
            int n2 = sawToothLegArray.length;
            while (n < n2) {
                SawToothLeg leg = sawToothLegArray[n];
                JulianTime legTime = leg.getLegIndex() % 2 == 0 ? JulianTime.subtract(leg.getMinNode().getTime(), 1.0) : JulianTime.subtract(leg.getMaxNode().getTime(), 1.0);
                this.weatherData.getDayWeatherData(legTime).setAttributeData("TMax", leg.getMaxNode().getTemperature());
                this.weatherData.getDayWeatherData(legTime).setAttributeData("TMin", leg.getMinNode().getTemperature());
                ++n;
            }
        } else {
            this.setBeginDesertTMinTMax(startTime);
        }
    }

    void setEndDesertTMinTMax(JulianTime time) {
        JulianTime timeInNextInterval = time.getTimeInNextInterval();
        TimeTemperature[] currentTemps = this.weatherData.getTemperatures(time);
        if (currentTemps == null || currentTemps.length < 2) {
            this.approximateDesertLegs(time);
            return;
        }
        TimeTemperature[] nextTemps = this.weatherData.getTemperatures(timeInNextInterval);
        if (nextTemps == null || nextTemps.length < 2) {
            SawToothLeg leg = new SawToothLeg(time, currentTemps, this.weatherData);
            this.weatherData.getDayWeatherData(time).setAttributeData("TMin", leg.getMinNode().getTemperature());
            this.weatherData.getDayWeatherData(time).setAttributeData("TMax", leg.getMaxNode().getTemperature());
        } else {
            SawToothLeg nextLeg = new SawToothLeg(timeInNextInterval, nextTemps, this.weatherData);
            SawToothLeg currentLeg = new SawToothLeg(time, currentTemps, this.weatherData);
            this.removeDiscontinuity(currentLeg, nextLeg);
            this.weatherData.getDayWeatherData(time).setAttributeData("TMin", currentLeg.getMinNode().getTemperature());
            this.weatherData.getDayWeatherData(time).setAttributeData("TMax", currentLeg.getMaxNode().getTemperature());
            this.weatherData.getDayWeatherData(timeInNextInterval).setAttributeData("TMax", nextLeg.getMaxNode().getTemperature());
            this.weatherData.getDayWeatherData(timeInNextInterval).setAttributeData("TMin", nextLeg.getMinNode().getTemperature());
        }
    }

    void setBeginDesertTMinTMax(JulianTime time) {
        JulianTime timeInPreviousInterval = time.getTimeInPreviousInterval();
        TimeTemperature[] currentTemps = this.weatherData.getTemperatures(time);
        TimeTemperature[] previousTemps = this.weatherData.getTemperatures(timeInPreviousInterval);
        if (currentTemps == null || currentTemps.length < 2) {
            JulianTime firstTime = time.getTimeInNextInterval();
            TimeTemperature[] cTemps = this.weatherData.getTemperatures(firstTime);
            SawToothLeg leg = new SawToothLeg(firstTime, cTemps, this.weatherData);
            this.weatherData.getDayWeatherData(time).setAttributeData("TMin", leg.getMinNode().getTemperature());
            this.weatherData.getDayWeatherData(time).setAttributeData("TMax", leg.getMaxNode().getTemperature());
        } else if (previousTemps == null || previousTemps.length < 2) {
            SawToothLeg leg = new SawToothLeg(time, currentTemps, this.weatherData);
            this.weatherData.getDayWeatherData(time).setAttributeData("TMin", leg.getMinNode().getTemperature());
            this.weatherData.getDayWeatherData(time).setAttributeData("TMax", leg.getMaxNode().getTemperature());
        } else {
            SawToothLeg previousLeg = new SawToothLeg(timeInPreviousInterval, previousTemps, this.weatherData);
            SawToothLeg currentLeg = new SawToothLeg(time, currentTemps, this.weatherData);
            this.removeDiscontinuity(previousLeg, currentLeg);
            this.weatherData.getDayWeatherData(time).setAttributeData("TMin", currentLeg.getMinNode().getTemperature());
            this.weatherData.getDayWeatherData(time).setAttributeData("TMax", currentLeg.getMaxNode().getTemperature());
            this.weatherData.getDayWeatherData(timeInPreviousInterval).setAttributeData("TMax", previousLeg.getMaxNode().getTemperature());
            this.weatherData.getDayWeatherData(timeInPreviousInterval).setAttributeData("TMin", previousLeg.getMinNode().getTemperature());
        }
    }

    void removeDiscontinuity(SawToothLeg leftBendPointLeg, SawToothLeg rightBendPointLeg) {
        if (leftBendPointLeg.getMinNode().getTime().equals(rightBendPointLeg.getMinNode().getTime())) {
            double left = leftBendPointLeg.getMinNode().getTemperature();
            double right = rightBendPointLeg.getMinNode().getTemperature();
            leftBendPointLeg.getMinNode().setTemperature((left + right) / 2.0);
            rightBendPointLeg.getMinNode().setTemperature((left + right) / 2.0);
        } else {
            double left = leftBendPointLeg.getMaxNode().getTemperature();
            double right = rightBendPointLeg.getMaxNode().getTemperature();
            leftBendPointLeg.getMaxNode().setTemperature((left + right) / 2.0);
            rightBendPointLeg.getMaxNode().setTemperature((left + right) / 2.0);
        }
    }

    void computeLinearTrendCoeffs(SawToothLeg firstPair, SawToothLeg lastPair, double[] result) {
        double firstLegMax = firstPair.getMaxNode().getTemperature();
        double firstLegMin = firstPair.getMinNode().getTemperature();
        double lastLegMax = lastPair.getMaxNode().getTemperature();
        double lastLegMin = lastPair.getMinNode().getTemperature();
        result[0] = (lastLegMax - firstLegMax) / (lastPair.getMaxNode().getTime().getYearHours() - firstPair.getMaxNode().getTime().getYearHours());
        result[1] = (lastLegMin - firstLegMin) / (lastPair.getMinNode().getTime().getYearHours() - firstPair.getMinNode().getTime().getYearHours());
    }

    private SawToothLeg[] getCorrectionTemps(SawToothLeg beginTTP, SawToothLeg endTTP) {
        SawToothLeg[] linearTemps;
        int desertSize = endTTP.getLegIndex() - beginTTP.getLegIndex() - 1;
        if (desertSize == 1) {
            linearTemps = new SawToothLeg[]{new SawToothLeg()};
            if (beginTTP.getLegIndex() % 2 == 0) {
                linearTemps[0].getMinNode().setTemperature(beginTTP.getMinNode().getTemperature());
                linearTemps[0].getMinNode().setTime(beginTTP.getMinNode().getTime());
                linearTemps[0].getMaxNode().setTemperature(endTTP.getMaxNode().getTemperature());
                linearTemps[0].getMaxNode().setTime(endTTP.getMaxNode().getTime());
            } else {
                linearTemps[0].getMinNode().setTemperature(endTTP.getMinNode().getTemperature());
                linearTemps[0].getMinNode().setTime(endTTP.getMinNode().getTime());
                linearTemps[0].getMaxNode().setTemperature(beginTTP.getMaxNode().getTemperature());
                linearTemps[0].getMaxNode().setTime(beginTTP.getMaxNode().getTime());
            }
        } else {
            double[] res = new double[2];
            this.computeLinearTrendCoeffs(beginTTP, endTTP, res);
            linearTemps = this.getLinearTemps(beginTTP, endTTP, res);
        }
        return linearTemps;
    }

    private SawToothLeg[] getLinearTemps(SawToothLeg firstPair, SawToothLeg lastPair, double[] result) {
        ArrayList<SawToothLeg> legs = new ArrayList<SawToothLeg>();
        JulianTime twoOClockTime = firstPair.getMaxNode().getTime();
        while (JulianTime.lesseq(twoOClockTime, lastPair.getMaxNode().getTime())) {
            boolean isBeginLoop = JulianTime.eq(twoOClockTime, firstPair.getMaxNode().getTime());
            SawToothLeg legUp = new SawToothLeg();
            SawToothLeg legDownNext = new SawToothLeg();
            legUp.getMaxNode().setTime(twoOClockTime);
            legUp.getMaxNode().setTemperature(result[1] * (twoOClockTime.getYearHours() - firstPair.getMaxNode().getTime().getYearHours()) + firstPair.getMaxNode().getTemperature());
            if (!isBeginLoop) {
                legUp.getMinNode().setTime(twoOClockTime.getSunRiseToday());
                legUp.getMinNode().setTemperature(result[0] * (legUp.getMinNode().getTime().getYearHours() - firstPair.getMinNode().getTime().getYearHours()) + firstPair.getMinNode().getTemperature());
            }
            legDownNext.getMaxNode().setTime(twoOClockTime);
            legDownNext.getMaxNode().setTemperature(legUp.getMaxNode().getTemperature());
            legs.add(legUp);
            legs.add(legDownNext);
            if (!isBeginLoop) {
                SawToothLeg previousLeg = (SawToothLeg)legs.get(legs.size() - 3);
                previousLeg.getMinNode().setTemperature(legUp.getMinNode().getTemperature());
                previousLeg.getMinNode().setTime(legUp.getMinNode().getTime());
                legs.set(legs.size() - 3, previousLeg);
            }
            twoOClockTime = JulianTime.add(twoOClockTime, 24.0);
        }
        int i = legs.size() - 1;
        while (i >= 0) {
            if (!((SawToothLeg)legs.get(i)).isValid()) {
                legs.remove(i);
            }
            --i;
        }
        return legs.toArray(new SawToothLeg[0]);
    }

    /*
     * Unable to fully structure code
     */
    private JulianTime findBeginDesert(JulianTime currentTime) {
        ttemps = this.weatherData.getTemperatures(currentTime);
        if (ttemps.length <= 1) ** GOTO lbl7
        return currentTime;
lbl-1000:
        // 1 sources

        {
            timeInPrevInterval = currentTime.getTimeInPreviousInterval();
            ttemps = this.weatherData.getTemperatures(timeInPrevInterval);
            currentTime = timeInPrevInterval;
lbl7:
            // 2 sources

            ** while (ttemps.length < 2)
        }
lbl8:
        // 1 sources

        return currentTime.getTimeInNextInterval();
    }

    private double getWeightedTemperatureAverage(JulianTime time) {
        return this.getTemperatureFromSinExponCurve(time);
    }

    private double getTemperatureFromSinExponCurve(JulianTime time) {
        double tempOut;
        double param = 2.0;
        double TC = 4.0;
        JulianTime midnightYesterday = time.Get12pmYesterday();
        JulianTime sunriseToday = time.getSunRiseToday();
        JulianTime middayToday = time.getMiddayToday();
        JulianTime sunsetToday = time.getSunSetToday();
        JulianTime afternoon = JulianTime.add(time.getMiddayToday(), param / 2.0);
        JulianTime PreviousAfternoon = JulianTime.subtract(afternoon, 24.0);
        JulianTime previousMorning = JulianTime.subtract(time.getMiddayToday(), 25.0);
        JulianTime NextAfternoon = JulianTime.add(afternoon, 24.0);
        this.setBeginDesertTMinTMax(time.getTimeInPreviousInterval());
        this.setEndDesertTMinTMax(time.getTimeInNextInterval());
        double minTemp = this.weatherData.getDayWeatherData(PreviousAfternoon).getAttributeData("TMin");
        double maxTemp = this.weatherData.getDayWeatherData(sunriseToday).getAttributeData("TMax");
        double maxTempBefore = this.weatherData.getDayWeatherData(previousMorning).getAttributeData("TMax");
        this.setEndDesertTMinTMax(NextAfternoon);
        double minTempAfter = this.weatherData.getDayWeatherData(afternoon).getAttributeData("TMin");
        if (Double.isNaN(maxTempBefore)) {
            maxTempBefore = maxTemp;
        }
        if (Double.isNaN(minTempAfter)) {
            minTempAfter = minTemp;
        }
        double dl = time.getDayLength();
        double hour = time.getYearHours() % 24.0;
        double tempFraction = Math.sin(Math.PI * (dl / (dl + 2.0 * param)));
        double tsunst1 = minTemp + (maxTempBefore - minTemp) * tempFraction;
        double tsunst2 = minTempAfter + (maxTemp - minTempAfter) * tempFraction;
        double exp1 = Math.exp(-(24.0 - dl) / TC);
        double sunsetSolar = sunsetToday.getYearHours() - midnightYesterday.getYearHours();
        double sunriseSolar = sunriseToday.getYearHours() - midnightYesterday.getYearHours();
        if (JulianTime.moreeq(time, midnightYesterday) && JulianTime.lesseq(time, sunriseToday)) {
            double exp2 = Math.exp(-(hour + 24.0 - sunsetSolar) / TC);
            tempOut = (minTemp - tsunst1 * exp1 + (tsunst1 - minTemp) * exp2) / (1.0 - exp1);
        } else if (JulianTime.more(time, sunriseToday) && JulianTime.lesseq(time, middayToday)) {
            tempOut = minTemp + (maxTemp - minTemp) * Math.sin(Math.PI * (hour - sunriseSolar) / (dl + 2.0 * param));
        } else if (JulianTime.more(time, middayToday) && JulianTime.lesseq(time, sunsetToday)) {
            tempOut = minTempAfter + (maxTemp - minTempAfter) * Math.sin(Math.PI * (hour - sunriseSolar) / (dl + 2.0 * param));
        } else {
            double exp2 = Math.exp(-(hour - sunsetSolar) / TC);
            tempOut = (minTempAfter - tsunst2 * exp1 + (tsunst2 - minTempAfter) * exp2) / (1.0 - exp1);
        }
        return tempOut;
    }
}

